/* Message.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;

import java.util.*;




public class Message {

    public static Message NONE = new Message('0');
    public static Message HELLO = new Message('h');
    public static Message POS = new Message('p');
    public static Message DIR = new Message('d');
    public static Message QUIT = new Message('q');
    public static Message ID = new Message('i');
    public static Message ECHO = new Message('e');
    public static Message RECONNECT = new Message('r');
    public static Message ROUND = new Message('n');
    public static Message LOOP = new Message('l');

    public boolean equals(Object m) {
	if(((Message)m).get() == msg)
	    return true;

	return false;
    }

    public int hashCode() {
	return (new Character(msg)).hashCode();
    }


    private char msg;

    Message(char c) {
	msg = c;
    }

    public char get() {
	return msg;
    }

    public static Message generate(char b) {
	return new Message(b);
    }
}
