/* Netzack.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.event.*;
import java.nio.*;



public class Netzack {



    public static void verbose(String s) {
	if(System.getenv("ZATACKA_VERBOSE") != null)
	    System.err.println(s);
    }

    public static void debug(String s) {
	if(System.getenv("ZATACKA_DEBUG") != null)
	    System.err.println(s);
    }

    public static void error(String s) {
	System.err.println(s);
    }

    public static void error(Exception e) {
	e.printStackTrace();
    }


    public static void debug(Exception e) {
	if(System.getenv("ZATACKA_DEBUG") != null)
	    e.printStackTrace();
    }

    public static void main(String[] args) {

	String name = "";
	Color color = Config.COLOR;
	int FPS = Config.FPS;
	int port = Config.PORT;
	String group = Config.GROUP;

	for(int i = 0; i < args.length; i++) {
	    if(args[i].equalsIgnoreCase("-version") || args[i].equalsIgnoreCase("--version")) {

		System.out.println(Config.COPYRIGHT);
		System.out.println(Config.NOTICE);
		System.exit(0);
	    }
	    else if(args[i].equalsIgnoreCase("-n")) {
		if(i < args.length - 1) {
		    name = args[++i];
		}
		else
		    System.exit(2);
	    }
	    else if(args[i].equalsIgnoreCase("-c")) {
		if(i < args.length - 1) {
		    try {
			color = new Color(Integer.parseInt(args[++i], 16));
		    }
		    catch(NumberFormatException e) {
			System.exit(2);
		    }
		}
		else
		    System.exit(2);

	    }
	    else if(args[i].equalsIgnoreCase("-f")) {
		if(i < args.length - 1) {
		    try {
			FPS = Integer.parseInt(args[++i]);
		    }
		    catch(NumberFormatException e) {
			System.exit(2);
		    }
		}
		else
		    System.exit(2);

	    }
	    else if(args[i].equalsIgnoreCase("-g")) {
		if(i < args.length - 1) {
		    group = args[++i];
		}
		else
		    System.exit(2);
	    }
	    else if(args[i].equalsIgnoreCase("-p")) {
		if(i < args.length - 1) {
		    try {
			port = Integer.parseInt(args[++i]);
		    }
		    catch(NumberFormatException e) {
			System.exit(2);
		    }
		}
		else
		    System.exit(2);

	    }
	    else if(args[i].equalsIgnoreCase("-h") || args[i].equalsIgnoreCase("--help")) {
		System.exit(2);
	    }
	}

	Object lock = new Object();

	ZInitDialog dlg = new ZInitDialog(lock, name, color);

	synchronized(lock) {
	    try {
		lock.wait();
		name = dlg.getNickname();
		color = dlg.getColor();

		Game game = new Game(FPS, group, port, name, color);

		game.start();

	    }
	    catch(InterruptedException e) {

	    }
	}


    }



}


