/* PublicChannel.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.net.*;
import java.lang.*;
import java.io.*;
import java.util.*;




public class PublicChannel extends Thread {

    MulticastSocket socket;
    Server server;
    PrivateChannel priv;

    Object lock;

    PublicChannel(Server s, Object l) {
	super("PublicChannel");
	lock = l;
	try {
	    socket = new MulticastSocket(Server.PUBLIC_PORT);
	    socket.setTimeToLive(Config.TTL);
	    socket.joinGroup(Server.GROUP);

	}
	catch(IOException e) {
	    Netzack.error(e);
	}

	server = s;

	Object lock2 = new Object();
	synchronized(lock2) {
	    priv = new PrivateChannel(server, lock2);

	    try {
		lock2.wait();
	    }
	    catch(InterruptedException e) {

	    }
	}

	start();
    }


    protected void finalize() throws Throwable {
	try {
	    socket.leaveGroup(Server.GROUP);
	    socket.close();
	}
	finally {
	    super.finalize();
	}
    }


    public void run() {
	if(!socket.isBound()) {
	    Netzack.debug("Premature exit: PublicChannel thread");
	    return;
	}

	synchronized(lock) {
	    lock.notify();
	}


	Packet p = new Packet();

	try {
	    while(true) {

		//Get data...

		DatagramPacket recv = p.receive(socket);

		//...and handle it

		int id = p.readInt();

		if(id == server.id)
		       continue;

		Message m = p.getMsg();

		//Netzack.debug("<Pub> m:" + m.get() + " i:" + id + " l:" + recv.getLength());

		if(m.equals(Message.ECHO)) {
		    Packet s = null;
		    if(p.readBoolean()) {
			s = Packet.echoPacket(server.getPort(), Server.localAddress.getAddress());
		    }
		    else
			s = Packet.echoPacket();

		    if(s != null) {
			priv.send(s, recv.getSocketAddress());
			s.release();
		    }
		}
		else if(m.equals(Message.RECONNECT)) {
		    int to = p.readInt();

		    int port = p.readInt();
		    byte[] ip = (byte[])p.readObject();
		    //InetAddress peer = (InetAddress)p.readObject();
		    InetAddress peer = InetAddress.getByAddress(ip);
		    server.reconnect(to, peer, port);

		}

	    }
	}
	catch(IOException e) {
	    Netzack.debug(e);
	}

	p.release();
    }


    public void send(Packet p) {
	priv.send(p);
	p.release();
    }

}



