/* Swatch.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import javax.swing.*;
import java.awt.*;
import java.util.*;
import java.awt.event.*;


class Swatch extends JPanel implements MouseListener{

    Vector colors = new Vector(30);
    Color selected = Color.red;

    final static int side = 13;
    final static int padding = 3;

    Swatch() {
	int step = 255/3;
	for(int i = 0; i < 256; i += step) {
	    colors.add(new Color(255, i, 0));
	}

	for(int i = 256 - step; i >= 0; i -= step) {
	    colors.add(new Color(i, 255, 0));
	}

	for(int i = step; i < 256; i += step) {
	    colors.add(new Color(0, 255, i));
	}

	for(int i = 256 - step; i >= 0; i -= step) {
	    colors.add(new Color(0, i, 255));
	}

	for(int i = step; i < 256; i += step) {
	    colors.add(new Color(i, 0, 255));
	}

	for(int i = 256 - step; i > step; i -= step) {
	    colors.add(new Color(255, 0, i));
	}

	setPreferredSize(new Dimension(colors.size()*(side+padding)+padding, (side+padding)*2+padding));
	addMouseListener(this);
    }

    public void update(Graphics g) {

	paint(g);
    }

    public void paint(Graphics g) {
	super.paint(g);
	int x = padding;
	int y = padding;
	for(int i = 0; i < colors.size(); i++) {
	    g.setColor((Color)colors.get(i));
	    g.fill3DRect(x, y, side, side, true);

	    x += side + padding;
	}

	g.setColor(selected);
	g.fill3DRect(padding, y + side + padding, x - 2*padding, side, true);


    }

    public void mouseClicked(MouseEvent e) {
	int x = e.getX();
	int y = e.getY();



	if(y > (padding + side)
	   || y < padding)
	    return;

	if(x > (padding + side)*colors.size() ||
	   x < padding)
	    return;

	selected = (Color)colors.get((x - x % (side + padding))/(side + padding));
	repaint();
    }

    public void mouseEntered(MouseEvent e) {

    }

    public void mouseExited(MouseEvent e) {

    }

    public void mousePressed(MouseEvent e) {

    }

    public void mouseReleased(MouseEvent e) {
    }


    public Color getSelected() {
	return selected;
    }

    public void setSelected(Color c) {
	selected = c;
    }


}
