/* ZCanvas.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import se.kth.netzack.*;
import java.util.*;
import java.awt.*;
import javax.swing.*;
import java.lang.*;
import java.awt.geom.*;
import java.awt.image.*;
import java.awt.event.*;



public class ZCanvas extends Canvas {

    private Map players;

    final static BasicStroke stroke = new BasicStroke(Config.wormWidth);


    private VolatileImage img;
    private short[][] hit = new short[Config.X][Config.Y];

    short n = 0;
    Graphics2D g2;

    ZCanvas(Map p) {
	players = p;

	setBackground(Color.white);
	setSize(new Dimension(Config.X + 2*Config.BORDER, Config.Y + 2*Config.BORDER));

	setIgnoreRepaint(false);

	setVisible(true);

	clear();

    }

    public void initBuffers() {
    }

    public void clear() {
	img = null;
	for(int i = 0; i < Config.X; i++) {
	    for(int j = 0; j < Config.Y; j++) {
		hit[i][j] = 0;
	    }
	}

    }


    public int paintWorms(long elapsed) {

	if(img == null || hit == null) {
	    img = createVolatileImage(Config.X, Config.Y);

	    g2 = (Graphics2D)img.getGraphics();
	    g2.setColor(Color.black);
	    g2.fillRect(0, 0, img.getWidth(), img.getHeight());

	}

	int playing = 0;
	n++;
	if(n == 0)
	    n = 1;

	g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);

	synchronized(players) {
	    Iterator i = players.values().iterator();
	    Player p;
	    while(i.hasNext()) {
		p = (Player)i.next();
		if(p.isPlaying) {
		    try {
			p.worm.paint(g2, hit, elapsed, n);
		    }
		    catch(DeadException e) {
			p.youDied();
		    }
		    playing++;
		}
	    }
	}


	repaint();

	return playing;
    }

    public void update(Graphics g)
    {
	if(img != null)
	    g.drawImage(img, Config.BORDER, Config.BORDER, this);

    }

    public void paint(Graphics g) {

	Color[] c = new Color[Config.BORDER];
	c[Config.BORDER - 1] = Color.white.darker();
	for(int i = Config.BORDER - 2; i >= 0; i--) {
	    c[i] = c[i + 1].darker();
	}

	for(int i = 0; i < Config.BORDER; i++) {
	    g.setColor(c[i]);
	    g.drawRect(i, i, Config.X + 2*(Config.BORDER - i) - 1, Config.Y + 2*(Config.BORDER - i) - 1);
	}

	if(img != null)
	    g.drawImage(img, Config.BORDER, Config.BORDER, this);
	else {
	    g.setColor(Color.black);
	    g.fillRect(Config.BORDER, Config.BORDER, Config.X, Config.Y);
	}

    }


}
