/* ZConsole.java
 * Copyright (C) 2007, 2008 Gustav Behm <gbehm (at) kth.se>
 *
 * This file is part of Netzack.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */


package se.kth.netzack;
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import javax.swing.Timer;



public class ZConsole extends Canvas {

    private class Msg {
	public String value;
	public Msg next = null;
	public Color color = Config.CONSOLE_COLOR;
	private ZConsole console;
	public boolean prune = false;

	ActionListener wait = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    t = new Timer(100, fade);
		    t.start();
		}
	    };

	ActionListener fade = new ActionListener() {
		public void actionPerformed(ActionEvent e) {
		    color = color.darker();

		    if(color.getRed() < 60){
			t.stop();
			prune = true;
		    }

		    console.update();
		}
	    };


	Timer t = new Timer(Config.MSG_TIMEOUT, wait);


	Msg() {

	}

	Msg(ZConsole c, Msg n, String str) {
	    console = c;
	    value = str;
	    next = n;
	    t.start();
	}

	void reset() {
	    if(next != null)
		next.reset();
	    next = null;
	    t.stop();
	}




    }







    private VolatileImage img;
    private Graphics g;

    int Y = 0;
    int border = 0;
    int line = 0;
    Font font = null;

    private static int CAPACITY = 4;

    private Msg latest = new Msg();

    ZConsole() {
	setVisible(true);
    }

    void init() {
	font = new Font(Config.FONT, Font.PLAIN, Config.FONT_SIZE);
	line = getGraphics().getFontMetrics(font).getHeight();
	Y = line*(CAPACITY);
	border = (int)Math.round(0.3*(double)line);
	setSize(getWidth(), Y);

	img = createVolatileImage(getWidth(), Y);
	if(img == null)
	    return;
	g = img.getGraphics();

	update();

    }

    void print(String str) {
	String[] msgs = str.split("\n");

	for(int i = 0; i < msgs.length; i++){
	    if(msgs[i].length() != 0)
		latest = new Msg(this, latest, msgs[i]);
	}

	update();
    }

    void update() {
	if(img == null)
	    return;

	synchronized(img) {
	    g.setColor(Color.black);
	    g.fillRect(0, 0, getWidth(), Y);


	    g.setFont(font);

	    int n = 1;
	    Msg itr = latest;
	    while(itr != null) {
		if(n > CAPACITY || itr.prune) {
		    itr.reset();
		    itr = null;
		    break;
		}
		else if(itr.value != null) {
		    g.setColor(itr.color);
		    g.drawString(itr.value, border, Y - border - (n - 1) * Config.FONT_SIZE);
		}
		itr = itr.next;
		n++;
	    }
	}

	repaint();
    }

    public void update(Graphics g)
    {
	paint(g);
    }

    public void paint(Graphics g) {
	synchronized(img) {
	    g.drawImage(img, 0, 0, this);
	}
    }


}



