/* $Id: charmap.c,v 1.4 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#include "config.h"
#include <stdio.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif
#include "compat.h"
#include <nhproxy/system.h>
#include <nhproxy/xdr.h>
#include <nhproxy/common.h>
#include <nhproxy/client.h>

long *
nhproxy_map_glyph2char(glyph_map)
struct nhproxy_cb_get_glyph_mapping_res *glyph_map;
{
    int glyph = 0;
    struct nhproxy_glyph_map_info info;
    struct nhproxy_glyph_mapping *mapping;
    long *glyph2rgbsym;
    glyph2rgbsym = (long *)malloc(glyph_map->no_glyph * sizeof(long));
    if (!glyph2rgbsym)
	return (long *)0;
    mapping = nhproxy_glyph_map_first(&info, glyph_map);
    while (mapping) {
	glyph2rgbsym[glyph++] = mapping->rgbsym;
	mapping = nhproxy_glyph_map_next(&info);
    }
    nhproxy_glyph_map_close(&info);
    return glyph2rgbsym;
}
