/* $Id: client.h,v 1.12 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2003, 2004  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef NHPROXY_CLIENT_H
#define NHPROXY_CLIENT_H

#ifdef __cplusplus
extern "C" {
#endif

#define NHPROXY_CLNT_SYNCHRONOUS	1

struct nhproxy_tilemap_entry {
    unsigned int tile;
    unsigned int refs;
    unsigned int no_descs;
    char **descs;
};

struct nhproxy_tilemap {
    unsigned int no_entries;		/* One tile may have several entries */
    unsigned int no_tiles;
    unsigned int max_entries;		/* No. allocted entries */
    struct nhproxy_tilemap_entry *entries;
};

#define NHPROXY_LEVEL_MAPPING		0
#define NHPROXY_LEVEL_FLAGS		1
#define NHPROXY_LEVEL_SUBMAPPING	2
#define NHPROXY_LEVEL_GLYPH		3
#define NHPROXY_LEVEL_BASED_MAPPING	4
#define NHPROXY_LEVEL_BASED_SUBMAPPING	5
#define NHPROXY_LEVEL_BASED_GLYPH	6
#define NHPROXY_MAX_NO_LEVELS		7

struct nhproxy_glyph_mapping {
    unsigned long rgbsym;
    int alt_glyph;
    unsigned int no_descs;
    const char **descs;
};

struct nhproxy_glyph_map_info {
    struct nhproxy_glyph_mapping current;
    struct nhproxy_cb_get_glyph_mapping_res *glyph_map;
    int mi, smi, gi, bsmi, bgi;
    const char *descs[NHPROXY_MAX_NO_LEVELS];
};

struct nhproxy_clnt_ext_procs {
    const char *name;
    int NHPROXY_FDECL((*winext_init_nhwindows), (int *argc, char **argv,
      char ***capv));
    int NHPROXY_FDECL((*winext_player_selection), (int *role, int *race,
      int *gend, int *align));
    char *NHPROXY_NDECL((*winext_askname));
    void NHPROXY_NDECL((*winext_get_nh_event)) ;
    void NHPROXY_FDECL((*winext_exit_nhwindows), (const char *str));
    void NHPROXY_FDECL((*winext_suspend_nhwindows), (const char *str));
    void NHPROXY_NDECL((*winext_resume_nhwindows));
    int NHPROXY_FDECL((*winext_create_nhwindow), (int type));
    void NHPROXY_FDECL((*winext_clear_nhwindow), (int window, int rows,
      int cols, int layers));
    void NHPROXY_FDECL((*winext_display_nhwindow), (int window,
      NHPROXY_BOOLEAN_P blocking));
    void NHPROXY_FDECL((*winext_destroy_nhwindow), (int window));
    void NHPROXY_FDECL((*winext_curs), (int window, int x, int y));
    void NHPROXY_FDECL((*winext_putstr), (int window, int attr,
      const char *str));
    void NHPROXY_FDECL((*winext_display_file), (int fh));
    void NHPROXY_FDECL((*winext_start_menu), (int window));
    void NHPROXY_FDECL((*winext_add_menu), (int window, int glyph,
      int identifier, NHPROXY_CHAR_P accelerator, NHPROXY_CHAR_P groupacc,
      int attr, const char *str, NHPROXY_BOOLEAN_P preselected));
    void NHPROXY_FDECL((*winext_end_menu), (int window, const char *prompt));
    int NHPROXY_FDECL((*winext_select_menu), (int window, int how,
      struct nhproxy_mi **selected));
    int NHPROXY_FDECL((*winext_message_menu), (int let, int how,
      const char *mesg));
    void NHPROXY_NDECL((*winext_update_inventory));
    void NHPROXY_NDECL((*winext_mark_synch));
    void NHPROXY_NDECL((*winext_wait_synch));
    void NHPROXY_FDECL((*winext_cliparound), (int x, int y));
    void NHPROXY_FDECL((*winext_update_positionbar), (char *posbar));
    void NHPROXY_FDECL((*winext_print_glyph), (int window, int x, int y,
      int glyph));
    void NHPROXY_FDECL((*winext_raw_print), (const char *str));
    void NHPROXY_FDECL((*winext_raw_print_bold), (const char *str));
    int NHPROXY_NDECL((*winext_nhgetch));
    int NHPROXY_FDECL((*winext_nh_poskey), (int *x, int *y, int *mod));
    void NHPROXY_NDECL((*winext_nhbell));
    int NHPROXY_NDECL((*winext_doprev_message));
    char NHPROXY_FDECL((*winext_yn_function), (const char *ques,
      const char *choices, NHPROXY_CHAR_P def, int *count));
    char *NHPROXY_FDECL((*winext_getlin), (const char *ques));
    int NHPROXY_NDECL((*winext_get_ext_cmd));
    void NHPROXY_FDECL((*winext_number_pad), (int state));
    void NHPROXY_NDECL((*winext_delay_output));
    void NHPROXY_FDECL((*winext_change_color), (int color, long rgb,
      int reverse));
    void NHPROXY_FDECL((*winext_change_background), (int white_or_black));
    int NHPROXY_FDECL((*winext_set_font_name), (int window, char *font));
    char *NHPROXY_NDECL((*winext_get_color_string));
    void NHPROXY_NDECL((*winext_start_screen));
    void NHPROXY_NDECL((*winext_end_screen));
    int NHPROXY_FDECL((*winext_outrip), (int window, char *killed_by));
    void NHPROXY_FDECL((*winext_preference_update), (const char *optnam,
      const char *value));
    void NHPROXY_FDECL((*winext_status), (int reconfig, int nv,
      const char **values));
    void NHPROXY_FDECL((*winext_print_glyph_layered), (int window, int nl,
      struct nhproxy_glyph_layer *layers));
    void NHPROXY_FDECL((*winext_send_config_file), (int fh));
};

typedef nhproxy_bool_t NHPROXY_FDECL((*nhproxy_clnt_authhandler),
  (unsigned long mask));

extern void NHPROXY_FDECL(nhproxy_clnt_set_ext_procs,
  (void NHPROXY_NDECL((*ini_routine)),
  struct nhproxy_clnt_ext_procs *windowprocs));
extern char *NHPROXY_FDECL(nhproxy_clnt_gettag, (const char *tag));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_clnt_settag, (const char *tag,
  const char *value));
extern void NHPROXY_FDECL(nhproxy_clnt_set_flags, (unsigned long mask,
  unsigned long value));
#ifdef NHPROXY_XDR_H
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_clnt_log_open,
  (nhproxy_io_func func, nhproxy_genericptr_t handle));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_clnt_tryaccept,
  (nhproxy_io_func read_f, nhproxy_genericptr_t read_h, nhproxy_io_func write_f,
  nhproxy_genericptr_t write_h));
#endif
extern int NHPROXY_NDECL(nhproxy_clnt_main_iteration);
extern char *NHPROXY_FDECL(nhproxy_clnt_get_failed_packet, (int *nb));
extern char *NHPROXY_FDECL(nhproxy_clnt_get_extension, (const char *name,
  const char *min_ver, const char *next_ver, unsigned short *idp));
extern nhproxy_clnt_authhandler NHPROXY_FDECL(nhproxy_clnt_set_authhandler,
  (nhproxy_clnt_authhandler new));

extern struct nhproxy_glyph_mapping *NHPROXY_FDECL(nhproxy_glyph_map_first,
  (struct nhproxy_glyph_map_info *info,
  struct nhproxy_cb_get_glyph_mapping_res *glyph_map));
extern struct nhproxy_glyph_mapping *NHPROXY_FDECL(nhproxy_glyph_map_next,
  (struct nhproxy_glyph_map_info *info));
extern void NHPROXY_FDECL(nhproxy_glyph_map_close,
  (struct nhproxy_glyph_map_info *info));
extern unsigned int NHPROXY_FDECL(nhproxy_glyph_map_get_length,
  (struct nhproxy_cb_get_glyph_mapping_res *glyph_map));

extern struct nhproxy_tilemap *NHPROXY_NDECL(nhproxy_new_tilemap);
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_load_tilemap_line,
  (struct nhproxy_tilemap *map, const char *line));
extern struct nhproxy_tilemap *NHPROXY_FDECL(nhproxy_load_tilemap, (int fh,
  void (*pulse)(), nhproxy_genericptr_t pulse_data));
extern void NHPROXY_FDECL(nhproxy_free_tilemap, (struct nhproxy_tilemap *map));
extern short *NHPROXY_FDECL(nhproxy_map_glyph2tile,
  (struct nhproxy_cb_get_glyph_mapping_res *glyph_map,
  struct nhproxy_tilemap *tile_entry, void (*pulse)(),
  nhproxy_genericptr_t pulse_data));

extern long *NHPROXY_FDECL(nhproxy_map_glyph2char,
  (struct nhproxy_cb_get_glyph_mapping_res *glyph_map));

extern void NHPROXY_NDECL(nhproxy_clnt_main_quit);
#ifdef NHPROXY_XDR_H
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_clnt_accept,
  (nhproxy_io_func read_f, nhproxy_genericptr_t read_h,
  nhproxy_io_func write_f, nhproxy_genericptr_t write_h));
#endif
extern void NHPROXY_NDECL(nhproxy_clnt_main);
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_clnt_connect, (char *scheme,
  char *address, int *argcp, char **argv));

#ifdef __cplusplus
}
#endif

#endif /* NHPROXY_CLIENT_H */
