/* $Id: clientcb.h,v 1.17 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef NHPROXY_CLIENTCB_H
#define NHPROXY_CLIENTCB_H

#ifdef __cplusplus
extern "C" {
#endif

extern void NHPROXY_NDECL(nhproxy_cb_display_inventory);
extern int NHPROXY_FDECL(nhproxy_cb_dlbh_fopen, (const char *name,
  const char *mode));
extern char *NHPROXY_FDECL(nhproxy_cb_dlbh_fgets, (char *buf, int len, int fh));
extern int NHPROXY_FDECL(nhproxy_cb_dlbh_fread, (char *buf, int size, int no,
  int fh));
extern int NHPROXY_FDECL(nhproxy_cb_dlbh_fwrite, (char *buf, int size, int no,
  int fh));
extern int NHPROXY_FDECL(nhproxy_cb_dlbh_fclose, (int fh));
extern char *NHPROXY_FDECL(nhproxy_cb_dlbh_fmd5sum, (const char *name));
extern void NHPROXY_NDECL(nhproxy_cb_flush_screen);
extern void NHPROXY_NDECL(nhproxy_cb_doredraw);
extern void NHPROXY_FDECL(nhproxy_cb_interface_mode, (unsigned long mode));
extern int NHPROXY_FDECL(nhproxy_cb_parse_options, (char *opts));
extern char *NHPROXY_FDECL(nhproxy_cb_get_option, (char *));
extern struct nhproxy_cb_get_player_choices_res *NHPROXY_NDECL(
  nhproxy_cb_get_player_choices);
extern void NHPROXY_FDECL(nhproxy_cb_free_player_choices,
  (struct nhproxy_cb_get_player_choices_res *choices));
extern struct nhproxy_cb_get_valid_selections_res *NHPROXY_NDECL(
  nhproxy_cb_get_valid_selections);
extern void NHPROXY_FDECL(nhproxy_cb_free_valid_selections,
  (struct nhproxy_cb_get_valid_selections_res *vs));
extern void NHPROXY_NDECL(nhproxy_cb_valid_selection_open);
extern int NHPROXY_FDECL(nhproxy_cb_valid_selection_check,
  (int role, int race, int gend, int align));
extern void NHPROXY_NDECL(nhproxy_cb_valid_selection_close);
extern void NHPROXY_NDECL(nhproxy_cb_quit_game);
extern void NHPROXY_NDECL(nhproxy_cb_display_score);
extern void NHPROXY_NDECL(nhproxy_cb_doset);
extern struct nhproxy_cb_get_extended_commands_res *NHPROXY_NDECL(
  nhproxy_cb_get_extended_commands);
extern void NHPROXY_FDECL(nhproxy_cb_free_extended_commands,
  (struct nhproxy_cb_get_extended_commands_res *commands));
extern int NHPROXY_FDECL(nhproxy_cb_map_menu_cmd, (int ch));
extern int NHPROXY_FDECL(nhproxy_cb_get_standard_winid, (char *window));
extern struct nhproxy_cb_get_tilesets_res *NHPROXY_NDECL(
  nhproxy_cb_get_tilesets);
extern void NHPROXY_FDECL(nhproxy_cb_free_tilesets,
  (struct nhproxy_cb_get_tilesets_res *tilesets));
extern struct nhproxy_cb_get_glyph_mapping_res *NHPROXY_NDECL(
  nhproxy_cb_get_glyph_mapping);
extern void NHPROXY_FDECL(nhproxy_cb_free_glyph_mapping,
  (struct nhproxy_cb_get_glyph_mapping_res *mapping));
extern struct nhproxy_cb_get_extensions_res *NHPROXY_NDECL(
  nhproxy_cb_get_extensions);
extern void NHPROXY_FDECL(nhproxy_cb_free_extensions,
  (struct nhproxy_cb_get_extensions_res *extensions));

#ifdef __cplusplus
}
#endif

#endif /* NHPROXY_CLIENTCB_H */
