/* $Id: compxdr.c,v 1.15 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2001, 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#include "config.h"
#if STDC_HEADERS
#include <stdlib.h>
#endif
#include "compat.h"
#include <nhproxy/system.h>
#include <nhproxy/xdr.h>
#include <nhproxy/common.h>

/*
 * This module implements the XDR routines for non-trivial compound types that
 * NhExt needs.
 */

nhproxy_bool_t
nhproxy_cb_xdr_subprot2_init(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_subprot2_init *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->masks, &datum->n_masks,
	(unsigned int)-1, sizeof(unsigned long), nhproxy_xdr_u_long);
}

nhproxy_bool_t
nhproxy_xdr_init_nhwindow_req(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_init_nhwindow_req *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->argv, 
      &datum->argc, (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring);
}

nhproxy_bool_t
nhproxy_xdr_init_nhwindow_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_init_nhwindow_res *datum;
{
    int retval = nhproxy_xdr_bool(xdr, &datum->inited);
    retval &= nhproxy_xdr_array(xdr, (char **)&datum->argv, 
      &datum->argc, (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring);
    retval &= nhproxy_xdr_array(xdr, (char **)&datum->capv, 
      &datum->capc, (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring);
    return retval;
}

nhproxy_bool_t
nhproxy_xdr_proxy_mi(xdrs, datum)
NhProxyXdr *xdrs;
struct nhproxy_mi *datum;
{
    return nhproxy_xdr_int(xdrs, &datum->item) &&
      nhproxy_xdr_long(xdrs, &datum->count);
}

nhproxy_bool_t
nhproxy_xdr_select_menu_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_select_menu_res *datum;
{
    int retval;
    retval = nhproxy_xdr_int(xdr, &datum->retval);
    retval &= nhproxy_xdr_array(xdr, (char **)&datum->selected, 
      &datum->n, 0xffffffff, sizeof(struct nhproxy_mi), nhproxy_xdr_proxy_mi);
    return retval;
}

nhproxy_bool_t
nhproxy_xdr_status_req(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_status_req *datum;
{
    return nhproxy_xdr_int(xdr, &datum->reconfig) &
      nhproxy_xdr_array(xdr, (char **)&datum->values, 
      &datum->nv, (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring);
}

nhproxy_bool_t
nhproxy_xdr_glyph_row(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_glyph_row *datum;
{
    return nhproxy_xdr_int(xdr, &datum->start) &
      nhproxy_xdr_array(xdr, (char **)&datum->glyphs, 
      &datum->ng, (unsigned int)-1, sizeof(int), nhproxy_xdr_int);
}

nhproxy_bool_t
nhproxy_xdr_glyph_layer(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_glyph_layer *datum;
{
    return nhproxy_xdr_int(xdr, &datum->start) &
      nhproxy_xdr_array(xdr, (char **)&datum->rows, &datum->nr,
      (unsigned int)-1, sizeof(struct nhproxy_glyph_row),
      nhproxy_xdr_glyph_row);
}

nhproxy_bool_t
nhproxy_xdr_print_glyph_layered_req(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_print_glyph_layered_req *datum;
{
    return nhproxy_xdr_int(xdr, &datum->window) &
      nhproxy_xdr_array(xdr, (char **)&datum->layers, &datum->nl,
      (unsigned int)-1, sizeof(struct nhproxy_glyph_layer),
      nhproxy_xdr_glyph_layer);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_player_choices_res_role(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_player_choices_res_role *datum;
{
    return nhproxy_xdr_wrapstring(xdr, (char **)&datum->male) &
      nhproxy_xdr_wrapstring(xdr, (char **)&datum->female);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_player_choices_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_player_choices_res *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->aligns, &datum->n_aligns,
        (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring) &
      nhproxy_xdr_array(xdr, (char **)&datum->genders, &datum->n_genders,
        (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring) &
      nhproxy_xdr_array(xdr, (char **)&datum->races, &datum->n_races,
        (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring) &
      nhproxy_xdr_array(xdr, (char **)&datum->roles, &datum->n_roles,
        (unsigned int)-1, sizeof(struct nhproxy_cb_get_player_choices_res_role),
	nhproxy_cb_xdr_get_player_choices_res_role);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_valid_selections_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_valid_selections_res *datum;
{
    return nhproxy_xdr_int(xdr, &datum->no_roles) &
      nhproxy_xdr_int(xdr, &datum->no_races) &
      nhproxy_xdr_int(xdr, &datum->no_aligns) &
      nhproxy_xdr_int(xdr, &datum->no_genders) &
      nhproxy_xdr_array(xdr, (char **)&datum->masks, &datum->n_masks,
        (unsigned int)-1, sizeof(unsigned long), nhproxy_xdr_u_long);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_extended_commands_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_extended_commands_res *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->commands, &datum->n_commands,
        (unsigned int)-1, sizeof(char *), nhproxy_xdr_wrapstring);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_tilesets_res_tileset(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_tilesets_res_tileset *datum;
{
    return nhproxy_xdr_wrapstring(xdr, (char **)&datum->name) &
      nhproxy_xdr_wrapstring(xdr, (char **)&datum->file) &
      nhproxy_xdr_wrapstring(xdr, (char **)&datum->mapfile) &
      nhproxy_xdr_long(xdr, &datum->flags);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_tilesets_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_tilesets_res *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->tilesets, &datum->n_tilesets,
        (unsigned int)-1, sizeof(struct nhproxy_cb_get_tilesets_res_tileset),
	nhproxy_cb_xdr_get_tilesets_res_tileset);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_glyph_mapping_res_symdef(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_glyph_mapping_res_symdef *datum;
{
    return nhproxy_xdr_long(xdr, &datum->rgbsym) &
      nhproxy_xdr_wrapstring(xdr, (char **)&datum->description);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_glyph_mapping_res_submapping(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_glyph_mapping_res_submapping *datum;
{
    int start, retval;
    start = xdr->x_pos;
    retval = nhproxy_cb_xdr_get_glyph_mapping_res_symdef(xdr, &datum->symdef) &
      nhproxy_xdr_array(xdr, (char **)&datum->glyphs, &datum->n_glyphs,
        (unsigned int)-1,
	sizeof(struct nhproxy_cb_get_glyph_mapping_res_symdef),
	nhproxy_cb_xdr_get_glyph_mapping_res_symdef);
    return retval;
}

nhproxy_bool_t
nhproxy_cb_xdr_get_glyph_mapping_res_mapping(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_glyph_mapping_res_mapping *datum;
{
    return nhproxy_xdr_wrapstring(xdr, (char **)&datum->flags) &
      nhproxy_xdr_int(xdr, &datum->base_mapping) &
      nhproxy_xdr_int(xdr, &datum->alt_glyph) &
      nhproxy_cb_xdr_get_glyph_mapping_res_symdef(xdr, &datum->symdef) &
      nhproxy_xdr_array(xdr, (char **)&datum->submappings,
        &datum->n_submappings, (unsigned int)-1,
	sizeof(struct nhproxy_cb_get_glyph_mapping_res_submapping),
	nhproxy_cb_xdr_get_glyph_mapping_res_submapping);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_glyph_mapping_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_glyph_mapping_res *datum;
{
    return nhproxy_xdr_int(xdr, &datum->no_glyph) &
      nhproxy_xdr_long(xdr, &datum->transparent) &
      nhproxy_xdr_array(xdr, (char **)&datum->mappings, &datum->n_mappings,
        (unsigned int)-1,
	sizeof(struct nhproxy_cb_get_glyph_mapping_res_mapping),
	nhproxy_cb_xdr_get_glyph_mapping_res_mapping);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_extensions_res_extension(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_extensions_res_extension *datum;
{
    return nhproxy_xdr_wrapstring(xdr, (char **)&datum->name) &
      nhproxy_xdr_wrapstring(xdr, (char **)&datum->version) &
      nhproxy_xdr_int(xdr, &datum->no_procedures);
}

nhproxy_bool_t
nhproxy_cb_xdr_get_extensions_res(xdr, datum)
NhProxyXdr *xdr;
struct nhproxy_cb_get_extensions_res *datum;
{
    return nhproxy_xdr_array(xdr, (char **)&datum->extensions,
	&datum->n_extensions, (unsigned int)-1,
	sizeof(struct nhproxy_cb_get_extensions_res_extension),
	nhproxy_cb_xdr_get_extensions_res_extension);
}
