/* $Id: glyphmap.c,v 1.6 2004/12/22 23:15:03 ali Exp $
 * Copyright (C) 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#include "config.h"
#include <stdio.h>
#if STDC_HEADERS
#include <stdlib.h>
#endif
#include "compat.h"
#include <nhproxy/system.h>
#include <nhproxy/xdr.h>
#include <nhproxy/common.h>
#include <nhproxy/client.h>

static void
nhproxy_set_description(datum, level, description)
struct nhproxy_glyph_mapping *datum;
int level;
const char *description;
{
    for(; datum->no_descs < level; datum->no_descs++)
	datum->descs[datum->no_descs] = NULL;
    datum->descs[level] = !description || !*description ? NULL : description;
    if (datum->no_descs <= level)
	datum->no_descs = level + 1;
}

static void
nhproxy_set_symdef(info, level, symdef)
struct nhproxy_glyph_map_info *info;
int level;
struct nhproxy_cb_get_glyph_mapping_res_symdef *symdef;
{
    int rgb, sym;
    /*
     * Update the rgbsym with the new information, if present.
     *
     * Where both the existing infomation and the new information
     * are opaque then the existing information is kept when the
     * new data comes mapping which is based on a second mapping
     * and the new information is used when the mapping isn't based
     * on any other. This allows the mapping for corpses to override
     * the symbol of the monster mappings (colours could also be
     * overridden if so desired).
     */
    if (level < NHPROXY_LEVEL_BASED_MAPPING) {
	rgb = NHPROXY_RGBSYM_RGB(info->current.rgbsym);
	if (rgb == NHPROXY_RGBSYM_RGB(info->glyph_map->transparent))
	    rgb = NHPROXY_RGBSYM_RGB(symdef->rgbsym);
	sym = NHPROXY_RGBSYM_SYM(info->current.rgbsym);
	if (sym == NHPROXY_RGBSYM_SYM(info->glyph_map->transparent))
	    sym = NHPROXY_RGBSYM_SYM(symdef->rgbsym);
    } else {
	rgb = NHPROXY_RGBSYM_RGB(symdef->rgbsym);
	if (rgb == NHPROXY_RGBSYM_RGB(info->glyph_map->transparent))
	    rgb = NHPROXY_RGBSYM_RGB(info->current.rgbsym);
	sym = NHPROXY_RGBSYM_SYM(symdef->rgbsym);
	if (sym == NHPROXY_RGBSYM_SYM(info->glyph_map->transparent))
	    sym = NHPROXY_RGBSYM_SYM(info->current.rgbsym);
    }
    info->current.rgbsym = NHPROXY_RGB_SYM(rgb, sym);
    nhproxy_set_description(&info->current, level, symdef->description);
}

static struct nhproxy_glyph_mapping *
nhproxy_glyph_map_current(info)
struct nhproxy_glyph_map_info *info;
{
    struct nhproxy_cb_get_glyph_mapping_res_mapping *mapping, *base;
    mapping = info->glyph_map->mappings + info->mi;
    info->current.no_descs = 0;
    info->current.rgbsym = info->glyph_map->transparent;
    if (mapping->base_mapping >= 0) {
	if (mapping->base_mapping < info->mi)
	    base = info->glyph_map->mappings + mapping->base_mapping;
	else {
	    /* Forward references to mappings are not supported */
	    nhproxy_error("Glyph mapping %d based on undefined mapping",
	      info->mi);
	    return (struct nhproxy_glyph_mapping *)0;
	}
	nhproxy_set_symdef(info, NHPROXY_LEVEL_MAPPING, &base->symdef);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_BASED_MAPPING, &mapping->symdef);
    } else {
	base = NULL;
	nhproxy_set_symdef(info, NHPROXY_LEVEL_MAPPING, &mapping->symdef);
    }
    /* We ignore flags from our base mapping (if any)
     * and always use our own.
     */
    nhproxy_set_description(&info->current, NHPROXY_LEVEL_FLAGS,
      mapping->flags);
    info->current.alt_glyph = mapping->alt_glyph;
    if (!mapping->n_submappings) {
	if (!base) {
	    nhproxy_error("Glyph mapping %d has no base and no sub-mappings",
	      info->mi);
	    return (struct nhproxy_glyph_mapping *)0;
	}
	nhproxy_set_symdef(info, NHPROXY_LEVEL_SUBMAPPING,
	  &base->submappings[info->bsmi].symdef);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_GLYPH,
	  &base->submappings[info->bsmi].glyphs[info->bgi]);
    } else if (base) {
	if (!base->n_submappings) {
	    nhproxy_error(
	      "Glyph mapping %d based on mapping with no sub-mappings", 
	      info->mi);
	    return (struct nhproxy_glyph_mapping *)0;
	}
	nhproxy_set_symdef(info, NHPROXY_LEVEL_SUBMAPPING,
	  &base->submappings[info->bsmi].symdef);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_GLYPH,
	  &base->submappings[info->bsmi].glyphs[info->bgi]);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_BASED_SUBMAPPING,
	  &mapping->submappings[info->smi].symdef);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_BASED_GLYPH,
	  &mapping->submappings[info->smi].glyphs[info->gi]);
    } else {
	nhproxy_set_symdef(info, NHPROXY_LEVEL_SUBMAPPING,
	  &mapping->submappings[info->smi].symdef);
	nhproxy_set_symdef(info, NHPROXY_LEVEL_GLYPH,
	  &mapping->submappings[info->smi].glyphs[info->gi]);
    }
    return &info->current;
}

struct nhproxy_glyph_mapping *
nhproxy_glyph_map_first(info, glyph_map)
struct nhproxy_glyph_map_info *info;
struct nhproxy_cb_get_glyph_mapping_res *glyph_map;
{
    info->glyph_map = glyph_map;
    info->mi = info->smi = info->gi = 0;
    info->bsmi = info->bgi = 0;
    info->current.descs = info->descs;
    return nhproxy_glyph_map_current(info);
}

struct nhproxy_glyph_mapping *
nhproxy_glyph_map_next(info)
struct nhproxy_glyph_map_info *info;
{
    struct nhproxy_cb_get_glyph_mapping_res_mapping *mapping, *base;
    if (info->mi >= info->glyph_map->n_mappings)
	return (struct nhproxy_glyph_mapping *)0;
    mapping = info->glyph_map->mappings + info->mi;
    if (mapping->base_mapping >= 0)
	base = info->glyph_map->mappings + mapping->base_mapping;
    else
	base = NULL;
    if (++info->gi >= (mapping->n_submappings ?
      mapping->submappings[info->smi].n_glyphs : 0)) {
	if (++info->smi >= mapping->n_submappings) {
	    if (++info->bgi >= (base && base->n_submappings ?
	      base->submappings[info->bsmi].n_glyphs : 0)) {
		if (++info->bsmi >= (base ? base->n_submappings : 0)) {
		    if (++info->mi >= info->glyph_map->n_mappings)
			return (struct nhproxy_glyph_mapping *)0;
		    info->bsmi = 0;
		}
		info->bgi = 0;
	    }
	    info->smi = 0;
	}
	info->gi = 0;
    }
    return nhproxy_glyph_map_current(info);
}

void
nhproxy_glyph_map_close(info)
struct nhproxy_glyph_map_info *info;
{
}

unsigned int
nhproxy_glyph_map_get_length(glyph_map)
struct nhproxy_cb_get_glyph_mapping_res *glyph_map;
{
    unsigned int count = 0;
    struct nhproxy_cb_get_glyph_mapping_res_mapping *mapping, *base;
    int mi = 0, bsmi = 0, bgi = 0, smi = 0, gi = 0;
    mapping = glyph_map->mappings + 0;
    if (mapping->base_mapping >= 0)
	base = glyph_map->mappings + mapping->base_mapping;
    else
	base = NULL;
    for(;;) {
	count++;
	if (++gi >= (mapping->n_submappings ?
	  mapping->submappings[smi].n_glyphs : 0)) {
	    if (++smi >= mapping->n_submappings) {
		if (++bgi >= (base && base->n_submappings ?
		  base->submappings[bsmi].n_glyphs : 0)) {
		    if (++bsmi >= (base ? base->n_submappings : 0)) {
			if (++mi >= glyph_map->n_mappings)
			    return count;
			mapping++;
			if (mapping->base_mapping >= 0)
			    base = glyph_map->mappings + mapping->base_mapping;
			else
			    base = NULL;
			bsmi = 0;
		    }
		    bgi = 0;
		}
		smi = 0;
	    }
	    gi = 0;
	}
    }
}
