/* $Id: server.h,v 1.16 2004/12/22 23:15:04 ali Exp $
 * Copyright (C) 2001, 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef NHPROXY_SERVER_H
#define NHPROXY_SERVER_H

#ifdef __cplusplus
extern "C" {
#endif

extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_serv_get_capabilities,
  (int *capcp, char ***capvp));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_proc_init_nhwindows, (int *argcp,
  char **argv));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_proc_player_selection,
  (int *role, int *race, int *gend, int *align));
extern char *NHPROXY_NDECL(nhproxy_proc_askname);
extern void NHPROXY_NDECL(nhproxy_proc_get_nh_event);
#define nhproxy_proc_get_nh_event() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_GET_NH_EVENT, 0, 0)
extern void NHPROXY_FDECL(nhproxy_proc_exit_nhwindows, (const char *str));
#define nhproxy_proc_exit_nhwindows(str) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_EXIT_NHWINDOWS, 1, \
	  NHPROXY_STRING(str), 0)
extern void NHPROXY_FDECL(nhproxy_proc_suspend_nhwindows, (const char *str));
#define nhproxy_proc_suspend_nhwindows(str) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_SUSPEND_NHWINDOWS, 1, \
	  NHPROXY_STRING(str), 0)
extern void NHPROXY_NDECL(nhproxy_proc_resume_nhwindows);
#define nhproxy_proc_resume_nhwindows() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_RESUME_NHWINDOWS, 0, 0)
extern int NHPROXY_FDECL(nhproxy_proc_create_nhwindow, (int type));
extern void NHPROXY_FDECL(nhproxy_proc_clear_nhwindow, (int window, int rows,
  int cols, int layers));
extern void NHPROXY_FDECL(nhproxy_proc_display_nhwindow, (int window,
  NHPROXY_BOOLEAN_P blocking));
extern void NHPROXY_FDECL(nhproxy_proc_destroy_nhwindow, (int window));
extern void NHPROXY_FDECL(nhproxy_proc_curs, (int window, int x, int y));
#define nhproxy_proc_curs(window, x, y) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_CURS, \
	  3, NHPROXY_INT(window), NHPROXY_INT(x), NHPROXY_INT(y), 0)
extern void NHPROXY_FDECL(nhproxy_proc_putstr, (int window, int attr,
  const char *str));
#define nhproxy_proc_putstr(window, attr, str) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_PUTSTR, 3, NHPROXY_INT(window), \
	  NHPROXY_INT(attr), NHPROXY_STRING(str), 0)
extern void NHPROXY_FDECL(nhproxy_proc_display_file, (int fh));
#define nhproxy_proc_display_file(fh) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_DISPLAY_FILE, 1, NHPROXY_INT(fh), 0)
extern void NHPROXY_FDECL(nhproxy_proc_start_menu, (int window));
#define nhproxy_proc_start_menu(window) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_START_MENU, 1, NHPROXY_INT(window), 0)
extern void NHPROXY_FDECL(nhproxy_proc_add_menu, (int window, int glyph,
  int identifier, NHPROXY_CHAR_P ch, NHPROXY_CHAR_P gch, int attr,
  const char *str, NHPROXY_BOOLEAN_P preselected));
#define nhproxy_proc_add_menu(window, glyph, identifier, ch, gch, attr, str, \
  preselected) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_ADD_MENU, \
	  8, NHPROXY_INT(window), NHPROXY_INT(glyph), NHPROXY_INT(identifier), \
	  NHPROXY_INT(ch), NHPROXY_INT(gch), NHPROXY_INT(attr), \
	  NHPROXY_STRING(str), NHPROXY_BOOLEAN(preselected), 0)
extern void NHPROXY_FDECL(nhproxy_proc_end_menu, (int window,
  const char *prompt));
#define nhproxy_proc_end_menu(window, prompt) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_END_MENU, \
	  2, NHPROXY_INT(window), NHPROXY_STRING(prompt), 0)
extern int NHPROXY_FDECL(nhproxy_proc_select_menu, (int window, int how,
  struct nhproxy_mi **menu_list));
extern char NHPROXY_FDECL(nhproxy_proc_message_menu, (NHPROXY_CHAR_P let,
  int how, const char *mesg));
extern void NHPROXY_NDECL(nhproxy_proc_update_inventory);
#define nhproxy_proc_update_inventory() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_UPDATE_INVENTORY, 0, 0)
extern void NHPROXY_NDECL(nhproxy_proc_mark_synch);
#define nhproxy_proc_mark_synch() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_MARK_SYNC, 0, 0)
extern void NHPROXY_NDECL(nhproxy_proc_wait_synch);
#define nhproxy_proc_wait_synch() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_WAIT_SYNC, 0, 0)
extern void NHPROXY_FDECL(nhproxy_proc_cliparound, (int x, int y));
#define nhproxy_proc_cliparound(x, y) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_CLIPAROUND, 2, NHPROXY_INT(x), \
	  NHPROXY_INT(y), 0)
extern void NHPROXY_FDECL(nhproxy_proc_update_positionbar, (char *posbar));
#define nhproxy_proc_update_positionbar(posbar) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_UPDATE_POSITIONBAR, 1, \
	  NHPROXY_STRING(posbar), 0)
extern void NHPROXY_FDECL(nhproxy_proc_print_glyph, (int w, int x, int y,
  int glyph));
#define nhproxy_proc_print_glyph(window, x, y, glyph) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_PRINT_GLYPH, 4, NHPROXY_INT(window), \
	  NHPROXY_INT(x), NHPROXY_INT(y), NHPROXY_INT(glyph), 0)
extern int NHPROXY_FDECL(nhproxy_proc_raw_print, (const char *str));
extern int NHPROXY_FDECL(nhproxy_proc_raw_print_bold, (const char *str));
extern int NHPROXY_NDECL(nhproxy_proc_nhgetch);
extern int NHPROXY_FDECL(nhproxy_proc_nh_poskey, (int *x, int *y, int *mod));
extern void NHPROXY_NDECL(nhproxy_proc_nhbell);
#define nhproxy_proc_nhbell() (void)nhproxy_rpc(NHPROXY_EXT_FID_NHBELL, 0, 0)
extern int NHPROXY_NDECL(nhproxy_proc_doprev_message);
extern char NHPROXY_FDECL(nhproxy_proc_yn_function, (const char *query,
  const char *resp, NHPROXY_CHAR_P def, int *countp));
extern char *NHPROXY_FDECL(nhproxy_proc_getlin, (const char *query));
extern int NHPROXY_NDECL(nhproxy_proc_get_ext_cmd);
extern void NHPROXY_FDECL(nhproxy_proc_number_pad, (int state));
#define nhproxy_proc_number_pad(state) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_NUMBER_PAD, 1, NHPROXY_INT(state), 0)
extern void NHPROXY_NDECL(nhproxy_proc_delay_output);
#define nhproxy_proc_delay_output() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_DELAY_OUTPUT, 0, 0)
extern void NHPROXY_FDECL(nhproxy_proc_change_color, (int color, long rgb,
  int reverse));
#define nhproxy_proc_change_color(color, rgb, reverse) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_CHANGE_COLOR, \
	  3, NHPROXY_INT(color), NHPROXY_LONG(rgb), NHPROXY_BOOLEAN(reverse), 0)
extern void NHPROXY_FDECL(nhproxy_proc_change_background, (int white_or_black));
#define nhproxy_proc_change_background(white_or_black) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_CHANGE_BACKGROUND, 1, \
	  NHPROXY_BOOLEAN(white_or_black), 0)
extern short NHPROXY_FDECL(nhproxy_proc_set_font_name, (int window,
  char *font));
extern char *NHPROXY_NDECL(nhproxy_proc_get_color_string);
extern void NHPROXY_NDECL(nhproxy_proc_start_screen);
#define nhproxy_proc_start_screen() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_START_SCREEN, 0, 0)
extern void NHPROXY_NDECL(nhproxy_proc_end_screen);
#define nhproxy_proc_end_screen() \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_END_SCREEN, 0, 0)
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_proc_outrip, (int window,
  const char *killed_by));
extern void NHPROXY_FDECL(nhproxy_proc_preference_update, (const char *pref,
  const char *value));
#define nhproxy_proc_preference_update(pref, value) \
	(void)nhproxy_rpc(NHPROXY_EXT_FID_PREFERENCE_UPDATE, 2, \
	  NHPROXY_STRING(pref), NHPROXY_STRING(value), 0)
extern void NHPROXY_FDECL(nhproxy_proc_status, (int reconfig, int nv,
  const char **values));

struct nhproxy_extension {
    const char *name;
    const char *version;
    void NHPROXY_FDECL((*init), (unsigned short id));
    int no_procedures;
    void NHPROXY_FDECL((*handler), (unsigned short id, NhProxyXdr *request,
      NhProxyXdr *reply));
};

struct nhproxy_serv_callbacks {
    void NHPROXY_NDECL((*display_inventory));
    int NHPROXY_FDECL((*dlbh_fopen), (const char *name, const char *mode));
    char *NHPROXY_FDECL((*dlbh_fgets), (char *buf, int len, int fh));
    int NHPROXY_FDECL((*dlbh_fread), (char *buf, int size, int nmemb, int fh));
    int NHPROXY_FDECL((*dlbh_fwrite), (char *buf, int size, int nmemb, int fh));
    int NHPROXY_FDECL((*dlbh_fclose), (int fh));
    void NHPROXY_NDECL((*flush_screen));
    void NHPROXY_NDECL((*doredraw));
    void NHPROXY_FDECL((*interface_mode), (long mode));
    void NHPROXY_FDECL((*parse_options), (char *opts));
    char *NHPROXY_FDECL((*get_option), (const char *opt));
    struct nhproxy_cb_get_player_choices_res *NHPROXY_NDECL(
      (*get_player_choices));
    void NHPROXY_FDECL((*free_player_choices),
      (struct nhproxy_cb_get_player_choices_res *choices));
    struct nhproxy_cb_get_valid_selections_res *NHPROXY_NDECL(
      (*get_valid_selections));
    void NHPROXY_FDECL((*free_valid_selections),
      (struct nhproxy_cb_get_valid_selections_res *selections));
    void NHPROXY_NDECL((*quit_game));
    void NHPROXY_NDECL((*display_score));
    void NHPROXY_NDECL((*doset));
    struct nhproxy_cb_get_extended_commands_res *NHPROXY_NDECL(
      (*get_extended_commands));
    void NHPROXY_FDECL((*free_extended_commands),
      (struct nhproxy_cb_get_extended_commands_res *commands));
    char NHPROXY_FDECL((*map_menu_cmd), (NHPROXY_CHAR_P ch));
    int NHPROXY_FDECL((*get_standard_winid), (const char *window));
    struct nhproxy_cb_get_tilesets_res *NHPROXY_NDECL((*get_tilesets));
    void NHPROXY_FDECL((*free_tilesets),
      (struct nhproxy_cb_get_tilesets_res *tilesets));
    struct nhproxy_cb_get_glyph_mapping_res *NHPROXY_NDECL(
      (*get_glyph_mapping));
    void NHPROXY_FDECL((*free_glyph_mapping),
      (struct nhproxy_cb_get_glyph_mapping_res *mapping));
    void NHPROXY_FDECL((*set_option_mod_status), (const char *optnam,
      int status));
};

extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_serv_flush_layers, (int w,
  int clearing, int no_glyph));
extern FILE *NHPROXY_NDECL(nhproxy_serv_config_file_open);
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_serv_get_capabilities, (int *capcp,
  char ***capvp));
extern int NHPROXY_FDECL(nhproxy_serv_get_mapwin, (int window));
extern void NHPROXY_FDECL(nhproxy_serv_print_layer, (int w, int x, int y,
  int z, int glyph));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_serv_flush_layers, (int w,
  int clearing, int no_glyph));
extern void NHPROXY_FDECL(nhproxy_serv_config_file_close, (FILE *fp));
extern nhproxy_bool_t NHPROXY_NDECL(nhproxy_serv_may_change_name);
extern char *NHPROXY_NDECL(nhproxy_serv_get_windowtype);
extern void NHPROXY_FDECL(nhproxy_serv_set_extensions,
  (struct nhproxy_extension *extents));
extern void NHPROXY_FDECL(nhproxy_serv_set_callbacks,
  (struct nhproxy_serv_callbacks *callbacks));
extern nhproxy_bool_t NHPROXY_FDECL(nhproxy_serv_accept, (char *game_name,
  char *version_string));

#ifdef __cplusplus
}
#endif

#endif /* NHPROXY_SERVER_H */
