/* $Id: system.h,v 1.1 2004/12/22 23:15:04 ali Exp $
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

#ifndef NHPROXY_SYSTEM_H
#define NHPROXY_SYSTEM_H

#ifdef __STDC__
# define NHPROXY_VOID_PTR 1
#endif

#ifdef __STDC__
#define NHPROXY_PROTOTYPES 1
#endif

#ifdef NHPROXY_PROTOTYPES
# if defined(__GNUC__) || defined(__MWERKS__) && defined(__BEOS__) || \
	defined(__MWERKS__) && defined(__BEOS__) || \
	!defined(vax) && defined(ULTRIX_PROTO) && defined(ULTRIX_CC20)
#  define NHPROXY_UNWIDENED_PROTOTYPES 1
# endif
#endif

#ifdef NHPROXY_VOID_PTR
typedef void * nhproxy_genericptr_t;
#else
typedef char * nhproxy_genericptr_t;
#endif

#ifdef NHPROXY_PROTOTYPES
# define NHPROXY_NDECL(f)        (f)(void)
# define NHPROXY_FDECL(f, p)     (f)p
# define NHPROXY_VDECL(f, p)     (f)p
# ifdef NHPROXY_UNWIDENED_PROTOTYPES
#  define NHPROXY_CHAR_P          char
#  define NHPROXY_SHORT_P         short
#  define NHPROXY_BOOLEAN_P       nhproxy_bool_t
# else
#  define NHPROXY_CHAR_P          int
#  define NHPROXY_SHORT_P         int
#  define NHPROXY_BOOLEAN_P       int
# endif
#else	/* NHPROXY_PROTOTYPES */
# define NHPROXY_NDECL(f)        (f)()
# define NHPROXY_FDECL(f, p)     (f)()
# define NHPROXY_VDECL(f, p)     (f)()
#endif	/* NHPROXY_PROTOTYPES */

#endif /* NHPROXY_SYSTEM_H */
