/* $Id: test_ext.c,v 1.9 2004/12/22 23:15:06 ali Exp $
 * Copyright (C) 2001, 2002, 2003  Slash'EM Development Team
 * Copyright (C) 2004  J. Ali Harlow
 *
 * This file is part of NetHack Proxy.
 *
 * NetHack Proxy is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of the
 * License, or (at your option) any later version.
 *
 * NetHack Proxy is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with NetHack Proxy; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
 * USA
 *
 * Alternatively (at your option) you may instead choose to redistribute
 * and/or modify NetHack Proxy under the terms of the NetHack General
 * Public License.
 *
 * You should have receieved a copy of the NetHack General Public License
 * along with NetHack Proxy; if not, download a copy from
 * http://www.nethack.org/common/license.html
 */

/*
 * This module tests the NhExt support routines for sub-protocol 1.
 * These include nhext_init(), nhext_end() nhproxy_rpc() and nhext_svc(),
 * all of which can be found in nhext.c.
 *
 * Note: This module does not test the implementation of sub-protocol 1
 * itself (which is found in winproxy.c) or the support for sub-protocol 2.
 */

#include <stdio.h>
#include <stdarg.h>

#include <nhproxy/nhproxy.h>
#include "test_com.h"

volatile server_exit = 0;

#define EXT_FID_EXIT	0x7FFF
#define EXT_FID_TEST1	1
#define EXT_FID_TEST2	2
#define EXT_FID_TEST3	3
#define EXT_FID_TEST4	4
#define EXT_FID_TEST5	5
#define EXT_FID_TEST6	6
#define EXT_FID_TEST7	7

#define EXT_CID_TEST7	0x1007

struct test5_request {
    unsigned int n;
    long *array;
};

void NHPROXY_FDECL(test7_callback,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_exit,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test1,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test2,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test3,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test4,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
int NHPROXY_FDECL(svc_xdr_test5_request,
  (NhProxyXdr *xdrs, struct test5_request *datum));
void NHPROXY_FDECL(svc_test5,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test6,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_FDECL(svc_test7,
  (unsigned short id, NhProxyXdr *request, NhProxyXdr *reply));
void NHPROXY_NDECL(server);
int NHPROXY_NDECL(run_tests);

void
test7_callback(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(i));
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(i * 5 + 3));
}

struct nhproxy_rpc_services callbacks[] = {
    EXT_CID_TEST7,	test7_callback,
    0, NULL,
};

void
svc_exit(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    server_exit = 1;
    nhproxy_rpc_params(reply, 0);
}

void
svc_test1(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    nhproxy_rpc_params(reply, 0);
}

void
svc_test2(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(i));
    nhproxy_rpc_params(reply, 0);
}

void
svc_test3(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(i));
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(i + 1));
}

void
svc_test4(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    char *s;
    char *buf;
    nhproxy_rpc_params(request, 1, NHPROXY_STRING_PTR(s));
    buf = (char *)malloc(strlen(s) + 3);
    if (buf)
	sprintf(buf, "<%s>", s);
    free(s);
    if (buf) {
	nhproxy_rpc_params(reply, 1, NHPROXY_STRING(buf));
	free(buf);
    }
    else {
	buf = "<not enough memory>";
	nhproxy_rpc_params(reply, 1, NHPROXY_STRING(buf));
    }
}

int
svc_xdr_test5_request(xdrs, datum)
NhProxyXdr *xdrs;
struct test5_request *datum;
{
    return nhproxy_xdr_array(xdrs, (char **)&datum->array, &datum->n,
      (unsigned int)-1, sizeof(long), nhproxy_xdr_long);
}

void
svc_test5(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    int total = 0;
    struct test5_request req = { 0, (long *)0 };
    nhproxy_rpc_params(request, 1, NHPROXY_XDRF(svc_xdr_test5_request, &req));
    for(i = 0; i < req.n; i++)
	total += req.array[i];
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(total));
}

void
svc_test6(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    char *s;
    int w;
    nhproxy_bool_t b;
    char c;
    nhproxy_rpc_params(request, 5, NHPROXY_INT_PTR(i), NHPROXY_INT_PTR(w),
      NHPROXY_CHAR_PTR(c), NHPROXY_STRING_PTR(s), NHPROXY_BOOLEAN_PTR(b));
    nhproxy_rpc_params(reply, 5, NHPROXY_INT(w), NHPROXY_STRING(s),
      NHPROXY_CHAR(c), NHPROXY_INT(i), NHPROXY_BOOLEAN(b));
    free(s);
}

void
svc_test7(id, request, reply)
unsigned short id;
NhProxyXdr *request, *reply;
{
    int i;
    nhproxy_rpc_params(request, 1, NHPROXY_INT_PTR(i));
    nhproxy_rpc(EXT_CID_TEST7, 1, NHPROXY_INT(i), 1, NHPROXY_INT_PTR(i));
    nhproxy_rpc_params(reply, 1, NHPROXY_INT(i));
}

struct nhproxy_rpc_services services[] = {
    EXT_FID_EXIT,	svc_exit,
    EXT_FID_TEST1,	svc_test1,
    EXT_FID_TEST2,	svc_test2,
    EXT_FID_TEST3,	svc_test3,
    EXT_FID_TEST4,	svc_test4,
    EXT_FID_TEST5,	svc_test5,
    EXT_FID_TEST6,	svc_test6,
    EXT_FID_TEST7,	svc_test7,
    0,			NULL,
};

void
server(void)
{
    int i;
    NhProxyIO *rd, *wr;
    rd = nhproxy_io_open(parent_read, get_parent_readh(), NHPROXY_IO_RDONLY);
    wr = nhproxy_io_open(parent_write, get_parent_writeh(), NHPROXY_IO_WRONLY);
    if (!rd || !wr) {
	fprintf(stderr, "C Failed to open I/O streams.\n");
	exit(1);
    }
    (void)nhproxy_rpc_set_errhandler(rpc_error_handler);
    if (!nhproxy_rpc_init(rd, wr, callbacks)) {
	fprintf(stderr, "C Failed to initialize NhExt.\n");
	exit(1);
    }
    if (!nhproxy_rpc_set_protocol(1)) {
	fprintf(stderr, "C Failed to select protocol 1.\n");
	exit(1);
    }
    do {
	i = nhproxy_rpc_svc(services);
	if (!i)
	    fprintf(stderr, "Ignoring packet with zero ID");
    } while (!server_exit);
    nhproxy_rpc_end();
    nhproxy_io_close(rd);
    nhproxy_io_close(wr);
}

int
run_tests(void)
{
    int i, retval, failed = 0;
    char c, *s;
    nhproxy_bool_t b;
    int w;
    int total;
    struct test5_request req;
    fprintf(stderr, "Test 1...\n");
    retval = nhproxy_rpc(EXT_FID_TEST1, 0, 0);
    if (!retval)
	failed++;
    fprintf(stderr, "Test 1 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 2...\n");
    retval = nhproxy_rpc(EXT_FID_TEST2, 1, NHPROXY_INT(0), 0);
    if (!retval)
	failed++;
    fprintf(stderr, "Test 2 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 3...\n");
    retval = nhproxy_rpc(EXT_FID_TEST3, 1, NHPROXY_INT(67), 1,
      NHPROXY_INT_PTR(i));
    if (i != 68)
	retval = FALSE;
    if (!retval)
	failed++;
    fprintf(stderr, "Test 3 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 4...\n");
    retval = nhproxy_rpc(EXT_FID_TEST4, 1, NHPROXY_STRING("Hello"),
      1, NHPROXY_STRING_PTR(s));
    if (strcmp(s, "<Hello>"))
	retval = FALSE;
    if (!retval)
	failed++;
    fprintf(stderr, "Test 4 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 5...\n");
    req.n = 5;
    req.array = (long *)malloc(req.n * sizeof(long));
    if (!req.array) {
	fprintf(stderr, "can't be completed (resource failure)\n");
	return -1;
    }
    for(i = 0; i < 5; i++)
	req.array[i] = 7 * i + 3;
    retval = nhproxy_rpc(EXT_FID_TEST5,
      1, NHPROXY_XDRF(svc_xdr_test5_request, &req), 1, NHPROXY_INT_PTR(total));
    for(i = 0; i < 5; i++)
	total -= req.array[i];
    if (total)
	retval = FALSE;
    free(req.array);
    if (!retval)
	failed++;
    fprintf(stderr, "Test 5 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 6...\n");
    retval = nhproxy_rpc(EXT_FID_TEST6, 5, NHPROXY_INT(37), NHPROXY_INT(2),
      NHPROXY_CHAR('l'), NHPROXY_STRING("Shalom"), NHPROXY_BOOLEAN(TRUE),
      5, NHPROXY_INT_PTR(w), NHPROXY_STRING_PTR(s), NHPROXY_CHAR_PTR(c),
      NHPROXY_INT_PTR(i), NHPROXY_BOOLEAN_PTR(b));
    if (w != 2 || strcmp(s, "Shalom") || c != 'l' || i != 37 || !b)
	retval = FALSE;
    free(s);
    if (!retval)
	failed++;
    fprintf(stderr, "Test 6 %s.\n", retval ? "passed" : "failed");
    fprintf(stderr, "Test 7...\n");
    retval = nhproxy_rpc(EXT_FID_TEST7, 1, NHPROXY_INT(11), 1,
      NHPROXY_INT_PTR(i));
    if (i != 58)
	retval = FALSE;
    if (!retval)
	failed++;
    fprintf(stderr, "Test 7 %s.\n", retval ? "passed" : "failed");
    return failed;
}

main(argc, argv)
int argc;
char **argv;
{
    int failed;
    NhProxyIO *rd, *wr;
    if (argc > 1 && !strcmp(argv[1], "-c")) {
	is_child++;
	server();
	exit(0);
    }
    if (!child_start(argv[0])) {
	fprintf(stderr, "Failed to start child.\n");
	exit(1);
    }
    rd = nhproxy_io_open(debug_read, get_child_readh(), NHPROXY_IO_RDONLY);
    wr = nhproxy_io_open(debug_write, get_child_writeh(), NHPROXY_IO_WRONLY);
    if (!rd || !wr) {
	fprintf(stderr, "Failed to open I/O streams.\n");
	exit(1);
    }
    (void)nhproxy_rpc_set_errhandler(rpc_error_handler);
    if (!nhproxy_rpc_init(rd, wr, callbacks)) {
	fprintf(stderr, "Failed to initialize NhExt.\n");
	exit(1);
    }
    if (!nhproxy_rpc_set_protocol(1)) {
	fprintf(stderr, "Failed to select protocol 1.\n");
	exit(1);
    }
    failed = run_tests();
    nhproxy_rpc(EXT_FID_EXIT, 0, 0);
    nhproxy_rpc_end();
    nhproxy_io_close(rd);
    nhproxy_io_close(wr);
    if (!child_wait()) {
	fprintf(stderr, "Error while waiting for child.\n");
	exit(1);
    }
    if (failed > 0)
	exit(1);
    else if (failed < 0)
	exit(77);		/* Test couldn't be completed */
    else
	exit(0);
}
