#!/bin/sh
# $Id: xdr_cmp.sh,v 1.1 2004/12/22 23:15:06 ali Exp $
# Copyright (C) 2004  J. Ali Harlow
#
# This file is part of NetHack Proxy.
#
# NetHack Proxy is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as
# published by the Free Software Foundation; either version 2.1 of the
# License, or (at your option) any later version.
#
# NetHack Proxy is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public
# License along with NetHack Proxy; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307   
# USA
#
# Alternatively (at your option) you may instead choose to redistribute
# and/or modify NetHack Proxy under the terms of the NetHack General
# Public License.
#
# You should have receieved a copy of the NetHack General Public License
# along with NetHack Proxy; if not, download a copy from
# http://www.nethack.org/common/license.html
set -e
echo Testing NhExt XDR routines...
echo These two should be identical:
echo "========== Standard XDR -> NetHack Proxy XDR =========="
./test_xdr_std -w | ./test_xdr_nhproxy -r | tee test_xdr.out1
echo "========== NetHack Proxy XDR -> Standard XDR =========="
./test_xdr_nhproxy -w | ./test_xdr_std -r | tee test_xdr.out2
echo "======================================================="
cmp test_xdr.out1 test_xdr.out2
result=$?
rm -f test_xdr.out1 test_xdr.out2
exit $result
