/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: character.h,v 1.23 2005/01/16 22:57:51 neryel Exp $

***********************************************************************/

#ifndef _CHARACTER_H_
#define _CHARACTER_H_

#include "field_object.h"

/* Moves */
enum character_move
  {
    MOVE_UP, MOVE_DOWN, MOVE_LEFT, MOVE_RIGHT
  };

#define MOVE_OBSTACLE -1
#define MOVE_NO_MORE_MOVE -2
#define MOVE_OFF_LIMIT -3
#define ATTACK_NO_MORE_AMMO -1
#define ATTACK_SELF -2

/**
 * \brief Character
 *
 * A character who can basically move and fire 
 **/
@interface Character : Field_object
{
  /* "Permanent" data */
  char * _name;
  int _hit;
  int _speed;
  int _dodge;
  int _stamina;
  int _hp;
  id _weapon;

  /* Data refreshed each turn */
  int _fired_ammos;
  int _moved;
  int _max_move;
}
/* Global stuff */
+ (id) next_character;

/* Init / Free */
- init;
- free;
- init_from_attributes: (const char **) attributes values: (const char **) values;

/* Actions */
- (int) attack: (id) character;
- (void) lose_hp: (int) hp;
- (int) move: (enum character_move) direction;

/* Get / setters */
- (const char *) get_name;
- (int) get_speed;
- (int) get_dodge;
- (int) get_stamina;
- (void) set_name: (const char *) name;
- (void) set_hp;
- (void) set_weapon: (id) weapon;
- (void) set_weapon_from_name: (const char *) name;
- (id) get_weapon;
- (int) get_hp;

- (void) new_turn;
- (void) reposition;
@end
#endif /* _CHARACTER_H_ */
