/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: field_object.h,v 1.5 2005/01/15 18:01:48 neryel Exp $

***********************************************************************/

#ifndef _FIELD_OBJECT_H_
#define _FIELD_OBJECT_H_

#include "graphical_object.h"

/**
 * \brief For all objects on the field
 *
 * This class serves mainly as layer between the absolute position of
 * the Graphical_objects, and the position in the field.
 *
 * \verbatim
 *
 *  |----------> _x_absolute
 *  |       /\
 *  |      /  \
 *  |     /    \
 *  |   |_ _y   _| _x
 *  |
 * \ / _y_absolute
 * \endverbatim
 *
 * \see Graphical_object, Map
 **/
@interface Field_object : Graphical_object
{
  /* Relative position on the field */
  int _x;
  int _y;
}
- init_from_attributes: (const char **) attributes values: (const char **) values;
- (void) set_x: (int) x;
- (void) set_y: (int) y;
- (void) set_x: (int) x y: (int) y;
- (int) get_x;
- (int) get_y;
- (void) reposition;
@end

#endif /* _FIELD_OBJECT_H_ */
