/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: field_object.m,v 1.9 2005/01/16 18:25:00 neryel Exp $

***********************************************************************/

#include <string.h>
#include <stdlib.h>

#include "field_object.h"
#include "map.h"
#include "tools.h"

@implementation Field_object
/**
 * Init from attributes and values of an XML element. 
 **/
- init_from_attributes: (const char **) attributes values: (const char **) values
{
  [super init_from_attributes: attributes values: values];
  for (int i = 0; attributes[i] && values[i]; i++)
    {
      if (!strcmp (attributes[i], "x"))
        [self set_x: strtol (values[i], NULL, 0)];
      else if (!strcmp (attributes[i], "y"))
        [self set_y: strtol (values[i], NULL, 0)];
    }

  return self;
}

/**
 * Sets x
 **/
- (void) set_x: (int) x
{
  _x = x;
  [self reposition];
}

/**
 * Sets y
 **/
- (void) set_y: (int) y
{
  _y = y;
  [self reposition];
}

/**
 * Sets x and y relative positions, that is the cases on the field 
 **/
- (void) set_x: (int) x y: (int) y
{
  _x = x;
  _y = y;

  [self reposition];
}

/**
 * Returns x relative position 
 **/
- (int) get_x
{
  return _x;
}

/** 
 * Returns y relative position
 **/
- (int) get_y
{
  return _y;
}

/**
 * \brief Reposition the object. 
 * 
 * This method must be called when the x and y changed. It should a
 * priori only be used by the Field_object class. 
 **/
- (void) reposition
{
  struct couple isometric = {_x, _y};
  struct couple absolute = isometric_to_absolute (isometric);

  /* Applicate an offset since we have the top-center point and we
     want the top-left */
  absolute.x -= CASE_WIDTH / 2;

  [self set_absolute_x: absolute.x y: absolute.y];
}
@end
