/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: graphical_object.h,v 1.8 2005/01/15 18:01:48 neryel Exp $

***********************************************************************/

#ifndef _GRAPHICAL_OBJECT_H_
#define _GRAPHICAL_OBJECT_H_

#include <objc/Object.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

/**
 * \brief Class for all graphical objects
 *
 * Mainly used to display all kinds of objecs on a map. 
 *
 * \see Map
 **/
@interface Graphical_object : Object
{
  /* Object positions */
  int _x_absolute;
  int _y_absolute;

  /* Data related to the display */
  GdkPixbuf * _picture; /* Picture to draw */
  id _map; /* Map where to draw it */
}
- init;
- init_from_attributes: (const char **) attributes values: (const char **) values;
- init_from_file: (const char *) filename;
- free;
- (void) display;
- (void) set_absolute_x: (int) x y: (int) y;
- (void) move_absolute_x: (int) x y: (int) y;
- (void) load_picture: (const char *) filename;
- (void) set_map: (id) map;
@end

#endif /* _GRAPHICAL_OBJECT_H_ */
