/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: main.m,v 1.20 2005/01/17 00:33:38 neryel Exp $

***********************************************************************/

#include <objc/Object.h>
#include <gtk/gtk.h>
#include <unistd.h>

#include "wall.h"
#include "graphical_object.h"
#include "field_object.h"
#include "map.h"
#include "tile.h"
#include "character.h"
#include "weapon.h"
#include "../config.h"
#include "tools.h"

#define TILES_FILENAME "tiles.xml"
#define WEAPONS_FILENAME "weapons.xml"

void
ninar_end (void)
{
  [Tile free_all];
  [Weapon free_all];
}

void 
ninar_init (void)
{
  gchar * tiles_filename = g_strdup_printf ("%s/global/%s",
    DATADIR, TILES_FILENAME);
  [Tile load_tiles: tiles_filename];
  g_free (tiles_filename);

  gchar * weapons_filename = g_strdup_printf ("%s/global/%s", 
    DATADIR, WEAPONS_FILENAME);
  [Weapon add_all_from_file: weapons_filename];
  g_free (weapons_filename);
}



void 
usage (const char * name)
{ 
  printf ("Usage: %s map\n", name);
  printf ("The map being an appropriate XML.\n\n");

  printf ("%s\n\n", PACKAGE_STRING);
  printf ("%s is free software; you can redistribute it and/or modify\n", PACKAGE_NAME);
  printf ("it under the terms of the GNU General Public License as published\n");
  printf ("by the Free Software Foundation; either version 2 of the License,\n");
  printf ("or (at your option) any later version.\n\n");
  printf ("%s is distributed in the hope that it will be useful,\n", PACKAGE_NAME);
  printf ("but WITHOUT ANY WARRANTY; without even the implied warranty of\n");
  printf ("MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n");
  printf ("GNU General Public License for more details.\n\n");

  printf ("You should have received a copy of the GNU General Public License\n");
  printf ("along with %s; if not, write to the Free Software\n", PACKAGE_NAME);
  printf ("Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA\n");
  printf ("02111-1307  USA.\n\n");
  printf ("Please report bugs to: %s\n", PACKAGE_BUGREPORT);
}
  
int
main (int argc, char *argv[])
{
  gtk_init (&argc, &argv);

  ninar_init ();

  if (argc == 1)
    {
      usage (argv[0]);
    }
  else
    {
      id map = [[Map alloc] init_from_file: argv[1]];

      GtkWidget * window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
      gtk_window_set_title (GTK_WINDOW (window), "NiNaR");
      gtk_window_set_default_size (GTK_WINDOW (window), 400, 400);
      g_signal_connect (G_OBJECT (window), "destroy", G_CALLBACK (gtk_main_quit), NULL);
      g_signal_connect (G_OBJECT (window), "delete_event", G_CALLBACK (gtk_main_quit), NULL);
      gtk_container_add (GTK_CONTAINER (window), [map create_scrolled_window]);

      gtk_widget_show_all (window);
      
      gtk_main ();

      [map free];
    }
  ninar_end ();

  return 0;
}


