/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: map.h,v 1.16 2005/01/17 00:33:38 neryel Exp $

***********************************************************************/

#ifndef _MAP_H_
#define _MAP_H_

#include <objc/Object.h>
#include <gtk/gtk.h>

/**
 * \brief Map containing all objects
 *
 * The map contains all graphical_objects, and helps making the
 * correspondance between absolute coordonates and relative ones.
 *
 * Quite possibly, the drawing zone may not contain all map. So we
 * only render elements in the window.
 **/
@interface Map : Object
{
  /* Number of tiles on x and y (relative) axis */
  unsigned _cases_x;
  unsigned _cases_y;

  /* Position of the window (ie, the drawing object) */
  int _x_offset;
  int _y_offset;
  int _relative_x_offset;
  int _relative_y_offset;
  
  /* Drawing zone */
  GtkWidget * _widget;
  
  /** Lists of objets : objects are put in 3 categories, tiles,
      field_objects, and objects. They are refreshed in this order. */ 
  char ** _tiles;
  GList * _field_objects;
  GList * _objects;
}
- init;
- init_from_file: (const char *) filename;
- free;
- (void) load_file: (const char *) filename;
- (void) load_tiles_map: (const char *) filename;
- (void) add_object: (id) object;
- (void) remove_object: (id) object;
- (void) refresh;
- (void) set_offset_x: (int) x_offset y: (int) y_offset;
- (void) set_relative_offset_x: (int) x;
- (void) set_relative_offset_y: (int) y;
- (void) move_offset_x: (int) x_offset y: (int) y_offset;
- (int) get_x_offset;
- (int) get_y_offset;
- (int) get_width;
- (int) get_height;
- (int) get_x_max;
- (int) get_y_max;
- (GtkWidget *) get_widget;
- (GtkWidget *) create_scrolled_window;
- (id) get_object_at_x: (int) x y: (int) y;
@end

/* Current filename... this is a bit dirty, but well */
extern const char * map_current_file_name;
#endif /* _MAP_ */
