/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: map_user_interface.m,v 1.7 2005/01/16 22:57:51 neryel Exp $

***********************************************************************/

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>

#include "map_user_interface.h"
#include "map.h"
#include "character.h"
#include "tools.h"

static Character * _current_character = NULL;

#define LEFT_BUTTON 1
#define RIGHT_BUTTON 3

/* \todo rewrite and complete these functions ; move most of the code
   in appropriate classes */

/* This callback receives mouse events directed to the map */
gboolean
map_ui_mouse_callback (GtkWidget * w __attribute__((unused)),
  GdkEvent * event,
  id map)
{
  struct couple pos; 
  id object;
  int button;

  pos.x = ((GdkEventButton *)event)->x;
  pos.y = ((GdkEventButton *)event)->y;

  pos.x += [map get_x_offset];
  pos.y += [map get_y_offset];

  pos = absolute_to_isometric (pos);

  button = ((GdkEventButton *)event)->button;

  if (button == LEFT_BUTTON)
    {
      if (_current_character == NULL)
        {
          printf ("No character selected\n");
        }
      else 
        {
          object = [map get_object_at_x: pos.x y: pos.y];
          if (!object)
            {
              printf ("Nothing here\n");
            }
          else
            {
              if ([object isKindOf: [Character class]])
                {
                  id weapon = [_current_character get_weapon];
                  if (weapon)
                    {
                      printf ("%s attacks %s with %s!\n", [_current_character get_name], [object get_name], [weapon get_name]);
                      [_current_character attack: object];
                    }
                  else 
                    {
                      printf ("no weapon to attack\n");
                    }
                }
            }
        }
    }  
  return TRUE;
}

/* This callback receive keyboard events directed to the map */
gboolean 
map_ui_keyboard_callback (GtkWidget * w __attribute__((unused)),
  GdkEvent * event, 
  id map)
{
  (void) map;
  unsigned keyval = ((GdkEventKey *)event)->keyval;

  switch (keyval)
    {
    case GDK_Down:
      [_current_character move: MOVE_DOWN];
      break;
    case GDK_Up:
      [_current_character move: MOVE_UP];
      break;
    case GDK_Left:
      [_current_character move: MOVE_LEFT];
      break;
    case GDK_Right:
      [_current_character move: MOVE_RIGHT];
      break;
    case GDK_Return:
      _current_character = [Character next_character];
      printf ("%s - %d HP, %s\n", [_current_character get_name], 
        [_current_character get_hp], [[_current_character get_weapon] get_name]);
    }
  
  return TRUE;
}
