/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: obstacle.h,v 1.4 2005/01/15 21:01:00 neryel Exp $

***********************************************************************/

#ifndef _OBSTACLE_H_
#define _OBSTACLE_H_

#include "field_object.h"

/**
 * \brief An obstacle
 *
 * Obstacles are objects that (a priori) don't move, prevent the
 * characters to pass and block partially (or totally) bullets.
 **/
@interface Obstacle : Field_object
{
  /** 
   * Coefficient by which is multiplicated the probability to hit if
   * the obstacle is in the way. 100 -> the obstacle doesn't protect 0
   * -> the obstacle entirely block.
   * Note also that if the character firing is near enough of the
   * obstacle, the latter won't block.
   **/
  int _hit_coef;
}
+ (void) init_all_from_attributes: (const char **) attributes values: (const char **) values map: (id) map;
- init_from_attributes: (const char **) attributes values: (const char **) values;
- (void) set_hit_coef: (int) coef;
- (int) get_hit_coef;
- (void) reposition;
@end

#endif /* _OBSTACLE_H_ */
