/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: tile.h,v 1.4 2005/01/16 18:56:07 neryel Exp $

***********************************************************************/

#ifndef _TILE_H_
#define _TILE_H_

#include "field_object.h"

/**
 * \brief Tile gestion
 *
 * This class has two purpose: 
 * - extend field_object to have the move cost
 * - add some class methods to manage tiles
 **/
@interface Tile : Field_object
{
  /* Cost of a move to this case */
  unsigned _cost;
}
+ (void) set_tile: (id) tile to_key: (char) c;
+ (id) get_tile_from_key: (char) c;
+ (void) free_all;
+ (void) load_tiles: (const char *) filename;
- (void) set_cost: (unsigned) cost;
- (unsigned) get_cost;
- (void) display_at_x: (int) x y: (int) y;
@end

#endif /* _TILE_H_ */
