/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: wall.h,v 1.4 2005/01/16 18:19:11 neryel Exp $

***********************************************************************/

#ifndef _WALL_H_
#define _WALL_H_

#include "obstacle.h"

/**
 * \brief Wall class
 *
 * Walls are a special type of obstacle, since a wall is between two
 * cases. A wall displays itself if and only if the precedent cases is
 * a wall too. And it displays a wall with the good orientation.
 **/
@interface Wall : Obstacle
{
  /* Base filename for the two wall pictures: direction north/south or
     direction east/west */
  char * _base_filename;

  BOOL _do_not_load;
}
- free;
- (void) display;
- (void) load_picture: (const char *) filename;
- (void) set_x: (int) x y: (int) y;
@end
#endif /* _WALL_H_ */
