/***********************************************************************
    Copyright (C) 2005 Frdric HENRY <neryel@reveries.info>

    This file is part of NiNaR.

    NiNaR is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published 
    by the Free Software Foundation; either version 2 of the License,
    or (at your option) any later version.

    NiNaR is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the 
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License 
    along with NiNaR; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
    02111-1307  USA.

    File information: $Id: weapon.h,v 1.8 2005/01/17 00:33:38 neryel Exp $

***********************************************************************/

#ifndef _WEAPON_H_
#define _WEAPON_H_

#include <objc/Object.h>

/**
 * \brief Weapon class. 
 *
 * A weapon is used and owned by a character.
 *
 * \see Character
 **/
@interface Weapon : Object
{
  char * _name;
  double _hit_proba;
  int _range;
  int _ammos;
  int _power;
}
+ (void) add_all_from_file: (const char *) filename;
+ (void) free_all;
+ (id) get_weapon_from_name: (const char *) name;
- free;
- init;
- init_from_attributes: (const char **) attributes values: (const char **) values;
- (void) set_name: (const char *) name;
- (const char *) get_name;
- (double) get_hit_proba;
- (double) get_hit_proba_at_distance: (int) distance;
- (int) get_range;
- (int) get_ammos;
- (int) get_power;
@end

#endif /* _WEAPON_H_ */
