.\"
.\" %nmhwarning%
.\"
.TH SEND %manext1% "%nmhdate%" MH.6.8 [%nmhversion%]
.SH NAME
send \- send a message
.SH SYNOPSIS
.HP 5
.na
.B send
.RB [ \-alias
.IR aliasfile ]
.RB [ \-draft ]
.RB [ \-draftfolder
.IR +folder ]
.RB [ \-draftmessage
.IR msg ]
.RB [ \-nodraftfolder ]
.RB [ \-filter
.IR filterfile ]
.RB [ \-nofilter ]
.RB [ \-format " | " \-noformat ]
.RB [ \-forward " | " \-noforward ]
.RB [ \-mime " | " \-nomime ]
.RB [ \-msgid " | " \-nomsgid ]
.RB [ \-push " | " \-nopush ]
.RB [ \-split
.IR seconds ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-watch " | " \-nowatch ]
.RB [ \-server
.IR servername ]
.RB [ \-port
.IR port-name/number ]
.RB [ \-sasl ]
.RB [ \-saslmech
.IR mechanism ]
.RB [ \-user
.IR username ]
.RB [ \-width
.IR columns ]
.RB [ file
\&...] 
.RB [ \-version ]
.RB [ \-help ]
.RB [ \-attach
.IR header-field-name ]
.RB [ \-attachformat
.IR 0 " | " 1 " | " 2 ]
.ad
.SH DESCRIPTION
.B Send
will cause each of the specified files to be delivered
to each of the destinations in the \*(lqTo:\*(rq, \*(lqcc:\*(rq,
\*(lqBcc:\*(rq, \*(lqDcc:\*(rq, and \*(lqFcc:\*(rq fields of the message.  If
.B send
is re\-distributing a message, as invoked from
.BR dist ,
then the
corresponding \*(lqResent\-xxx\*(rq fields are examined instead.
.PP
By default,
.B send
uses the program
.B post
to do the actual
delivery of the messages, although this can be changed by defining the
.I postproc
profile component.  Most of the features attributed to
.B send
are actually performed by
.BR post .

.PP
If a
.I header-field-name
is supplied using the
.B -attach
option, the draft is scanned for a header whose field name matches the
supplied
.IR header-field-name .
The draft is converted to a MIME message if one or more matches are found.
This conversion occurs before all other processing.
.PP
The first part of the MIME message is the draft body if that body contains
any non-blank characters.
The body of each header field whose name matches the
.I header-field-name
is interpreted as a file name, and each file named is included as a separate
part in the MIME message.
.PP
For file names with dot suffixes, the context is scanned for a
.I mhshow-suffix-
entry for that suffix.
The content-type for the part is taken from that context entry if a match is
found.
If no match is found or the file does not have a dot suffix, the content-type
is text/plain if the file contains only ASCII characters or application/octet-stream
if it contains characters outside of the ASCII range.
.PP
Each part contains a name attribute that is the last component of the path name.
A
.I x-unix-mode
attribute containing the file mode accompanies each part.
Finally, a description attribute is generated by running the
.I file
command on the file.
.PP
The
.B -attachformat
option specifies the MIME header field formats:  a value of
.B 0,
the default,
includes the
.I x-unix-mode
attribute as noted above.  A value of
.B 1
suppresses both that and the \*(lqContent-Description\*(rq header, and
adds a \*(lqContent-Disposition\*(rq header.  A value of
.B 2
adds the file
.I modification-date
parameter to the \*(lqContent-Disposition\*(rq header.  You can
specify one value in your profile, and override it for individual
messages at the
.I whatnow
prompt.
.PP
Here are example message part headers, for an attachment, for each of the
.B -attachformat
values:
.PP
.nf
-attachformat 0:
Content-Type: text/plain; name="VERSION"; x-unix-mode="0644";
	charset="us-ascii"
Content-Description: ASCII text 

-attachformat 1:
Content-Type: text/plain; name="VERSION"; charset="us-ascii"
Content-Disposition: attachment; filename="VERSION"

-attachformat 2:
Content-Type: text/plain; name="VERSION"; charset="us-ascii"
Content-Disposition: attachment; filename="VERSION"; modification-date="Mon, 19 Dec 2005 22:39:51 -0600"
.fi
.PP
If
.B \-push
is specified,
.B send
will detach itself from the user's
terminal and perform its actions in the background.  If
.BR push 'd
and the draft can't be sent, then an error message will be sent (using
the mailproc) back to the user.  If
.B \-forward
is given, then a copy
of the draft will be attached to this failure notice.  Using
.B \-push
differs from putting
.B send
in the background because the output is
trapped and analyzed by
.BR nmh .
.PP
If
.B \-verbose
is specified,
.B send
will indicate the interactions
occurring with the transport system, prior to actual delivery.
If
.B \-watch
is specified
.B send
will monitor the delivery of local
and network mail.  Hence, by specifying both switches, a large detail
of information can be gathered about each step of the message's entry
into the transport system.
.PP
The
.B \-draftfolder
.I +folder
and
.B \-draftmessage
.I msg
switches invoke
the
.B nmh
draft folder facility.  This is an advanced (and highly
useful) feature.  Consult the
.BR mh-draft (5)
man page for more
information.
.PP
If
.B \-split
is specified,
.B send
will split the draft into one
or more partial messages prior to sending.  This makes use of the
MIME features in
.BR nmh .
Note however that if
.B send
is
invoked under
.BR dist ,
then this switch is ignored\0--\0it makes
no sense to redistribute a message in this fashion.  Sometimes you want
.B send
to pause after posting a partial message.  This is usually
the case when you are running
.B sendmail
and expect to generate a
lot of partial messages.  The argument to
.B \-split
tells it how long
to pause between postings.
.PP
.B Send
with no
.I file
argument will query whether the draft
is the intended file, whereas
.B \-draft
will suppress this question.
Once the transport system has successfully accepted custody of the
message, the file will be renamed with a leading comma, which allows
it to be retrieved until the next draft message is sent.  If there are
errors in the formatting of the message,
.B send
will abort with a
(hopefully) helpful error message.
.PP
If a \*(lqBcc:\*(rq field is encountered, its addresses will be used for
delivery, and the \*(lqBcc:\*(rq field will be removed from the message
sent to sighted recipients.  The blind recipients will receive an entirely
new message with a minimal set of headers.  Included in the body of the
message will be a copy of the message sent to the sighted recipients.
.PP
If a \*(lqDcc:\*(rq field is encountered, its addresses will be used for
delivery, and the \*(lqDcc:\*(rq field will be removed from the message.  The
blind recipients will receive the same message sent to the sighted
recipients. *WARNING* Recipients listed in the \*(lqDcc:\*(rq field receive no
explicit indication that they have received a \*(lqblind copy\*(rq.
This can cause blind recipients to
inadvertently reply to all of the sighted recipients of the
original message, revealing that they received a blind copy.
On the other hand, since a normal reply to a message sent
via a \*(lqBcc:\*(rq field
will generate a reply only to the sender of the original message,
it takes extra effort in most mailers to reply to the included
message, and so would usually only be done deliberately, rather
than by accident.
.PP
If
.B \-filter
.I filterfile
is specified, then this copy is filtered
(re\-formatted) by
.B mhl
prior to being sent to the blind recipients.
Alternately, if you specify the
.B -mime
switch, then
.B send
will
use the MIME rules for encapsulation.
.PP
Prior to sending the message, the fields \*(lqFrom:\ user@local\*(rq,
and \*(lqDate:\ now\*(rq will be appended to the headers in the message.
If the environment variable
.B $SIGNATURE
is set, then its value
is used as your personal name when constructing the \*(lqFrom:\*(rq
line of the message.  If this environment variable is not set, then
.B send
will consult the profile entry \*(lqSignature\*(rq for
this information.
If
.B \-msgid
is specified, then a \*(lqMessage\-ID:\*(rq field will also
be added to the message.
.PP
If
.B send
is re\-distributing a message (when invoked by
.BR dist ),
then \*(lqResent\-\*(rq will be prepended to each of these
fields: \*(lqFrom:\*(rq, \*(lqDate:\*(rq, and \*(lqMessage\-ID:\*(rq.
If the message already contains a \*(lqFrom:\*(rq field, then a
\*(lqSender: user@local\*(rq field will be added as well.  (An already
existing \*(lqSender:\*(rq field is an error!)
.PP
By using the
.B \-format
switch, each of the entries in the \*(lqTo:\*(rq
and \*(lqcc:\*(rq fields will be replaced with \*(lqstandard\*(rq
format entries.  This standard format is designed to be usable by all
of the message handlers on the various systems around the Internet.
If
.B \-noformat
is given, then headers are output exactly as they appear
in the message draft.
.PP
If an \*(lqFcc:\ folder\*(rq is encountered, the message will be copied
to the specified folder for the sender in the format in which it will
appear to any non\-Bcc receivers of the message.  That is, it will have
the appended fields and field reformatting.  The \*(lqFcc:\*(rq fields
will be removed from all outgoing copies of the message.
.PP
By using the
.B \-width
.I columns
switch, the user can direct
.B send
as to how long it should make header lines containing addresses.
.PP
If nmh is using the SMTP MTA, the
.B \-server
and the
.B \-port
switches can be used to override the default mail server (defined by the
.RI servers
entry in
.I %etcdir%/mts.conf
).
.PP
If
.B nmh
has been compiled with SASL support, the
.B \-sasl
switch will enable
the use of SASL authentication with the SMTP MTA.  Depending on the
SASL mechanism used, this may require an additional password prompt from the
user (but the
.RI \*(lq \&.netrc \*(rq
file can be used to store this password).
.B \-saslmech
switch can be used to select a particular SASL mechanism,
and the the
.B \-user
switch can be used to select a authorization userid
to provide to SASL other than the default.
.PP
If SASL authentication is successful, 
.BR nmh
will attempt to negotiate a security layer for session encryption.
Encrypted data is labelled with `(encrypted)' and `(decrypted)' when
viewing the SMTP transaction with the
.B \-snoop
switch.
.PP
If
.B nmh
has been compiled with TLS support, the
.B \-tls
switch will require the negotiation of TLS support when connecting to the
SMTP MTA.  Encrypted data is labelled with `(tls-encrypted)' and
`(tls-decrypted)' when viewing the SMTP transction with the
.B \-snoop
switch.
.PP
The files specified by the profile entry \*(lqAliasfile:\*(rq and any
additional alias files given by the
.B \-alias
.I aliasfile
switch will be
read (more than one file, each preceded by
.BR \-alias ,
can be named).
See
.BR mh\-alias (5)
for more information.

.SH FILES
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
.fi

.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Draft\-Folder:~^To find the default draft\-folder
^Aliasfile:~^For a default alias file
^Signature:~^To determine the user's mail signature
^mailproc:~^Program to post failure notices
^postproc:~^Program to post the message
.fi

.SH "SEE ALSO"
comp(1), dist(1), forw(1), repl(1), mh\-alias(5), post(8)

.SH DEFAULTS
.nf
.RB ` file "' defaults to <mh\-dir>/draft"
.RB ` \-alias "' defaults to %etcdir%/MailAliases"
.RB ` \-nodraftfolder '
.RB ` \-nofilter '
.RB ` \-format '
.RB ` \-forward '
.RB ` \-nomime '
.RB ` \-nomsgid '
.RB ` \-nopush '
.RB ` \-noverbose '
.RB ` \-nowatch '
.RB ` "\-width\ 72" '
.RB ` "\-attachformat\ 0" '
.fi

.SH CONTEXT
None

.SH BUGS
Under some configurations, it is not possible to monitor the mail delivery
transaction;
.B \-watch
is a no-op on those systems.
.PP
Using
.B \-split
.I 0
doesn't work correctly.
