.TH MHBUILD %manext1% "March 13, 2014" "%nmhversion%"
.\"
.\" %nmhwarning%
.\"
.SH NAME
mhbuild \- translate MIME composition draft
.SH SYNOPSIS
.na
.HP 5
.B mhbuild
.I file
.RB [ \-auto " | " \-noauto ]
.RB [ \-list " | " \-nolist ]
.RB [ \-realsize " | " \-norealsize ]
.RB [ \-headers " | " \-noheaders ]
.RB [ \-directives " | " \-nodirectives ]
.RB [ \-rfc934mode " | " \-norfc934mode ]
.RB [ \-contentid " | " \-nocontentid ]
.RB [ \-verbose " | " \-noverbose ]
.RB [ \-disposition " | " \-nodisposition ]
.RB [ \-check " | " \-nocheck ]
.RB [ \-headerencoding 
.IR encoding\-algorithm
.RB " | " \-autoheaderencoding ]
.RB [ \-maxunencoded
.IR line\-length ]
.RB [ \-dist ]
.RB [ \-version ]
.RB [ \-help ]
.ad
.SH DESCRIPTION
The
.B mhbuild
command will translate a MIME composition draft into
a valid MIME message.
.PP
.B mhbuild
creates multi-media messages as specified in RFC 2045
to RFC 2049.  This includes the encoding of message headers as specified
by RFC 2047, and the encoding of MIME parameters as specified in RFC 2231.
.PP
If you specify the name of the composition file as \*(lq-\*(rq,
then
.B mhbuild
will accept the composition draft on the standard
input.  If the translation of this input is successful,
.B mhbuild
will output the new MIME message to the standard output.  This argument
must be the last argument on the command line.
.PP
Otherwise if the file argument to
.B mhbuild
is the name of a valid
composition file, and the translation is successful,
.B mhbuild
will replace the original file with the new MIME message.  It will rename
the original file to start with the \*(lq,\*(rq character and end with the
string \*(lq.orig\*(rq, e.g., if you are editing the file \*(lqdraft\*(rq,
it will be renamed to \*(lq,draft.orig\*(rq.  This allows you to easily
recover the
.B mhbuild
input file.
.SS "Listing the Contents"
The
.B \-list
switch tells
.B mhbuild
to list the table of contents associated with the MIME message that is created.
.PP
The
.B \-headers
switch indicates
that a one-line banner should be displayed above the listing.  The
.B \-realsize
switch tells
.B mhbuild
to evaluate the \*(lqnative\*(rq
(decoded) format of each content prior to listing.  This provides an
accurate count at the expense of a small delay.  If the
.B \-verbose
switch
is present, then the listing will show any \*(lqextra\*(rq information
that is present in the message, such as comments in the
\*(lqContent-Type\*(rq header.
.PP
If the
.B \-disposition
switch is present, then the listing will show any relevant information from
the \*(lqContent-Disposition\*(rq header.
.SS "Simplified Attachment Interface"
For users who wish to simply attach files to text content,
.B mhbuild
will scan the composition file for \*(lqAttach\*(rq headers.  An
\*(lqAttach\*(rq header contains a filename that will be appended to the
message using normal MIME encapsulation rules.  One filename is allowed
per \*(lqAttach\*(rq header, but multiple \*(lqAttach\*(rq headers are
allowed ber composition file.
.PP
These files will be appended after any other MIME content, including any
content specified by
.B mhbuild
directives (see below).  See
.IR send (1)
for more details.
.SS "Translating the Composition File"
.B mhbuild
is essentially a filter to aid in the composition of MIME
messages.
.B mhbuild
will convert an
.B mhbuild
\*(lqcomposition file\*(rq
into a valid MIME message.  A
.B mhbuild
\*(lqcomposition file\*(rq
is just a file containing plain text that is interspersed
with various
.B mhbuild
directives.  When this file is processed
by
.BR mhbuild ,
the various directives will be expanded to the
appropriate content, and will be encoded according to the MIME standards.
The resulting MIME message can then be sent by electronic mail.
.PP
The formal syntax for a
.B mhbuild
composition file is defined at the
end of this document, but the ideas behind this format are not complex.
Basically, the body contains one or more contents.  A content consists of
either a directive, indicated with a \*(lq#\*(rq as the first character
of a line; or, plaintext (one or more lines of text).  The continuation
character, \*(lq\\\*(lq, may be used to enter a single directive on more
than one line, e.g.,
.PP
.RS 5
.nf
#image/png \\
    /home/foobar/junk/picture.png
.fi
.RE
.PP
There are five kinds of directives: \*(lqtype\*(rq directives, which
name the type and subtype of the content; \*(lqexternal-type\*(rq
directives, which also name the type and subtype of the content; the
\*(lqmessage\*(rq directive (#forw), which is used to forward one or
more messages; the \*(lqbegin\*(rq directive (#begin), which is
used to create a multipart content; and the \*(lqon/off/pop\*(rq
directives (#on, #off, #pop) which control whether any other
directives are honored at all.
.PP
The
.B \-directives
switch allows control over whether mhbuild will honor any of the
\*(lq#\*(rq-directives.  This can also be affected with the #on or
#off directives, and #pop, which restores the state of processing to
that preceding the most recent #on or #off.  (The #on, #off, and #pop
directives are always honored, of course.) This allows inclusion of
plain text which looks like mhbuild directives, without causing
errors:
.PP
.RS 5
.nf
#off
#include <stdio.h>
printf("Hello, World!);
#pop
.fi
.RE
.PP
Currently the stack depth for the #on/off/pop directives is 32.
.PP
The \*(lqtype\*(rq directive is used to directly specify the type and
subtype of a content.  You may only specify discrete types in this manner
(can't specify the types multipart or message with this directive).
You may optionally specify the name of a file containing the contents
in \*(lqnative\*(rq (decoded) format.  If this filename starts with the
\*(lq|\*(rq character, then it represents a command to execute whose
output is captured accordingly.
For example,
.PP
.RS 5
.nf
#audio/basic |raw2audio -F < /usr/lib/sound/giggle.au
.fi
.RE
.PP
If a filename is not given,
.B mhbuild
will look for information in the
user's profile to determine how the different contents should be composed.
This is accomplished by consulting a composition string, and executing
it under
.BR /bin/sh ,
with the standard output set to the content.
If the
.B \-verbose
switch is given,
.B mhbuild
will echo any commands that are used to create contents in this way.
.PP
The composition string may contain the following escapes:
.PP
.RS 5
.nf
.ta \w'%P  'u
%a	Insert parameters from directive
%f	Insert filename containing content
%F	%f, and stdout is not re-directed
%s	Insert content subtype
%%	Insert character %
.fi
.RE
.PP
First,
.B mhbuild
will look for an entry of the form:
.PP
.RS 5
mhbuild-compose-<type>/<subtype>
.RE
.PP
to determine the command to use to compose the content.  If this isn't
found,
.B mhbuild
will look for an entry of the form:
.PP
.RS 5
mhbuild-compose-<type>
.RE
.PP
to determine the composition command. If this isn't found,
.B mhbuild
will complain.
.PP
An example entry might be:
.PP
.RS 5
mhbuild-compose-audio/basic: record | raw2audio -F
.RE
.PP
Because commands like these will vary, depending on the display
environment used for login, composition strings for different
contents should probably be put in the file specified by the
.B $MHBUILD
environment variable, instead of directly in your
user profile.
.PP
The \*(lqexternal-type\*(rq directives are used to provide a MIME
reference to a content, rather than enclosing the contents itself
(for instance, by specifying an ftp site).  Hence, instead of
providing a filename as with the type directives, external-parameters
are supplied.  These look like regular parameters, so they must be
separated accordingly.  For example,
.PP
.RS 5
.nf
#@application/octet-stream; \\
    type=tar; \\
    conversions=compress \\
    [this is the nmh distribution] \\
    {attachment; filename="nmh.tar.gz"} \\
    name="nmh.tar.gz"; \\
    directory="/pub/nmh"; \\
    site="ftp.math.gatech.edu"; \\
    access-type=anon-ftp; \\
    mode="image"
.fi
.RE
.PP
You must give a description string to separate the content parameters
from the external-parameters (although this string may be empty).
This description string is specified by enclosing it within
\*(lq[]\*(rq.  A disposition string, to appear in a
\*(lqContent-Disposition\*(rq header, may appear in the optional
\*(lq{}\*(rq.
.PP
These parameters are of the form:
.PP
.RS 5
.nf
.ta \w'access-type=  'u
access-type=	usually \fIanon-ftp\fR, \fImail-server\fR, or \fIurl\fR
name=	filename
permission=	read-only or read-write
site=	hostname
directory=	directoryname (optional)
mode=	usually \fIascii\fR or \fIimage\fR (optional)
size=	number of octets
server=	mailbox
subject=	subject to send
body=	command to send for retrieval
url=	URL of content
.fi
.RE
.PP
A mimimum \*(lqexternal\-type\*(rq directive for the
.B url
.I access\-type
would be as follows:
.PP
.RS 3
.nf
#@application/octet-stream [] access-type=url; \\
  url="http://download.savannah.gnu.org/releases/nmh/nmh-1.5.tar.gz"
.fi
.RE
.PP
Any long URLs will be wrapped according to RFC 2231 rules.
.PP
The \*(lqmessage\*(rq directive (#forw) is used to specify a message or
group of messages to include.  You may optionally specify the name of
the folder and which messages are to be forwarded.  If a folder is not
given, it defaults to the current folder.  Similarly, if a message is not
given, it defaults to the current message.  Hence, the message directive
is similar to the
.B forw
command, except that the former uses
the MIME rules for encapsulation rather than those specified in RFC 934.
For example,
.PP
.RS 5
.nf
#forw +inbox 42 43 99
.fi
.RE
.PP
If you include a single message, it will be included directly as a content
of type \*(lqmessage/rfc822\*(rq.  If you include more than one message,
then
.B mhbuild
will add a content of type \*(lqmultipart/digest\*(rq
and include each message as a subpart of this content.
.PP
If you are using this directive to include more than one message, you
may use the
.B \-rfc934mode
switch.  This switch will indicate that
.B mhbuild
should attempt to utilize the MIME encapsulation rules
in such a way that the \*(lqmultipart/digest\*(rq that is created
is (mostly) compatible with the encapsulation specified in RFC 934.
If given, then RFC 934 compliant user-agents should be able to burst the
message on reception\0--\0providing that the messages being encapsulated
do not contain encapsulated messages themselves.  The drawback of this
approach is that the encapsulations are generated by placing an extra
newline at the end of the body of each message.
.PP
The \*(lqbegin\*(rq directive is used to create a multipart content.
When using the \*(lqbegin\*(rq directive, you must specify at least one
content between the begin and end pairs.
.PP
.RS 5
.nf
#begin
This will be a multipart with only one part.
#end
.fi
.RE
.PP
If you use multiple directives in a composition draft,
.B mhbuild
will
automatically encapsulate them inside a multipart content.  Therefore the
\*(lqbegin\*(rq directive is only necessary if you wish to use nested
multiparts, or create a multipart message containing only one part.
.PP
For all of these directives, the user may include a brief description
of the content between the \*(lq[\*(rq character and the \*(lq]\*(rq
character.  This description will be copied into the
\*(lqContent-Description\*(rq header when the directive is processed.
.PP
.RS 5
.nf
#forw [important mail from Bob] +bob 1 2 3 4 5
.fi
.RE
.PP
Similarly, a disposition string may optionally be provided between
\*(lq{\*(rq and \*(lq}\*(rq characters; it will be copied into the
\*(lqContent-Disposition\*(rq header when the directive is processed.
If a disposition string is provided that does not contain a filename
parameter, and a filename is provided in the directive, it will be
added to the \*(lqContent-Disposition\*(rq header.  For example, the
following directive:
.PP
.RS 5
.nf
#text/plain; charset=iso-8859-1 <>{attachment} /tmp/summary.txt
.fi
.RE
.PP
creates these message part headers:
.PP
.RS 5
.nf
Content-Type: text/plain; charset="iso-8859-1"
Content-Disposition: attachment; filename="summary.txt"
.fi
.RE
.PP
By default,
.B mhbuild
will generate a unique \*(lqContent-ID:\*(rq for each directive,
corresponding to each message part; however, the user may override
this by defining the ID using the \*(lq<\*(rq and \*(lq>\*(rq
characters.  The
.B \-nocontentid
switch suppresses creation of all \*(lqContent-ID:\*(rq headers,
even in the top level of the message.
.PP
Normally
.B mhbuild
will choose an appropriate Content\-Transfer\-Encoding based on the content
and the MIME Content\-Type.  However, you can override that in an
.B mhbuild
directive by specifying \*(lq*\*(rq and the encoding.  Acceptable encoding
values are \*(lq8bit\*(rq, \*(lqqp\(*rq (for quoted\-printable), and
\*(lqb64\*(rq (for base64 encoding).  It should be noted that undesired
results may occur if 8bit or quoted\-printable is selected for binary
content, due to the translation between Unix line endings and the line
endings use by the mail transport system.
.PP
In addition to the various directives, plaintext can be present.
Plaintext is gathered, until a directive is found or the draft is
exhausted, and this is made to form a text content.  If the plaintext
must contain a \*(lq#\*(rq at the beginning of a line, simply double it,
e.g.,
.PP
.RS 5
##when sent, this line will start with only one #
.RE
.PP
If you want to end the plaintext prior to a directive, e.g., to have two
plaintext contents adjacent, simply insert a line containing a single
\*(lq#\*(rq character, e.g.,
.PP
.RS 5
.nf
this is the first content
#
and this is the second
.fi
.RE
.PP
Finally, if the plaintext starts with a line of the form:
.PP
.RS 5
Content-Description: text
.RE
.PP
then this will be used to describe the plaintext content.
You MUST follow this line with a blank line before starting
your text.
.PP
By default, plaintext is captured as a text/plain content.  You can
override this by starting the plaintext with \*(lq#<\*(rq followed by
a content-type specification.  For example, e.g.,
.PP
.RS 5
.nf
#<text/enriched
this content will be tagged as text/enriched
#
and this content will be tagged as text/plain
#
#<application/x-patch [this is a patch]
and this content will be tagged as application/x-patch
.fi
.RE
.PP
Note that if you use the \*(lq#<\*(rq plaintext-form, then the
content-description must be on the same line which identifies the content
type of the plaintext.
.PP
When composing a text content, you may indicate the relevant character
set by adding the \*(lqcharset\*(rq parameter to the directive.
.PP
.RS 5
#<text/plain; charset=iso-8859-5
.RE
.PP
If a text content contains any 8\-bit characters (characters with the
high bit set) and the character set is not specified as above, then
.B mhbuild
will assume the character set is of the type given by the
standard
.IR locale (1)
environment variables.  If these environment variables are not
set, then the character set will be labeled as \*(lqx-unknown\*(rq.
.PP
If a text content contains only 7\-bit characters and the character set
is not specified as above, then the character set will be labeled as
\*(lqus-ascii\*(rq.
.PP
By default text content with the high bit set is encoded with a 8bit
Content\-Transfer\-Encoding.  If the text has lines longer than the value
of
.B \-maxunencoded
(which defaults to 78) then the text is encoded using the quoted\-printable
encoding.
.PP
The
.B \-headerencoding
switch will indicate which algorithm to use when encoding any message headers
that contain 8\-bit characters.  The valid arguments are
.I base64
for based\-64 encoding and 
.I quoted
for quoted\-printable encoding.  The
.B \-autoheaderencoding
switch will instruct
.B mhbuild
to automatically pick the algorithm that results in a shorter encoded string.
.PP
Putting this all together,
here is an example of a more complicated message draft.  The
following draft will expand into a multipart/mixed message
containing five parts:
.PP
.RS 5
.nf
To: nobody@nowhere.org
cc:
Subject: Look and listen to me!
--------
The first part will be text/plain
#<text/enriched
The second part will be text/enriched
#
This third part will be text/plain
#audio/basic [silly giggle]  \\
    |raw2audio -F < /usr/lib/sounds/giggle.au
#image/gif   [photo of foobar] \\
                    /home/foobar/lib/picture.gif
.fi
.RE
.SS "Integrity Check"
If
.B mhbuild
is given the
.B \-check
switch, then it will also associate an integrity check with each
\*(lqleaf\*(rq content.  This will add a Content-MD5 header field to
the content, along with the md5 sum of the unencoded contents, per RFC
1864.  This may be used by the receiver of the message to verify that
the contents of the message were not changed in transport.
.SS "Transfer Encodings"
After
.B mhbuild
constructs the new MIME message by parsing directives,
including files, etc., it scans the contents of the message to determine
which transfer encoding to use.  It will check for 8bit data, long lines,
spaces at the end of lines, and clashes with multipart boundaries.  It will
then choose a transfer encoding appropriate for each content type.
.PP
If an integrity check is being associated with each content by using
the
.B \-check
switch, then
.B mhbuild
will encode each content with
a transfer encoding, even it the content contains only 7\-bit data.  This
is to increase the likelihood that the content is not changed while in
transport.
.SS "Invoking mhbuild"
Typically,
.B mhbuild
is invoked by the
.B whatnow
program.  This
command will expect the body of the draft to be formatted as an
.B mhbuild
composition file.  Once you have composed this input file
using a command such as
.BR comp ,
.BR repl ,
or
.BR forw ,
you invoke
.B mhbuild
at the \*(lqWhat now\*(rq prompt with
.PP
.RS 5
What now? mime
.RE
.PP
prior to sending the draft.  This will cause
.B whatnow
to execute
.B mhbuild
to translate the composition file into MIME format.
.PP
Normally it is an error to invoke
.B mhbuild
on file that already in MIME format.  The 
.B \-auto
switch will cause
.B mhbuild
to exit without error if the input file already has valid MIME headers.
The use of
.B \-auto
also enables the
.B \-nodirectives
switch.
.PP
Finally, you should consider adding this line to your profile:
.PP
.RS 5
lproc: show
.RE
.PP
This way, if you decide to
.B list
after invoking
.BR mime ,
the command
.PP
.RS 5
What now? list
.RE
.PP
will work as you expect.
.PP
The
.B \-dist
switch is intended to be used by
.BR dist .
It will cause mhbuild to not generate any MIME headers in the composition
file (such as \*(lqMIME-Version\*(rq or \*(lqContent-Type\*(rq), but it
will still encode message headers according to RFC 2047.
.SS "User Environment"
Because the environment in which
.B mhbuild
operates may vary for a
user,
.B mhbuild
will look for the environment variable
.BR $MHBUILD .
If present, this specifies the name of an additional user profile which
should be read.  Hence, when a user logs in on a particular machine,
this environment variable should be set to refer to a file containing
definitions useful for that machine.
.PP
Finally,
.B mhbuild
will attempt to consult a global
.B mhbuild
user profile, e.g.,
.PP
.RS 5
%etcdir%/mhn.defaults
.RE
.PP
if it exists.
.SS "Syntax of Composition Files"
The following is the formal syntax of a
.B mhbuild
\*(lqcomposition file\*(rq.
.PP
.RS 5
.nf
body         ::=     1*(content | EOL)

content      ::=     directive | plaintext

directive    ::=     "#" type "/" subtype
                         0*(";" attribute "=" value)
                         [ "(" comment ")" ]
                         [ "<" id ">" ]
                         [ "[" description "]" ]
                         [ "{" disposition "}" ]
			 [ "*8bit" | "*qp" | "*b64" ]
                         [ filename ]
                         EOL

                   | "#@" type "/" subtype
                         0*(";" attribute "=" value)
                         [ "(" comment ")" ]
                         [ "<" id ">" ]
                         [ "[" description "]" ]
                         [ "{" disposition "}" ]
			 [ "*8bit" | "*qp" | "*b64" ]
                         external-parameters
                         EOL

                   | "#forw"
                         [ "<" id ">" ]
                         [ "[" description "]" ]
                         [ "{" disposition "}" ]
                         [ "+"folder ] [ 0*msg ]
                         EOL

                   | "#begin"
                           [ "<" id ">" ]
                           [ "[" description "]" ]
                           [ "{" disposition "}" ]
                           [   "alternative"
                             | "parallel"
                             | something-else    ]
                           EOL
                         1*body
                     "#end" EOL

plaintext    ::=     [ "Content-Description:"
                           description EOL EOL ]
                         1*line
                     [ "#" EOL ]

                   | "#<" type "/" subtype
                         0*(";" attribute "=" value)
                         [ "(" comment ")" ]
                         [ "[" description "]" ]
                         [ "{" disposition "}" ]
			 [ "*8bit" | "*qp" | "*b64" ]
                         EOL
                         1*line
                     [ "#" EOL ]

line         ::=     "##" text EOL
                     -- interpreted as "#"text EOL
                   | text EOL
.fi
.RE
.SH FILES
.B mhbuild
looks for additional user profile files and mhn.defaults in multiple
locations: absolute pathnames are accessed directly, tilde expansion
is done on usernames, and files are searched for in the user's
.I Mail
directory as specified in their profile.  If not found there, the directory
.RI \*(lq %etcdir% \*(rq
is checked.
.PP
.fc ^ ~
.nf
.ta \w'%etcdir%/ExtraBigFileName  'u
^$HOME/\&.mh\(ruprofile~^The user profile
^$MHBUILD~^Additional profile entries
^%etcdir%/mhn.defaults~^System default MIME profile entries
.fi
.SH "PROFILE COMPONENTS"
.fc ^ ~
.nf
.ta 2.4i
.ta \w'ExtraBigProfileName  'u
^Path:~^To determine the user's nmh directory
^Current\-Folder:~^To find the default current folder
^mhbuild-compose-<type>*~^Template for composing contents
.fi
.SH "SEE ALSO"
.IR mhlist (1),
.IR mhshow (1),
.IR mhstore (1)
.PP
.I "Proposed Standard for Message Encapsulation"
(RFC 934),
.PP
.I "The Content-MD5 Header Field"
(RFC 1864),
.PP
.I "Multipurpose Internet Mail Extensions (MIME) Part One: Format of Internet Message Bodies"
(RFC 2045),
.PP
.I "Multipurpose Internet Mail Extensions (MIME) Part Two: Media Types"
(RFC 2046),
.PP
.I "Multipurpose Internet Mail Extensions (MIME) Part Three: Message Header Extensions for Non-ASCII Text"
(RFC 2047),
.PP
.I "Multipurpose Internet Mail Extensions (MIME) Part Four: Registration Procedures"
(RFC 2048),
.PP
.I "Multipurpose Internet Mail Extensions (MIME) Part Five: Conformance Criteria and Examples"
(RFC 2049),
.PP
.I "Definition of the URL MIME External-Body Access-Type"
(RFC 2017),
.PP
.I "MIME Parameter Value and Encoded Word Extensions: Character Sets, Languages, and Continuations"
(RFC 2231)
.SH DEFAULTS
.nf
.RB ` \-headers '
.RB ` \-realsize '
.RB ` \-norfc934mode '
.RB ` \-contentid '
.RB ` \-nocheck '
.RB ` \-noverbose '
.RB ` \-nodisposition '
.RB ` \-autoheaderencoding '
.RB ` "\-maxunencoded\ 78"'
.fi
