<?php
/*
 *   This file is part of NOALYSS.
 *
 *   NOALYSS is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   NOALYSS is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with NOALYSS; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Copyright Author Dany De Bontridder danydb@aevalys.eu

/*!\file
 * \brief this file is included from parameters and its purpose is to
 * enable, disable and manage security for the extensions
 *
 * variable :
 * - p_action is ext
 * - sb is nothing vw (view) or save
 * - $cn database connection
 */

if ( ! defined ('ALLOWED') ) die('Appel direct ne sont pas permis');
require_once('class_extension.php');
require_once('class_html_input.php');
require_once('class_ibutton.php');
require_once('class_ipopup.php');


$ipopup=new IPopup('dtext');
$ipopup->value='';
$ipopup->title=_('Détail extension');
echo HtmlInput::hidden('popup','dtext').dossier::hidden();
echo $ipopup->input();

echo '<div class="content">';

$ext=Extension::listing($cn);
$new=new IButton('new');
$new->label=_('Nouvelle extension');
$new->javascript="new_extension()";
$str_new=$new->input();
require_once('template/extension.php');


echo '</div>';
