/*  This file is part of NI.

    NI is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    NI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NI; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2006 Michael Jumper
 */

// Configuration
/////////////////////
//#define DEBUG
//#define DUMP
//#define DEPTH
/////////////////////

#include <set>
using std::set;
using std::pair;

#include <map>
using std::map;

#include <iomanip>
using std::setfill;
using std::setw;
using std::hex;
using std::ios;

#include <iostream>
using std::cerr;

#include <ostream>
using std::ostream;

#include <unistd.h>
#include "altt.h"
#include "flags.h"

#ifdef DEBUG
#define debug(f) cerr << f
#define debugreturn(f) { cerr << "DEBUG RETURN: " << f << '\n'; return f; }
#else
#define debug(f)
#define debugreturn(f) return f
#endif

#ifdef DUMP
#define dump(f) debug(f)
#else
#define dump(f)
#endif

#ifdef DEPTH
int MAX_DEPTH=0;
int CUR_DEPTH=0;
#define depth_enter { CUR_DEPTH++;\
    if (CUR_DEPTH > MAX_DEPTH) {\
        cerr << "REACHED NEW MAXDEPTH: " << CUR_DEPTH << '\n';\
        MAX_DEPTH = CUR_DEPTH;\
    }}
#define depth_exit CUR_DEPTH--;
#else
#define depth_enter
#define depth_exit
#endif

#define PTR_SIZE_BITS	32
//#define PTR_SIZE_BITS	64

//struct altt* alttheap = NULL;
//struct list<altt_segment*> segheap;

set<altt> alttheap;
set<altt_segment> segheap;
map<long long, altt_segment*> result_cache;
map<long long, altt_segment*> xor_result_cache;
//altt* mask_all = NULL;

//bool no_mask_apply = false;

long nonunique_nands = 0;
long total_nands = 0;

bool equals(altt* a, altt* b) {
    // Kludge... there's a better way to do this without
    // calling xor()
    altt* res = wrapper(axor, a, b);
    if (res->b == NULL && res->a->type == ST_BIT0)
        return true;
    return false;
}

/*
void use_mask(altt* altt, int equals_type) {
    if (mask_all == NULL)
        mask_all = generate_mask(altt, equals_type);
    else
        mask_all = nand(mask_all, generate_mask(altt, equals_type))->inverse;
    debug("use_mask(): Set mask to " << *mask_all << '\n');
}

// Generates a mask representing the given condition
inline altt* generate_mask(altt* altt, int equals_type) {
    if (equals_type == ST_BIT1)
        return altt;
    if (equals_type == ST_BIT0)
        return altt->inverse;
    #ifdef DEBUG
    debug("FATAL: Tried to generate a mask with invalid type.\n");
    throw;
    #endif
}
*/

altt_segment* new_seg(int t, altt* p, int l) {

	assert(l >= 0);
	//assert(p == NULL || (p->length == l));
	
    if (t == ST_NULL)
        return NULL;

    if (t == ST_PRINT && p->b == NULL) {
        debug("new_seg(): Reducing segment...\n");
        return new_seg(p->a->type, p->a->print, l);
    }
    
    int nb1 = 0;
    if (t == ST_BIT1)
	    nb1 = 1;
    else if (t == ST_PRINT)
	    nb1 = p->num_bit1_segs;
    
    // Create segment and its inverse
    altt_segment seg = {t, p, l, nb1, NULL};
   
    altt_segment seginv;
    switch (t) {
        case ST_BITU:
            seginv.type = ST_BITU;
            seginv.print = NULL;
            seginv.length = l;
	    seginv.num_bit1_segs = 0; // ???
            break;
        case ST_BIT0:
            seginv.type = ST_BIT1;
            seginv.print = NULL;
            seginv.length = l;
	    seginv.num_bit1_segs = 1;
            break;
        case ST_BIT1:
            seginv.type = ST_BIT0;
            seginv.print = NULL;
            seginv.length = l;
	    seginv.num_bit1_segs = 0;
            break;
        case ST_PRINT:
            // Apply mask
            /*if (!no_mask_apply && mask_all != p->mask && p != mask_all) {
                debug("new_seg(): Applying mask " << *mask_all
                        << " to " << p << ": " << *p << "...\n");
                
                debug("mask: " << *mask_all << ' ' << *(p->mask) << '\n');
                
                //altt* temp_mask = mask_all;
                //mask_all = NULL;    // Prevent infinite recursion
                no_mask_apply = true;
                p = nand(p, mask_all)->inverse;
                no_mask_apply = false;
                //p->mask = mask_all;
                debug(&((alttheap.find(*p)->mask)) << '\n');
                //p->mask = temp_mask;
                //mask_all = temp_mask;
                
                seg.print = p;
                debug("new_seg(): Result of mask application: " << *p << '\n');
            }
            */
            seginv.type = ST_PRINT;
            seginv.print = p->inverse;
            seginv.length = l;
	    seginv.num_bit1_segs = p->inverse->num_bit1_segs;
            break;
        default:
            debug("FATAL: Trying to create segment with undefined type: "
                    << t << '\n');
            throw;
    }

    // Locate / insert segment into heap
    // We must use const_cast, since the inverse pointers must be changed.

    pair<set<altt_segment>::iterator, bool> p_gotseg = segheap.insert(seg);
    altt_segment* gotseg = const_cast<altt_segment*>
        (&(*(p_gotseg.first)));
    
    pair<set<altt_segment>::iterator, bool> p_gotseginv = segheap.insert(seginv);
    altt_segment* gotseginv = const_cast<altt_segment*>
        (&(*(p_gotseginv.first)));
    
    gotseg->inverse = gotseginv;
    gotseginv->inverse = gotseg;
    
    dump(gotseg->type << ' ' << gotseg->print << ' ' << gotseg->length << '\n');
    debug("new_seg(): " << *gotseg << '=' << gotseg << '\n');

    return gotseg;
    
}

altt* new_altt(int ta, altt* pa, int la,
       int tb, altt* pb, int lb) {

    altt retme;
    altt retme_inverse;
    
    retme.a = new_seg(ta, pa, la);
    retme.b = new_seg(tb, pb, lb);
    
    if (retme.a == retme.b) {
        debug("new_altt(): Reducing altt...\n");
        la++;
	tb = ST_NULL;	// This should have been done a LONG time ago
        retme.a = new_seg(ta, pa, la);
        retme.b = NULL;
    }
    /*else if (retme.b != NULL) {
        debug("new_altt(): not equal: " << *retme.a << ", " << *retme.b << '\n');
        debug("--------: " << pa << " " << pb << '\n');
    }*/
    
    retme_inverse.a = retme.a->inverse;

    if (retme.b != NULL)
        retme_inverse.b = retme.b->inverse;
    else
        retme_inverse.b = NULL;

    // Set length
    if (tb != ST_NULL) {
        retme.length = la+1;
        retme_inverse.length = la+1;
    }
    else {
        retme.length = la;
        retme_inverse.length = la;
    }
    
    // Set altt inverse pointers
    
    // Locate / insert altts into heap
    // We must use const_cast, since the inverse pointers must be changed.
    pair<set<altt>::iterator, bool> p1 = alttheap.insert(retme);
    altt* gotaltt = const_cast<altt*> (&(*(p1.first)));
    
    pair<set<altt>::iterator, bool> p2 = alttheap.insert(retme_inverse);
    altt* gotalttinv = const_cast<altt*> (&(*(p2.first)));
    
    gotaltt->inverse = gotalttinv;
    gotalttinv->inverse = gotaltt;

    int nbs;
    
    nbs = gotaltt->a->num_bit1_segs;
    if (gotaltt->b != NULL) nbs += gotaltt->b->num_bit1_segs;
    if (nbs > 2) nbs = 2;
    gotaltt->num_bit1_segs = nbs;
    
    nbs = gotalttinv->a->num_bit1_segs;
    if (gotalttinv->b != NULL) nbs += gotalttinv->b->num_bit1_segs;
    if (nbs > 2) nbs = 2;
    gotalttinv->num_bit1_segs = nbs;
    
    //gotaltt->mask = mask_all;
    //gotalttinv->mask = mask_all;

    dump(gotaltt->a << ' ' << gotaltt->b << ' ' << gotaltt->length << '\n');
    debug("new_altt(): " << *gotaltt << '=' << gotaltt << '\n');
   
    return gotaltt;
    
}

// Second parm is NOT used.
altt_segment* anot_n(altt_segment* altta, altt_segment* dummy) {
    return altta->inverse;
}

altt_segment* aand_n(altt_segment* altta, altt_segment* alttb) {
    return nand(altta, alttb)->inverse;
}


altt_segment* aor_n(altt_segment* altta, altt_segment* alttb) {
    return nand(altta->inverse, alttb->inverse);
}

altt_segment* axor_n(altt_segment* altta, altt_segment* alttb) {
    //return nand(altta->inverse, alttb->inverse);
    return nand(nand(altta->inverse, alttb), nand(alttb->inverse, altta));
}

altt_segment* axor(altt_segment* altta, altt_segment* alttb) {

    altt_segment* ret;
    
    debug("nand(): altta=" << *altta << ", alttb=" << *alttb << '\n');
    depth_enter;

    total_nands++;
    long last_tn = total_nands;
    
    // Here - fix lengths of input segments
    // (If an input segment has an improper length,
    // create a new segment identical to that segment with
    // the correct length, and delete the temporary segment at the end)
    if (altta->type == ST_PRINT) {
        int proper_length = altta->print->a->length;
        if (altta->print->b != NULL) proper_length++;
        if (altta->length != proper_length) {
            debug("------: altta->length is being corrected to " << proper_length << '\n');
            altta = new_seg(altta->type, altta->print, proper_length);
        }
    }
    if (alttb->type == ST_PRINT) {
        int proper_length = alttb->print->a->length;
        if (alttb->print->b != NULL) proper_length++;
        if (alttb->length != proper_length) {
            debug("------: alttb->length is being corrected to " << proper_length << '\n');
            alttb = new_seg(alttb->type, alttb->print, proper_length);
        }
    }
     
    // Ensure that altta->length >= alttb->length
    if (alttb->length > altta->length) {
        debug("------: altta and alttb are being swapped.\n");
        altt_segment* temp = altta;
        altta = alttb;
        alttb = temp;
    }
    
    // Generate key
    map<long long, altt_segment*>::iterator key_it;
    long long key = 0;
    key = (unsigned int) altta; key <<= PTR_SIZE_BITS;
    key |= (unsigned int) alttb;
    
    
    //if ((altta->type == ST_BITX && alttb->type != ST_PRINT) ||
    //        (alttb->type == ST_BITX && altta->type != ST_PRINT)) {
    
     // Exit conditions...
    // if we've done this before...
    if ((key_it = xor_result_cache.find(key)) != xor_result_cache.end()) {
        debug("------: EQUAL.\n");
        ret = key_it->second;
        nonunique_nands++;
    }
    // 0:n nand anything is alttb
    else if (altta->type == ST_BIT0) {
        debug("------: altta is ST_BIT0\n");
        ret = new_seg(alttb->type, alttb->print, altta->length);
    }
    // 1:n nand alttb is alttb's inverse (same goes for altta nand altta)
    else if (altta->type == ST_BIT1) {
        debug("------: altta is ST_BIT1\n");
        ret = new_seg(alttb->inverse->type, alttb->inverse->print, altta->length);
    }
    // 0:n nand anything is 1:n
    else if (alttb->type == ST_BIT0) {
        debug("------: alttb is ST_BIT0\n");
        ret = new_seg(altta->type, altta->print, altta->length);
    }
    // 1:n nand altta is altta's inverse
    else if (alttb->type == ST_BIT1) {
        debug("------: alttb is ST_BIT1\n");
        ret = new_seg(altta->inverse->type, altta->inverse->print, altta->length);
    }
    else if (altta == alttb->inverse) {
        debug("------: altta == !alttb \n");
        ret = new_seg(ST_BIT1, NULL, altta->length);
    }
    else if (altta == alttb) {
        debug("------: altta == alttb \n");
        ret = new_seg(ST_BIT0, NULL, altta->length);
    }
    else if (altta->type == ST_BITU && alttb->type == ST_BITU) {
        debug("------: altta, alttb both is ST_BITU\n");
        ret = new_seg(ST_BITU, NULL, altta->length);
    }
    
    // If we've reached here, both types are either ST_PRINT or ST_NULL
    // We asume ST_PRINT.
    else if (altta->length > alttb->length) {
        debug("------: altta, alttb should be ST_PRINT " << altta->type
                << ", " << alttb->type << '\n');
        debug("------: altta->length > alttb->length\n");
        altt_segment *a, *b;

        altt_segment* first_half;
        altt_segment* second_half;
        if (altta->type != ST_PRINT) {
            // Chop in half
            debug("------: altta is not ST_PRINT, chopping into halves...\n");
            first_half = second_half =
                new_seg(altta->type, altta->print, 0 /*altta->length-1*/);
        }
        else {
            first_half = altta->print->a;
            second_half = altta->print->b;
        }
        
        debug(">>----: Calling nand() for part a of result...\n");
	//TODO:
	//Check mask->a. Do this only if not ST_BIT0, otherwise set a to NULL.
        a = axor(alttb, first_half);
        debug("<<----: Back from call to nand()\n");
        if (second_half != NULL) {
            a = new_seg(a->type, a->print, altta->length-1);	// TODO: Only if a is not NULL.
            debug(">>----: Calling nand() for part b of result...\n");
	    //TODO:
	    //Check mask->b. Do this only if not ST_BIT0, otherwise set a to NULL.
            b = axor(alttb, second_half);
            b = new_seg(b->type, b->print, altta->length-1);
	    // TODO: If a is NULL, create new seg from b. If b is NULL, create new seg from a.
	    // Else, continue as before (add assertion that a and b are both not NULL)
            debug("<<----: Back from call to nand()\n");
            ret = new_seg(ST_PRINT, 
                    new_altt(a->type, a->print, a->length,
                    b->type, b->print, b->length),
                    altta->length);
        }
        else
            ret = new_seg(a->type, a->print, altta->length);
        //total_nands = last_tn;
    }
    
    else if (altta->length == alttb->length) {
        //total_nands++;
        debug("------: altta, alttb should be ST_PRINT " << altta->type
                << ", " << alttb->type << '\n');
        debug("------: altta->length == alttb->length\n");
        altt_segment *a, *b;

        altt_segment* first_half_a;
        altt_segment* second_half_a;
        if (altta->type != ST_PRINT) {
            // Chop in half
            debug("------: altta is not ST_PRINT, chopping into halves...\n");
            first_half_a = second_half_a =
                new_seg(altta->type, altta->print, 0 /*altta->length-1*/);
        }
        else {
            first_half_a = altta->print->a;
            second_half_a = altta->print->b;
        }
        
        altt_segment* first_half_b;
        altt_segment* second_half_b;
        if (alttb->type != ST_PRINT) {
            // Chop in half
            debug("------: alttb is not ST_PRINT, chopping into halves...\n");
            first_half_b = second_half_b =
                new_seg(alttb->type, alttb->print, 0 /*alttb->length-1*/);
        }
        else {
            first_half_b = alttb->print->a;
            second_half_b = alttb->print->b;
        }
        
        debug(">>----: Calling nand() for part a of result...\n");
        a = axor(first_half_a, first_half_b);
        debug("<<----: Back from call to nand()\n");
        if (second_half_a != NULL && second_half_b != NULL) {
            a = new_seg(a->type, a->print, altta->length-1);
            debug(">>----: Calling nand() for part b of result...\n");
            b = axor(second_half_a, second_half_b);
            b = new_seg(b->type, b->print, altta->length-1);
            debug("<<----: Back from call to nand()\n");
            ret = new_seg(ST_PRINT, 
                    new_altt(a->type, a->print, a->length,
                    b->type, b->print, b->length),
                    altta->length);
        }
        else
            ret = new_seg(a->type, a->print, altta->length);
    }

    
#ifdef DEBUG
    if (ret->print != NULL) {
        if (ret->print->b != NULL) {
            if (ret->print->a->length != ret->print->length-1 ||
                    ret->print->b->length != ret->print->length-1) {
                debug("REALLY BAD: Length mismatch A: a.length="
                        << ret->print->a->length << ", b.length="
                        << ret->print->b->length << ", total should be "
                        << ret->print->length << '\n');
            }
        }
        else {
            if (ret->print->a->length != ret->print->length) {
                debug("REALLY BAD: Length mismatch B: a.length="
                        << ret->print->a->length << ", total should be "
                        << ret->print->length << '\n');
            }
        }
    }
#endif

 
    //cerr << *altta << " with " << *alttb << " -> " << *ret << '\n';
    //cerr << "KEY FOR " << *altta << ' ' << *alttb << ": " << key << '\n';
    debug("------: now ret=" << *ret << " (" << ret << ")\n");

    //if (ret->type == ST_PRINT) ret->print->mask = mask_all;
    
    xor_result_cache[key] = ret;
    depth_exit;
    
    return ret;
    
}


// Wrapper for nand
altt* wrapper(altt_segment* (*func)(altt_segment*, altt_segment*), altt* a, altt* b) {
    // Create ST_PRINT segments around the altts
    // and call nand() with those segments.

    debug("nand(): WRAPPER: Generating segments for " << *a << " and " << *b << '\n');
    
    altt_segment* wa;
    altt_segment* wb;
    
    if (a->b != NULL)
        wa = new_seg(ST_PRINT, a, a->length);
    else
        wa = a->a;
    
    if (b->b != NULL)
        wb = new_seg(ST_PRINT, b, b->length);
    else
        wb = b->a;
    
    altt_segment* retme = (*func)(wa, wb);
    if (retme->type == ST_PRINT)
        return retme->print;
    else
        return new_altt(retme->type, NULL, retme->length, ST_NULL, NULL, 0);
    
}

// Nands together two segments (altta and alttb), result is stored in
// ret.
altt_segment* nand(altt_segment* altta, altt_segment* alttb) {

    altt_segment* ret;
    
    debug("nand(): altta=" << *altta << ", alttb=" << *alttb << '\n');
    depth_enter;

    total_nands++;
    long last_tn = total_nands;
    
    // Here - fix lengths of input segments
    // (If an input segment has an improper length,
    // create a new segment identical to that segment with
    // the correct length, and delete the temporary segment at the end)
    if (altta->type == ST_PRINT) {
        int proper_length = altta->print->a->length;
        if (altta->print->b != NULL) proper_length++;
        if (altta->length != proper_length) {
            debug("------: altta->length is being corrected to " << proper_length << '\n');
            altta = new_seg(altta->type, altta->print, proper_length);
        }
    }
    if (alttb->type == ST_PRINT) {
        int proper_length = alttb->print->a->length;
        if (alttb->print->b != NULL) proper_length++;
        if (alttb->length != proper_length) {
            debug("------: alttb->length is being corrected to " << proper_length << '\n');
            alttb = new_seg(alttb->type, alttb->print, proper_length);
        }
    }
     
    // Ensure that altta->length >= alttb->length
    if (alttb->length > altta->length) {
        debug("------: altta and alttb are being swapped.\n");
        altt_segment* temp = altta;
        altta = alttb;
        alttb = temp;
    }

    
    // Generate key
    map<long long, altt_segment*>::iterator key_it;
    long long key = 0;
    key = (unsigned int) altta; key <<= PTR_SIZE_BITS;
    key |= (unsigned int) alttb;
    
    
    //if ((altta->type == ST_BITX && alttb->type != ST_PRINT) ||
    //        (alttb->type == ST_BITX && altta->type != ST_PRINT)) {

    // Exit conditions...
    // if we've done this before...
    if ((key_it = result_cache.find(key)) != result_cache.end()) {
        debug("------: EQUAL.\n");
        ret = key_it->second;
        nonunique_nands++;
    }
    // 0:n nand anything is 1:n
    else if (altta->type == ST_BIT0) {
        debug("------: altta is ST_BIT0\n");
        ret = new_seg(ST_BIT1, NULL, altta->length);
    }
    else if (altta->type == ST_BIT1 && alttb->type == ST_BIT1) {
	    ret = new_seg(ST_BIT0, NULL, altta->length);
    }
    // 0:n nand anything is 1:n
    else if (alttb->type == ST_BIT0) {
        debug("------: alttb is ST_BIT0\n");
        ret = new_seg(ST_BIT1, NULL, altta->length);
    }
    // 1:n nand altta is altta's inverse
    else if (alttb->type == ST_BIT1) {
        debug("------: alttb is ST_BIT1\n");
        ret = new_seg(altta->inverse->type, altta->inverse->print, altta->length);
    }
    else if (altta->type == ST_BITU && alttb->type == ST_BITU) {
        debug("------: altta, alttb both is ST_BITU\n");
        ret = new_seg(ST_BITU, NULL, altta->length);
    }
    else if (altta == alttb->inverse) {
        debug("------: altta == !alttb \n");
        ret = new_seg(ST_BIT1, NULL, altta->length);
    }
    // If we've reached here, both types are either ST_PRINT or ST_NULL
    // We asume ST_PRINT.
    else if (altta->length > alttb->length) {
        debug("------: altta, alttb should be ST_PRINT " << altta->type
                << ", " << alttb->type << '\n');
        debug("------: altta->length > alttb->length\n");
        altt_segment *a, *b;

        altt_segment* first_half;
        altt_segment* second_half;
        if (altta->type != ST_PRINT) {
            // Chop in half
            debug("------: altta is not ST_PRINT, chopping into halves...\n");
            first_half = second_half =
                new_seg(altta->type, altta->print, 0 /*altta->length-1*/);
        }
        else {
            first_half = altta->print->a;
            second_half = altta->print->b;
        }
        
        debug(">>----: Calling nand() for part a of result...\n");
        a = nand(alttb, first_half);
        debug("<<----: Back from call to nand()\n");
        if (second_half != NULL) {
            a = new_seg(a->type, a->print, altta->length-1);
            debug(">>----: Calling nand() for part b of result...\n");
            b = nand(alttb, second_half);
            b = new_seg(b->type, b->print, altta->length-1);
            debug("<<----: Back from call to nand()\n");
            ret = new_seg(ST_PRINT, 
                    new_altt(a->type, a->print, a->length,
                    b->type, b->print, b->length),
                    altta->length);
        }
        else
            ret = new_seg(a->type, a->print, altta->length);
        //total_nands = last_tn;
    }
    
    else if (altta->length == alttb->length) {
        //total_nands++;
        debug("------: altta, alttb should be ST_PRINT " << altta->type
                << ", " << alttb->type << '\n');
        debug("------: altta->length == alttb->length\n");
        altt_segment *a, *b;

        altt_segment* first_half_a;
        altt_segment* second_half_a;
        if (altta->type != ST_PRINT) {
            // Chop in half
            debug("------: altta is not ST_PRINT, chopping into halves...\n");
            first_half_a = second_half_a =
                new_seg(altta->type, altta->print, 0 /*altta->length-1*/);
        }
        else {
            first_half_a = altta->print->a;
            second_half_a = altta->print->b;
        }
        
        altt_segment* first_half_b;
        altt_segment* second_half_b;
        if (alttb->type != ST_PRINT) {
            // Chop in half
            debug("------: alttb is not ST_PRINT, chopping into halves...\n");
            first_half_b = second_half_b =
                new_seg(alttb->type, alttb->print, 0 /*alttb->length-1*/);
        }
        else {
            first_half_b = alttb->print->a;
            second_half_b = alttb->print->b;
        }
        
        debug(">>----: Calling nand() for part a of result...\n");
        a = nand(first_half_a, first_half_b);
        debug("<<----: Back from call to nand()\n");
        if (second_half_a != NULL && second_half_b != NULL) {
            a = new_seg(a->type, a->print, altta->length-1);
            debug(">>----: Calling nand() for part b of result...\n");
            b = nand(second_half_a, second_half_b);
            b = new_seg(b->type, b->print, altta->length-1);
            debug("<<----: Back from call to nand()\n");
            ret = new_seg(ST_PRINT, 
                    new_altt(a->type, a->print, a->length,
                    b->type, b->print, b->length),
                    altta->length);
        }
        else
            ret = new_seg(a->type, a->print, altta->length);
    }
    
#ifdef DEBUG
    if (ret->print != NULL) {
        if (ret->print->b != NULL) {
            if (ret->print->a->length != ret->print->length-1 ||
                    ret->print->b->length != ret->print->length-1) {
                debug("REALLY BAD: Length mismatch A: a.length="
                        << ret->print->a->length << ", b.length="
                        << ret->print->b->length << ", total should be "
                        << ret->print->length << '\n');
            }
        }
        else {
            if (ret->print->a->length != ret->print->length) {
                debug("REALLY BAD: Length mismatch B: a.length="
                        << ret->print->a->length << ", total should be "
                        << ret->print->length << '\n');
            }
        }
    }
#endif


    //cerr << *altta << " with " << *alttb << " -> " << *ret << '\n';
    //cerr << "KEY FOR " << *altta << ' ' << *alttb << ": " << key << '\n';
    debug("------: now ret=" << *ret << " (" << ret << ")\n");

    //if (ret->type == ST_PRINT) ret->print->mask = mask_all;
    
    result_cache[key] = ret;
    depth_exit;
    
    return ret;
    
}


// Generates a general altt, returns a pointer to it.
altt* generate_general_altt(int order) {
    return new_altt(ST_BIT0, NULL, order, ST_BIT1, NULL, order);
}

// Prints symbolic notation of a segment
ostream& operator<< (ostream& out, const altt_segment& seg) {
    if (seg.type == ST_NULL) return out;
    if (seg.type == ST_BIT0)
        out << "0:" << seg.length;
    else if (seg.type == ST_BIT1)
        out << "1:" << seg.length;
    else if (seg.type == ST_BITU)
        out << "?:" << seg.length;
    else if (seg.type == ST_PRINT)
        out << '(' << *(seg.print) << "):" << seg.length;
    else
        out << "[UNDEFINED_SEG_TYPE: " << seg.type  << ']';

    return out;
}

// Prints the symbolic notation of a altt.
ostream& operator<< (ostream& out, const altt& altt) {
    
    if (&altt == NULL) {
        out << "NULL";
        return out;
    }
    
    out << *altt.a;
    if (altt.b != NULL)
        out << '|' << *altt.b;
    
    //out << "]:" << altt.length;
    
    return out;
}

int print_tt(ostream& out, const altt_segment& seg, int& var_vals, int var_count) {
    int l = 1 << seg.length;
    char och;
    if (seg.type == ST_BIT0)
        och = '0';
    else if (seg.type == ST_BIT1)
        och = '1';
    else if (seg.type == ST_BITU)
        och = '?';
    else if (seg.type == ST_PRINT) {
        for (int i=0; i<l; i+=print_tt(out, *(seg.print), var_vals, var_count));
        return l;
    }

    for (int i=0; i<l; i++) {
        int temp = var_vals;
        for (int x=0; x<var_count; x++) {
            out << ' ' << (temp & 1);
            temp = temp >> 1;
        }
        out << " | " << och << '\n';
        var_vals++;
    }

    return l;
    
}

int print_tt(ostream& out, const altt& altt, int& var_vals, int var_count) {
    //if (altt.length > 26) {
    //    cerr << "Cannot convert ALTT to truth table - too many variables!\n";
    //    return 0;
    //}

    int l = print_tt(out, *(altt.a), var_vals, var_count);
    if (altt.b != NULL) {
        l += print_tt(out, *(altt.b), var_vals, var_count);
    }
    return l;
    
}

int print_expanded(ostream& out, const altt& altt) {
    /*if (altt.length > 29) {
        cerr << "Cannot convert ALTT to LTT, LTT would be too large!!!\n";
        return 0;
    }*/
    int l = print_expanded(out, *(altt.a));
    if (altt.b != NULL) {
        l += print_expanded(out, *(altt.b));
    }
    return l;
}

int print_expanded(ostream& out, const altt_segment& seg) {
    int l = 1 << seg.length;
    if (seg.type == ST_BIT0) {
        for (int i=0; i<l; i++)
            out << '0';
        return l;
    }
    else if (seg.type == ST_BIT1) {
        for (int i=0; i<l; i++)
            out << '1';
        return l;
    }
    else if (seg.type == ST_BITU) {
        for (int i=0; i<l; i++)
            out << '?';
        return l;
    }
    else if (seg.type == ST_PRINT) {
        for (int i=0; i<l; i+=print_expanded(out, *(seg.print)));
        return l;
    }
}

inline void print_gvar(ostream& out, int i) {
	if (i <= 25)
		out << (char) ('a' + i);
	else
		out << 'g' << i;
}

void print_function(ostream& out, const altt_segment& seg, bool paren_if_and, bool paren_if_or, bool paren_if_xor) {
	if (seg.type == ST_BIT0)
		out << '0';
	else if (seg.type == ST_BIT1)
		out << '1';
	else if (seg.type == ST_BITU)
		out << '?';
	else if (seg.type == ST_PRINT)
		print_function(out, *(seg.print), paren_if_and, paren_if_or, paren_if_xor);
	else	assert(false);	// This shouldn't happen
}

void print_function(ostream& out, const altt& xaltt, bool paren_if_and, bool paren_if_or, bool paren_if_xor) {
	altt_segment* a = xaltt.a;
	altt_segment* b = xaltt.b;

	if (b == NULL)
		print_function(out, *a, paren_if_and, paren_if_or, paren_if_xor);
	else if (a->type == ST_BIT0 && b->type == ST_BIT1)
		print_gvar(out, a->length);
	else if (a->type == ST_BIT1 && b->type == ST_BIT0) {
		out << '!';
		print_gvar(out, a->length);
	}
	else if (b->type == ST_BIT1) {
		if (paren_if_or) out << '(';
		print_gvar(out, a->length);
		// Simplify a, knowing that the general variable provides ones.
		if (simplify_level >= 2 && a->type == ST_PRINT) {
			altt* p = simplify(a->print, generate_general_altt(a->length)->inverse);
			a = new_seg(ST_PRINT, p, p->length);
		}
		out << " | ";
		print_function(out, *a, true, false, true);
		if (paren_if_or) out << ')';
	}
	else if (a->type == ST_BIT1) {
		if (paren_if_or) out << '(';
		out << '!';
		print_gvar(out, a->length);
		// Simplify b, knowing that the inverse general variable provides ones.
		if (simplify_level >= 2 && b->type == ST_PRINT) {
			altt* p = simplify(b->print, generate_general_altt(a->length));
			b = new_seg(ST_PRINT, p, p->length);
		}
		out << " | ";
		print_function(out, *b, true, false, true);
		if (paren_if_or) out << ')';
	}
	else if (b->type == ST_BIT0) {
		if (paren_if_and) out << '(';
		out << '!';
		print_gvar(out, a->length);
		// Simplify a, knowing that the inverse general variable provides zeroes.
		if (simplify_level >= 2 && a->type == ST_PRINT) {
			altt* p = simplify(a->print, generate_general_altt(a->length)->inverse);
			a = new_seg(ST_PRINT, p, p->length);
		}
		out << " & ";
		print_function(out, *a, false, true, true);
		if (paren_if_and) out << ')';
	}
	else if (a->type == ST_BIT0) {
		if (paren_if_and) out << '(';
		print_gvar(out, a->length);
		// Simplify b, knowing that the general variable provides zeroes.
		if (simplify_level >= 2 && b->type == ST_PRINT) {
			altt* p = simplify(b->print, generate_general_altt(a->length));
			b = new_seg(ST_PRINT, p, p->length);
		}
		out << " & ";
		print_function(out, *b, false, true, true);
		if (paren_if_and) out << ')';
	}
	else if (a == b->inverse) {	// XOR
		if (paren_if_xor) out << '(';
		print_gvar(out, a->length);
		out << " ^ ";
		print_function(out, *(b->inverse), true, true, false);
		if (paren_if_xor) out << ')';
	}
	else if (a->type == ST_PRINT && b->type == ST_PRINT) {
		if (paren_if_or) out << '(';
		altt* test;
		altt* a_res;
		
		test = (simplify_level >= 1) ? wrapper(aor_n, a->print, wrapper(aand_n, generate_general_altt(a->length), b->print)) : NULL;
		if (test == &xaltt) {
			print_function(out, *a, true, false, true);
			a_res = a->print;
		}
		else {
			out << "(!";
			print_gvar(out, a->length);
			out << " & ";
			print_function(out, *a, false, true, true);
			out << ')';
			a_res = wrapper(aand_n, generate_general_altt(a->length)->inverse, a->print);
		}

		
		if (simplify_level >= 2 && b->type == ST_PRINT) {
			altt* p = simplify(b->print, a_res->inverse);
			b = new_seg(ST_PRINT, p, p->length);
		}
		
		out << " | ";
		
		test = (simplify_level >= 1) ? wrapper(aor_n, a_res, b->print) : NULL;
		if (test == &xaltt) {
			//altt* p = simplify(b->print, a_res->inverse);
			//b = new_seg(ST_PRINT, p, p->length);
			print_function(out, *b, true, false, true);
		}
		else {
			out << '(';
			print_gvar(out, a->length);
			out << " & ";
			print_function(out, *b, false, true, true);
			out << ')';
		}

		if (paren_if_or) out << ')';
	}
	else assert(false);	// ST_BITU, etc. have NOT been implemented here yet.
}

altt* join(altt* a, altt* b) {

	if (a == NULL) return b;
	if (b == NULL) return a;
	
	int glen = b->length;
	if (a->length > b->length)
		glen = a->length;
	
	if (a->b == NULL && b->b == NULL)
		return new_altt(a->a->type, a->a->print, glen,
				b->a->type, b->a->print, glen);
	else if (a->b == NULL)
		return new_altt(a->a->type, a->a->print, glen,
				ST_PRINT, b, glen);
	else if (a->a == NULL)
		return new_altt(ST_PRINT, a, glen,
				b->a->type, b->a->print, glen);

	return new_altt(ST_PRINT, a, glen,
			ST_PRINT, b, glen);
	
}

inline altt_segment* shrink(altt_segment* a) {
	
	int l = a->length;
	if (a->type == ST_PRINT)
		l = a->print->length;
	
	return new_seg(a->type, a->print, l);
}

altt* simplify(altt* a, altt* mask) {

	// ADD: If (return segment b) & (return segment a's mask segment)
	//      == (return segment a & a's mask segment), set return segment b to a.
	// and vice-versa. This could, perhaps, replace entire algorithm?
	//
	// TODO: Try replacing this function with above described simpler
	// algorithm.
	//
	// ie:
	//
	
	//cerr << *a << ' ' << *mask << '\n';
	if (mask->b == NULL && mask->a->type == ST_BIT0)
		return NULL;
	
	altt_segment* a_a = a->a;
	altt_segment* a_b = a->b;

	if (mask->length < a->length && a->b != NULL) {
		altt* na;
		if (a->a->type != ST_PRINT)
			na = new_altt(a->a->type, a->a->print, a->a->length, ST_NULL, NULL, 0);
		else
			na = a->a->print;
		altt* resa = simplify(na, mask);
		
		altt* nb;
		if (a->b->type != ST_PRINT)
			nb = new_altt(a->b->type, a->b->print, a->b->length, ST_NULL, NULL, 0);
		else
			nb = a->b->print;
		altt* resb = simplify(nb, mask);

		if (simplify_level >= 2 && resa != NULL && resb != NULL) {
			if (wrapper(aand_n, resb, mask) == wrapper(aand_n, resa, mask))
				resa = resb;
			else if (wrapper(aand_n, resb, mask) == wrapper(aand_n, resa, mask))
				resb = resa;
		}
		
		return join(resa, resb);
	}

	if (mask->length > a->length && mask->b != NULL) {
		altt* na;
		if (mask->a->type != ST_PRINT)
			na = new_altt(mask->a->type, mask->a->print, mask->a->length, ST_NULL, NULL, 0);
		else
			na = mask->a->print;
		altt* resa = simplify(a, na);
		
		altt* nb;
		if (mask->b->type != ST_PRINT)
			nb = new_altt(mask->b->type, mask->b->print, mask->b->length, ST_NULL, NULL, 0);
		else
			nb = mask->b->print;
		altt* resb = simplify(a, nb);
		
		if (simplify_level >= 2 && resa != NULL && resb != NULL) {
			if (wrapper(aand_n, resb, na) == wrapper(aand_n, resa, na))
				resa = resb;
			else if (wrapper(aand_n, resb, nb) == wrapper(aand_n, resa, nb))
				resb = resa;
		}
		
		return join(resa, resb);
	}
	
	altt_segment* maska = mask->a;
	altt_segment* maskb;
	if (mask->b != NULL)
		maskb = mask->b;
	else
		maskb = maska;
	
	if (maska->type == ST_PRINT && a_a->type == ST_PRINT) {
		if (maska == a_a)
			a_a = new_seg(ST_BIT1, NULL, a_a->length);
		else {
			altt* p = simplify(a_a->print, maska->print);
			a_a = new_seg(ST_PRINT, p, a_a->length);
		}
	}

	if (a_b != NULL) {
		if (maskb->type == ST_PRINT && a_b->type == ST_PRINT) {
			if (maskb == a_b)
				a_b = new_seg(ST_BIT1, NULL, a_b->length);
			else {
				altt* p = simplify(a_b->print, maskb->print);
				a_b = new_seg(ST_PRINT, p, a_b->length);
			}
		}
		
		if (maska->type == ST_BIT0) a_a = a_b;
		if (maskb->type == ST_BIT0) a_b = a_a;
		
		if (a_a == a_b) {
			if (a_a->type == ST_PRINT)
				return a_a->print;
			return new_altt(a_a->type, a_a->print, a_a->length,
					ST_NULL, NULL, 0);
		}
		
		if (simplify_level >= 2) {
			if (shrink(aand_n(a_b, maska)) == shrink(aand_n(a_a, maska)))
				a_a = a_b;
			else if (shrink(aand_n(a_b, maskb)) == shrink(aand_n(a_a, maskb)))
				a_b = a_a;
		}
		
		return new_altt(a_a->type, a_a->print, a_a->length,
				a_b->type, a_b->print, a_b->length);
	}
	else {
		//cerr << "!!!\n";
		if (a_a->type == ST_PRINT)
			return a_a->print;

		return new_altt(a_a->type, a_a->print, a_a->length,
				ST_NULL, NULL, 0);
	}
	
	
}

int get_bit(struct altt_segment* altt_head, int n) {
    ///////////////// STUB
    ///////////////// STUB
    ///////////////// STUB
    ///////////////// STUB
}

inline bool operator<(const altt_segment& a, const altt_segment& b) {
    if (a.type < b.type) return true;
    if (a.type > b.type) return false;
    
    if (a.print < b.print) return true;
    if (a.print > b.print) return false;
    
    if (a.length < b.length) return true;
    
    return false;
}

inline bool operator<(const altt& a, const altt& b) {
    if (a.a < b.a) return true;
    if (a.a > b.a) return false;
    
    if (a.b < b.b) return true;
    if (a.b > b.b) return false;
    
    if (a.length < b.length) return true;
    
    return false;
}

