/*  This file is part of NI.

    NI is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    NI is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NI; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    Copyright (C) 2006 Michael Jumper
 */


// ALTT orders essentially describe the length.
// Beginning with n=0, a nth order altt is 2^(n+1)
// bits long.
//
// General altts are those assigned to independent variables
// (vars without altts and not produced from nand calculations)
// An nth order general altt is 2^n 0's followed by 2^n 1's
//
// All altts are either 0, 1, general, or the result of a
// calculation.

#ifndef ALTT_H
#define ALTT_H

#include <ostream>
using std::ostream;

#include <set>
using std::set;

#include <map>
using std::map;

#define ST_NULL     -2
#define ST_PRINT    -1
#define ST_BIT0     0
#define ST_BIT1     1
#define ST_BITU     2   // Unknown

#define NO_BIT1            0
#define ONE_BIT1           1
#define MORE_THAN_ONE_BIT1 2

// Forward declaration
struct altt;

// Represents a segment of a altt
struct altt_segment {
    int type;           // Any of the ST_... constants
    altt* print;   // Only for ST_PRINT
    int length;   // The exponent of a power of two.
    int num_bit1_segs;

    altt_segment* inverse;
};

struct altt {
    altt_segment* a;
    altt_segment* b;
    int length;  // This should be equal to both a.length+1 and b.length+1
    int num_bit1_segs;

    altt* inverse;     // Pointer to a altt which is !this
    //altt* mask;        // Pointer to most recently applied mask
};

//extern struct altt* alttheap;
//extern list<altt_segment*> segheap;

extern set<altt> alttheap;
extern set<altt_segment> segheap;
extern map<long long, altt_segment*> result_cache;
//extern altt* mask_all;

extern long nonunique_nands;
extern long total_nands;

altt* wrapper(altt_segment* (*)(altt_segment*, altt_segment*), altt*, altt*);
altt_segment* nand(altt_segment*, altt_segment*);
altt_segment* anot_n(altt_segment*, altt_segment*);
altt_segment* aand_n(altt_segment*, altt_segment*);
altt_segment* aor_n(altt_segment*, altt_segment*);
altt_segment* axor_n(altt_segment*, altt_segment*);
altt_segment* axor(altt_segment*, altt_segment*);
int get_bit(struct altt*, int);
altt_segment* new_seg(int, altt*, int);
altt* new_altt(int, altt*, int, int, altt*, int);
altt* generate_general_altt(int);
altt_segment* shrink(altt_segment*);
//void use_mask(altt*, int);
//altt* generate_mask(altt*, int);
ostream& operator<<(ostream&, const altt_segment&);
ostream& operator<<(ostream&, const altt&);
int print_expanded(ostream&, const altt_segment&);
int print_expanded(ostream&, const altt&);
int print_tt(ostream&, const altt_segment&, int&, int);
int print_tt(ostream&, const altt&, int&, int);
void print_function(ostream&, const altt&, bool, bool, bool);
altt* simplify(altt*, altt*);
bool equals(altt*, altt*);
inline bool operator<(const altt_segment&, const altt_segment&);
inline bool operator<(const altt&, const altt&);
inline bool operator==(const altt&, const altt&);

#endif

