/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.AudioConfiguration;
import irc.FileHandler;
import irc.FileTextProvider;
import irc.IRCConfiguration;
import irc.ImageLoader;
import irc.ParameterProvider;
import irc.PrefixedParameterProvider;
import irc.ServerItem;
import irc.SoundHandler;
import irc.StartupConfiguration;
import irc.StringParser;
import irc.TextProvider;
import irc.URLHandler;
import java.awt.Color;
import java.awt.Font;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class ConfigurationLoader {
    private ParameterProvider _provider;
    private URLHandler _handler;
    private ImageLoader _loader;
    private SoundHandler _sound;
    private FileHandler _file;

    public ConfigurationLoader(ParameterProvider parameterProvider, URLHandler uRLHandler, ImageLoader imageLoader, SoundHandler soundHandler, FileHandler fileHandler) {
        this._provider = parameterProvider;
        this._handler = uRLHandler;
        this._loader = imageLoader;
        this._sound = soundHandler;
        this._file = fileHandler;
    }

    public IRCConfiguration loadIRCConfiguration() throws Exception {
        return this.getIRCConfiguration();
    }

    public StartupConfiguration loadStartupConfiguration() throws Exception {
        return this.getStartupConfiguration();
    }

    private String getParameter(String string) {
        return this._provider.getParameter(string);
    }

    private boolean getBoolean(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return bl;
        }
        return (string2 = string2.toLowerCase(Locale.ENGLISH).trim()).equals("true") || string2.equals("on") || string2.equals("1");
    }

    private String getString(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    private int getInt(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    private void readBackgroundConfig(IRCConfiguration iRCConfiguration) {
        StringParser stringParser = new StringParser();
        String[] stringArray = this.getArray("style:backgroundimage");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = stringParser.parseString(string);
            if (stringArray2.length < 4) continue;
            String string2 = stringArray2[0];
            String string3 = stringArray2[1];
            int n = new Integer(stringArray2[2]);
            String string4 = stringArray2[3];
            iRCConfiguration.setBackgroundImage(string2, string3, string4);
            iRCConfiguration.setBackgroundTiling(string2, string3, n);
        }
    }

    private TextProvider getTextProvider() {
        String string = this.getString("language", "english");
        String string2 = this.getString("languageencoding", "");
        String string3 = this.getString("lngextension", "lng");
        String string4 = this.getString("backuplanguage", "english");
        String string5 = this.getString("backuplanguageencoding", "");
        return new FileTextProvider(string + "." + string3, string2, string4 + "." + string3, string5, this._file);
    }

    private String[] getArray(String string) {
        String string2;
        Vector<String> vector = new Vector<String>();
        int n = 1;
        do {
            if ((string2 = this.getParameter(string + n)) != null) {
                vector.insertElementAt(string2, vector.size());
            }
            ++n;
        } while (string2 != null);
        String[] stringArray = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray[n] = (String)vector.elementAt(n);
        }
        return stringArray;
    }

    private void readSmileys(IRCConfiguration iRCConfiguration) {
        String[] stringArray = this.getArray("style:smiley");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = string.indexOf(" ");
            if (n == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            iRCConfiguration.addSmiley(string2, string3);
        }
    }

    private void configureFonts(IRCConfiguration iRCConfiguration) {
        StringParser stringParser = new StringParser();
        String[] stringArray = this.getArray("style:sourcefontrule");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            String[] stringArray2 = stringParser.parseString(string);
            if (stringArray2.length < 4) continue;
            String string2 = stringArray2[0].toLowerCase(Locale.ENGLISH);
            String string3 = stringArray2[1].toLowerCase(Locale.ENGLISH);
            String string4 = stringArray2[2].toLowerCase(Locale.ENGLISH);
            if (string4.startsWith("'") && string4.endsWith("'")) {
                string4 = string4.substring(1, string4.length() - 1);
            }
            int n = new Integer(stringArray2[3].toLowerCase(Locale.ENGLISH));
            iRCConfiguration.setFont(string2, string3, new Font(string4, 0, n));
        }
    }

    private void configureTextColors(IRCConfiguration iRCConfiguration) {
        String[] stringArray = this.getArray("style:sourcecolorrule");
        for (int i = 0; i < stringArray.length; ++i) {
            StringTokenizer stringTokenizer = new StringTokenizer(stringArray[i]);
            if (!stringTokenizer.hasMoreElements()) continue;
            String string = (String)stringTokenizer.nextElement();
            if (!stringTokenizer.hasMoreElements()) continue;
            String string2 = (String)stringTokenizer.nextElement();
            Color[] colorArray = new Color[16];
            iRCConfiguration.loadDefaultColors(colorArray);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                int n = string3.indexOf(61);
                if (n < 0) continue;
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                int n2 = Integer.parseInt(string4);
                Color color = new Color(Integer.parseInt(string5, 16));
                if (n2 < 0 || n2 > 15) continue;
                colorArray[n2] = color;
            }
            iRCConfiguration.setSourceColor(string, string2, colorArray);
        }
    }

    private void readSound(IRCConfiguration iRCConfiguration) {
        AudioConfiguration audioConfiguration = iRCConfiguration.getAudioConfiguration();
        if (this.getParameter("soundbeep") != null) {
            audioConfiguration.setBeep(this.getParameter("soundbeep"));
        }
        if (this.getParameter("soundquery") != null) {
            audioConfiguration.setQuery(this.getParameter("soundquery"));
        }
        String[] stringArray = this.getArray("soundword");
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            int n = (string = string.trim()).indexOf(32);
            if (n == -1) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            audioConfiguration.setWord(string2, string3);
        }
    }

    private IRCConfiguration getIRCConfiguration() throws Exception {
        String string = this.getString("gui", "notprovided");
        IRCConfiguration iRCConfiguration = new IRCConfiguration(this.getTextProvider(), this._handler, this._loader, this._sound, this._file, this._provider, new PrefixedParameterProvider(this._provider, string + ":"));
        iRCConfiguration.setJoinList(this.getString("authorizedjoinlist", ""));
        iRCConfiguration.setLeaveList(this.getString("authorizedleavelist", ""));
        iRCConfiguration.setCommandList(this.getString("authorizedcommandlist", ""));
        iRCConfiguration.set("style:floatingasl", this.getBoolean("style:floatingasl", false));
        iRCConfiguration.set("style:floatingaslalpha", this.getInt("style:floatingaslalpha", 170));
        iRCConfiguration.set("style:backgroundimage", this.getBoolean("style:backgroundimage", false));
        iRCConfiguration.set("style:bitmapsmileys", this.getBoolean("style:bitmapsmileys", false));
        iRCConfiguration.set("style:linespacing", this.getInt("style:linespacing", 0));
        iRCConfiguration.set("style:maximumlinecount", this.getInt("style:maximumlinecount", 1024));
        iRCConfiguration.set("aslseparatorstring", this.getString("aslseparatorstring", ""));
        iRCConfiguration.set("noasldisplayprefix", this.getString("noasldisplayprefix", ""));
        iRCConfiguration.set("quitmessage", this.getString("quitmessage", ""));
        iRCConfiguration.set("asl", this.getBoolean("asl", false));
        iRCConfiguration.set("aslmale", this.getString("aslmale", "m"));
        iRCConfiguration.set("aslfemale", this.getString("aslfemale", "f"));
        iRCConfiguration.set("useinfo", this.getBoolean("useinfo", false));
        iRCConfiguration.set("coding", this.getInt("coding", 1));
        iRCConfiguration.set("userid", this.getString("userid", ""));
        iRCConfiguration.set("style:righttoleft", this.getBoolean("style:righttoleft", false));
        iRCConfiguration.set("autoconnection", this.getBoolean("autoconnection", true));
        iRCConfiguration.set("useidentserver", this.getBoolean("useidentserver", true));
        iRCConfiguration.set("multiserver", this.getBoolean("multiserver", false));
        iRCConfiguration.set("aslunknown", this.getString("aslunknown", "x"));
        iRCConfiguration.set("gui", this.getString("gui", null));
        iRCConfiguration.set("fingerreply", this.getString("fingerreply", "A lucky Plouf's IRC user"));
        iRCConfiguration.set("userinforeply", this.getString("userinforeply", "A lucky Plouf's IRC user"));
        iRCConfiguration.set("allowdccchat", this.getBoolean("allowdccchat", true));
        iRCConfiguration.set("allowdccfile", this.getBoolean("allowdccfile", true));
        this.readBackgroundConfig(iRCConfiguration);
        this.readSmileys(iRCConfiguration);
        this.configureFonts(iRCConfiguration);
        this.configureTextColors(iRCConfiguration);
        this.readSound(iRCConfiguration);
        return iRCConfiguration;
    }

    private ServerItem[] readServers(String string, int n, String string2) {
        Vector<ServerItem> vector = new Vector<ServerItem>();
        ServerItem serverItem = new ServerItem();
        serverItem.host = string;
        serverItem.port = new Integer(n);
        serverItem.pass = string2;
        vector.insertElementAt(serverItem, vector.size());
        String[] stringArray = this.getArray("alternateserver");
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            int n2 = string3.indexOf(" ");
            if (n2 < 0) continue;
            String string4 = string3.substring(0, n2).trim();
            String string5 = string3.substring(n2 + 1).trim();
            String string6 = "";
            n2 = string5.indexOf(" ");
            if (n2 >= 0) {
                string6 = string5.substring(n2 + 1).trim();
                string5 = string5.substring(0, n2).trim();
            }
            serverItem = new ServerItem();
            serverItem.host = string4;
            serverItem.port = new Integer(string5);
            serverItem.pass = string6;
            vector.insertElementAt(serverItem, vector.size());
        }
        ServerItem[] serverItemArray = new ServerItem[vector.size()];
        for (int i = 0; i < serverItemArray.length; ++i) {
            serverItemArray[i] = (ServerItem)vector.elementAt(i);
        }
        return serverItemArray;
    }

    private StartupConfiguration getStartupConfiguration() throws Exception {
        String string;
        String string2;
        String string3 = this.getParameter("nick");
        if (string3 == null) {
            throw new Exception("Mandatory 'nick' parameter not provided");
        }
        String string4 = this.getParameter("name");
        if (string4 == null) {
            throw new Exception("Mandatory 'name' parameter not provided");
        }
        String string5 = this.getParameter("host");
        if (string5 == null) {
            throw new Exception("Mandatory 'host' parameter not provided");
        }
        String string6 = this.getParameter("password");
        if (string6 == null) {
            string6 = "";
        }
        if ((string2 = this.getParameter("port")) == null) {
            string2 = "6667";
        }
        int n = new Integer(string2);
        String string7 = this.getParameter("alternatenick");
        if (string7 == null) {
            string7 = string3 + "?";
        }
        if ((string = this.getParameter("serveralias")) == null) {
            string = "";
        }
        ServerItem[] serverItemArray = this.readServers(string5, n, string6);
        String[] stringArray = new String[serverItemArray.length];
        int[] nArray = new int[serverItemArray.length];
        String[] stringArray2 = new String[serverItemArray.length];
        for (int i = 0; i < serverItemArray.length; ++i) {
            stringArray[i] = serverItemArray[i].host;
            nArray[i] = serverItemArray[i].port;
            stringArray2[i] = serverItemArray[i].pass;
        }
        return new StartupConfiguration(string3, string7, string4, stringArray2, stringArray, nArray, string, this.getArray("command"), this.getArray("plugin"));
    }
}

