/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.Channel;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.ServerManager;
import irc.Source;
import irc.StringParser;
import irc.dcc.prv.DCCChatServer;
import irc.dcc.prv.DCCFileHandler;
import java.io.File;
import java.util.Date;
import java.util.Locale;

class FirstLineFilter {
    private IRCServer _server;
    private IRCConfiguration _ircConfiguration;
    private ServerManager _mgr;

    public FirstLineFilter(IRCServer iRCServer, ServerManager serverManager, IRCConfiguration iRCConfiguration) {
        this._ircConfiguration = iRCConfiguration;
        this._mgr = serverManager;
        this._server = iRCServer;
    }

    public void release() {
        this._mgr = null;
        this._server = null;
    }

    public boolean performFromChannelMessage(String string, String string2, String string3) {
        if (!string3.startsWith("\u0001")) {
            return false;
        }
        string3 = string3.substring(1);
        string3 = string3.substring(0, string3.length() - 1);
        String string4 = "";
        String string5 = "";
        int n = string3.indexOf(32);
        if (n == -1) {
            string4 = string3.toLowerCase(Locale.ENGLISH);
        } else {
            string4 = string3.substring(0, n).toLowerCase(Locale.ENGLISH);
            string5 = string3.substring(n + 1);
        }
        if (string4.equals("action")) {
            Channel channel = this._server.getChannel(string, false);
            if (channel != null) {
                channel.action(string2, string5);
            }
        } else if (string4.equals("sound")) {
            this._ircConfiguration.getAudioConfiguration().play(string5);
            this._server.sendStatusMessage("\u0002\u00034[" + string2 + " " + string4.toUpperCase(Locale.ENGLISH) + "]");
        }
        return true;
    }

    public boolean performFromNickMessage(String string, String string2) {
        StringParser stringParser;
        String[] stringArray;
        if (!string2.startsWith("\u0001")) {
            return false;
        }
        string2 = string2.substring(1);
        string2 = string2.substring(0, string2.length() - 1);
        String string3 = "";
        String string4 = "";
        int n = string2.indexOf(32);
        if (n == -1) {
            string3 = string2.toLowerCase(Locale.ENGLISH);
        } else {
            string3 = string2.substring(0, n).toLowerCase(Locale.ENGLISH);
            string4 = string2.substring(n + 1);
        }
        boolean bl = true;
        if (string3.equals("action")) {
            bl = false;
            this._server.getQuery(string, false).action(string, string4);
        } else if (string3.equals("version")) {
            String string5 = "PJIRC " + this._ircConfiguration.getVersion();
            this._server.execute("NOTICE " + string + " :\u0001VERSION " + string5 + "\u0001");
        } else if (string3.equals("ping")) {
            this._server.execute("NOTICE " + string + " :\u0001PING " + string4 + "\u0001");
        } else if (string3.equals("time")) {
            String string6 = new Date().toString();
            this._server.execute("NOTICE " + string + " :\u0001TIME " + string6 + "\u0001");
        } else if (string3.equals("finger")) {
            String string7 = this._ircConfiguration.getS("fingerreply");
            this._server.execute("NOTICE " + string + " :\u0001FINGER " + string7 + "\u0001");
        } else if (string3.equals("userinfo")) {
            String string8 = this._ircConfiguration.getS("userinforeply");
            this._server.execute("NOTICE " + string + " :\u0001USERINFO " + string8 + "\u0001");
        } else if (string3.equals("clientinfo")) {
            String string9 = "This client is a Java application supporting the following CTCP tags : ACTION VERSION PING TIME FINGER USERINFO CLIENTINFO SOUND DCC";
            this._server.execute("NOTICE " + string + " :\u0001CLIENTINFO " + string9 + "\u0001");
        } else if (string3.equals("sound")) {
            this._ircConfiguration.getAudioConfiguration().play(string4);
        } else if (string3.equals("dcc") && (stringArray = (stringParser = new StringParser()).parseString(string4.toLowerCase(Locale.ENGLISH))).length >= 2) {
            Object[] objectArray;
            if (stringArray[0].equals("chat") && stringArray[1].equals("chat") && this._ircConfiguration.getB("allowdccchat") && stringArray.length >= 4) {
                boolean bl2 = false;
                objectArray = this._server.specialRequest("DCCChatRequest", new Object[]{string});
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!((Boolean)objectArray[i]).booleanValue()) continue;
                    bl2 = true;
                }
                if (bl2) {
                    try {
                        DCCChatServer dCCChatServer = new DCCChatServer(this._ircConfiguration, this._server.getNick(), string);
                        dCCChatServer.openActive(stringArray[2], stringArray[3]);
                        this._mgr.newServer(dCCChatServer, false);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
            if (stringArray[0].equals("send") && this._ircConfiguration.getB("allowdccfile") && stringArray.length >= 5) {
                String string10 = stringArray[1];
                objectArray = stringArray[2];
                String string11 = stringArray[3];
                String string12 = stringArray[4];
                Object[] objectArray2 = this._server.specialRequest("DCCFileRequest", new Object[]{string, string10, new Integer(string12)});
                File file = null;
                if (objectArray2.length > 0) {
                    file = (File)objectArray2[0];
                }
                if (file != null) {
                    try {
                        DCCFileHandler dCCFileHandler = new DCCFileHandler(this._ircConfiguration, string, file);
                        dCCFileHandler.receive((String)objectArray, string11, string12);
                        this._mgr.newServer(dCCFileHandler, false);
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
            }
        }
        if (bl) {
            this._server.sendStatusMessage("\u0002\u00034[" + string + " " + string3.toUpperCase(Locale.ENGLISH) + "]");
        }
        return true;
    }

    public boolean performFromNotice(String string, String string2) {
        if (!string2.startsWith("\u0001")) {
            return false;
        }
        string2 = string2.substring(1);
        string2 = string2.substring(0, string2.length() - 1);
        String string3 = "";
        String string4 = "";
        int n = string2.indexOf(32);
        if (n == -1) {
            string3 = string2.toLowerCase(Locale.ENGLISH);
        } else {
            string3 = string2.substring(0, n).toLowerCase(Locale.ENGLISH);
            string4 = string2.substring(n + 1);
        }
        Source source = this._server.getDefaultSource();
        if (string3.equals("ping")) {
            long l = new Long(string4);
            long l2 = new Date().getTime() - l;
            if (source != null) {
                source.report("\u0002\u00034" + this._ircConfiguration.getText(266, string, (double)l2 / 1000.0 + ""));
            }
            return true;
        }
        if (source != null) {
            source.report("\u0002\u00034[" + string + " " + string3.toUpperCase(Locale.ENGLISH) + " reply] : " + string4);
        }
        return true;
    }
}

