/*
 * Decompiled with CFR 0.152.
 */
package irc;

import irc.BasicInterpretor;
import irc.Channel;
import irc.IRCConfiguration;
import irc.IRCServer;
import irc.NotEnoughParametersException;
import irc.Source;
import java.util.Enumeration;

public class IRCInterpretor
extends BasicInterpretor {
    public IRCInterpretor(IRCConfiguration iRCConfiguration) {
        super(iRCConfiguration);
    }

    protected void handleCommand(Source source, String string, String[] stringArray, String[] stringArray2) {
        try {
            IRCServer iRCServer = (IRCServer)source.getServer();
            if (string.equals("amsg")) {
                this.test(string, stringArray, 1);
                Enumeration enumeration = iRCServer.getChannels();
                while (enumeration.hasMoreElements()) {
                    ((Channel)enumeration.nextElement()).sendString(stringArray2[1]);
                }
            } else if (string.equals("ame")) {
                this.test(string, stringArray, 1);
                Enumeration enumeration = iRCServer.getChannels();
                while (enumeration.hasMoreElements()) {
                    ((Channel)enumeration.nextElement()).sendString("/me " + stringArray2[1]);
                }
            } else if (string.equals("list")) {
                if (stringArray.length <= 1) {
                    iRCServer.execute("LIST");
                } else {
                    iRCServer.execute("LIST " + stringArray[1]);
                }
            } else if (string.equals("topic")) {
                this.test(string, stringArray, 2);
                iRCServer.execute("TOPIC " + stringArray[1] + " :" + stringArray2[2]);
            } else if (string.equals("away")) {
                if (stringArray.length <= 1) {
                    iRCServer.execute("AWAY");
                } else {
                    iRCServer.execute("AWAY :" + stringArray2[1]);
                }
            } else if (string.equals("quit")) {
                if (stringArray.length > 1) {
                    iRCServer.execute("QUIT :" + stringArray2[1]);
                } else {
                    iRCServer.execute("QUIT");
                }
            } else if (string.equals("part")) {
                this.test(string, stringArray, 1);
                if (stringArray.length == 2) {
                    iRCServer.execute("PART " + stringArray[1]);
                } else {
                    iRCServer.execute("PART " + stringArray[1] + " :" + stringArray2[2]);
                }
            } else if (string.equals("kick")) {
                this.test(string, stringArray, 2);
                if (stringArray.length == 3) {
                    iRCServer.execute("KICK " + stringArray[1] + " " + stringArray[2]);
                } else {
                    iRCServer.execute("KICK " + stringArray[1] + " " + stringArray[2] + " :" + stringArray2[3]);
                }
            } else if (string.equals("notice")) {
                this.test(string, stringArray, 2);
                iRCServer.execute("NOTICE " + stringArray[1] + " :" + stringArray2[2]);
                source.report("-> -" + stringArray[1] + "- " + stringArray2[2]);
            } else if (string.equals("onotice")) {
                this.test(string, stringArray, 2);
                this.sendString(source, "/notice @" + stringArray[1] + " " + stringArray2[2]);
            } else if (string.equals("join")) {
                this.test(string, stringArray, 1);
                String string2 = stringArray[1];
                if (!(string2.startsWith("#") || string2.startsWith("!") || string2.startsWith("&") || string2.startsWith("+"))) {
                    string2 = '#' + string2;
                }
                if (stringArray.length <= 2) {
                    iRCServer.execute("JOIN " + string2);
                } else {
                    iRCServer.execute("JOIN " + string2 + " " + stringArray[2]);
                }
            } else if (string.equals("j")) {
                this.sendString(source, "/join " + stringArray2[1]);
            } else if (string.equals("query")) {
                this.test(string, stringArray, 1);
                iRCServer.getQuery(stringArray[1], true);
            } else if (string.equals("ignore")) {
                this.test(string, stringArray, 1);
                if (!iRCServer.ignore(stringArray[1])) {
                    iRCServer.addIgnore(stringArray[1]);
                    source.report(this.getText(11, stringArray[1]));
                }
            } else if (string.equals("unignore")) {
                this.test(string, stringArray, 1);
                if (iRCServer.ignore(stringArray[1])) {
                    iRCServer.removeIgnore(stringArray[1]);
                    source.report(this.getText(12, stringArray[1]));
                }
            } else if (string.equals("server")) {
                this.test(string, stringArray, 1);
                int n = 6667;
                String string3 = "";
                if (stringArray.length > 2) {
                    n = new Integer(stringArray[2]);
                }
                if (stringArray.length > 3) {
                    string3 = stringArray[3];
                }
                String string4 = stringArray[1];
                if (iRCServer.isConnected()) {
                    iRCServer.disconnect();
                }
                iRCServer.setServers(new String[]{string4}, new int[]{n}, new String[]{string3});
                iRCServer.connect();
            } else if (string.equals("connect")) {
                iRCServer.connect();
            } else if (string.equals("disconnect")) {
                iRCServer.disconnect();
            } else {
                super.handleCommand(source, string, stringArray, stringArray2);
            }
        }
        catch (NotEnoughParametersException notEnoughParametersException) {
            source.report(this.getText(3, notEnoughParametersException.getMessage()));
        }
    }
}

