/*
 * Decompiled with CFR 0.152.
 */
package irc.gui.pixx;

import irc.EventDispatcher;
import irc.Source;
import irc.gui.pixx.PixxConfiguration;
import java.awt.Component;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;

public class NickMenuHandler
implements ActionListener {
    private String _selectedNick;
    private String _whoisNick;
    private PopupMenu _menu;
    private Source _source;
    private Component _parent;
    private PixxConfiguration _pixxConfiguration;

    public NickMenuHandler(PixxConfiguration pixxConfiguration, Component component, Source source) {
        this._pixxConfiguration = pixxConfiguration;
        this._parent = component;
        this._source = source;
        this._menu = new PopupMenu();
        this._menu.addActionListener(this);
        this._parent.add(this._menu);
    }

    public void release() {
        this._menu.removeActionListener(this);
        this._parent.remove(this._menu);
        this._menu = null;
        this._parent = null;
        this._source = null;
        this._pixxConfiguration = null;
    }

    private String parameters(String string, String[] stringArray) {
        for (int i = 0; i < string.length() - 1; ++i) {
            int n;
            String string2;
            if (string.charAt(i) != '%') continue;
            char c = string.charAt(i + 1);
            if (c == '%') {
                String string3 = string.substring(0, i);
                string2 = string.substring(i + 2);
                string = string3 + "%" + string2;
                continue;
            }
            if (c < '1' || c > '9' || (n = c - 49) >= stringArray.length) continue;
            string2 = string.substring(0, i);
            String string4 = string.substring(i + 2);
            string = string2 + stringArray[n] + string4;
        }
        return string;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        EventDispatcher.dispatchEventAsync((Object)this, (String)"actionPerformedEff", (Object[])new Object[]{actionEvent});
    }

    public void actionPerformedEff(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        String[] stringArray = new String[]{this._selectedNick, this._source.getName(), this._pixxConfiguration.getIRCConfiguration().formatASL(this._whoisNick), this._whoisNick};
        for (int i = 0; i < this._pixxConfiguration.getNickMenuVector().size(); ++i) {
            String[] stringArray2 = (String[])this._pixxConfiguration.getNickMenuVector().elementAt(i);
            if (!stringArray2[0].equals(string)) continue;
            for (int j = 1; j < stringArray2.length; ++j) {
                this._source.sendString(this.parameters(stringArray2[j], stringArray));
            }
        }
    }

    public void popup(String string, String string2, Component component, int n, int n2) {
        if (this._pixxConfiguration.getNickMenuVector().size() == 0) {
            return;
        }
        this._selectedNick = string;
        this._whoisNick = string2;
        this._menu.removeAll();
        Enumeration enumeration = this._pixxConfiguration.getNickMenuVector().elements();
        while (enumeration.hasMoreElements()) {
            String[] stringArray = (String[])enumeration.nextElement();
            if (stringArray[0].equals("--")) {
                this._menu.addSeparator();
                continue;
            }
            this._menu.add(new MenuItem(stringArray[0]));
        }
        this._menu.show(component, n, n2);
    }
}

