<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Foobar; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Functions needet for the Adminlogin
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/**
* Checks if the Login was Sucsessfully
*/
function checkAdminLogin($strName,$strPassword,$bolRemember)
{
    global $neSession;
    if ($neSession->login($strName,$strPassword,$bolRemember)) {
		neRedirect('admin.php');
    } else {
        displayAdminLogin($strName);
    }
}


/**
* draws the Login Screen
*/
function displayAdminLogin($strUserName="")
{
   global $neModuleName,$neTheme,$neSession;
   if (empty($strUserName)) {
       $neTheme->drawTitle(neTranslate('admin_login'));
       echo '<p class="advice">'.neTranslate('message-login').'</p>';
   } else {
       $neTheme->drawTitle(neTranslate('admin_wrong_login'));
       echo '<p class="advice">'.neTranslate('message-wrong_login').'</p>';
   }
   $strContent = '
    <form action="admin.php" method="post">
     <input type="hidden" name="op" value="check_login">
     <table class="formtable">
      <tr class="formtable">
       <th class="formdescr">
        '.neTranslate("user_name").'
       </th>
       <td class="formelement">
        <input name="uname" type="text" class="text" value="'.$strUserName.'">
       </td>
      </tr>
      <tr class="formtable">
       <th class="formdescr">
        '.neTranslate("password").'
       </th>
       <td class="formelement">
        <input name="pass" type="password" class="password">
       </td>
      </tr>
      <tr class="formtable">
       <th class="formdescr">
        '.neTranslate("remember").'
       </th>
       <td class="formelement">
        <input name="remember" id="remember" type="checkbox" class="checkbox">
        <label for="remember">'.neTranslate('remember_login').'</label>
       </td>
      </tr>
      <tr class="formtable">
       <td class="formbuttons" colspan="2">
        <input type="submit" class="submit">
       </td>
      </tr>
     </table>
    </form>
   ';
   $neTheme->drawDialogbox(neTranslate('admin_login'),$strContent);
   $neTheme->drawSite(neTranslate('admin_login'));
}
?>
