<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NukeEvent; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Commonly used function
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.7 $
*/

/**
* This function catches all Errormessages.
* The neErrorHandler outputs all Errormessages to the Screen,
* if the user is a Superadmin.
* It also could mail all Errors, or put them in an Errolog.
* @param integer The Type of the Error 
* @param string The Error Message
* @param string The Name of the File where the Error occours
* @param integer The Number of the Line in the File where the Error occours.
* @param array All Variables of the Moment where the Error occours
*/
function neErrorHandler ($intErrorType, $strErrorMessage, $strFilename, $intLinenum, $arrVars) {
    global $neConfig, $neErrors;
    $neErrors[] = array(
        'type' => $intErrorType,
        'message' => $strErrorMessage,
        'file' => basename($strFilename),
        'line' => $intLinenum,
    );
    // timestamp for the error entry
    $strErrorTime = date("Y-m-d H:i:s (T)");
    if ($neConfig['debug']['error_log'] != false) {
        error_log("$strFilename - $intLinenum: $strErrorMessage\n",3,$neConfig['debug']['error_log']);
    }

    if ($neConfig['debug']['mail_error'] == true) {
        mail(
            $neConfig['notify']['email'],
            "Error Nr. $intErrorType: $strErrorMessage",
            
            "
            $strErrorMessage
            file:	$strFilename
            line:	$intLinenum
            type: $intErrorType
            "
        );
    }
}


/**
* Translates Strings to the user set Language
*
* This function simply reads an very big Array.
* It searches for an Arrayelement called like the parameter it becomes
* If there is such an element it returns the Translation, else it returns
* a Message that pleases to user to do this.
*
* @param string the Phrase that should be translated
* @param boolean if set to true the translation of this Phrase is optional
* @global $neTranslate
* @return string the Translated String
*/
function neTranslate($strPhrase, $bolTranslateOpotional = false) {
	global $neTranslate;
	if (is_array($strPhrase)) {
		$strPhrase = $strPhrase['0'];
	}
	if (isset($neTranslate[$strPhrase])) {
		return $neTranslate[$strPhrase];
	} else {
		if ($bolTranslateOpotional == true) {
			return $strPhrase;
		} else {
			return '[Translate: '.$strPhrase.']';
		}
	}
}

/**
* loads the languagepack for the Usercoosen Language.
*
* @param string The Name of the Module for which the Languagepack should be
*        loaded.
* @return boolean 'true' if the langfile could be loaded, 'false' if not so.
*/
function neGetLang($strModulename) {
	global $neSession, $neTranslate;
	$strLangfile = 'lang-'.$neSession->getLang().'.inc.php';
	$neTranslate_old = $neTranslate;
	if ($strModulename == 'nukeevent' and file_exists('includes/language/'.$strLangfile)) {
		$strLangfile = 'includes/language/'.$strLangfile;
	}
	elseif (file_exists('modules/'.$strModulename.'/language/'.$strLangfile)) {
		$strLangfile = 'modules/'.$strModulename.'/language/'.$strLangfile;
	} else {
		return false;
	}
	include_once ($strLangfile);
	$neTranslate = array_merge($neTranslate_old, $neTranslate);
	unset($neTranslate_old);
	return true;
}

/**
* Redirects to a Site. Also Prints a themed please Wait vou will be redirected Message.
*/
function neRedirect($strUrl) {
	global $neConfig, $neTheme;
	var_dump($_SERVER);
	header("Location: ".$neConfig['site']['url'].'/'.$strUrl);
	$neTheme->drawRedirectPage($strUrl);
}

/**
 * Check a Databaseresult on Errors.
 * Checks if a result returned an Error.
 * If true an Errorpage is drawn, else the function returns 'true'
 *
 * @param object a Resultobject from the PearDB Class
 * @param integer the Line of the command.
 * @param string the Name of the File the Error occours.
 * @param string the SQL Query string.
 * @return boolean
 */
function neGetDbError($result, $line, $file, $query = "") {
	if (DB::isError($result)) {
        global $neTheme, $neModuleName, $neSession, $neConfig;
        $strErrormessage = '<p>'.neTranslate(DB :: errorMessage($result), true).'</p>';
        if ( $neSession->isAdmin($neModuleName) ) {
    	    $strErrormessage .= '<b>'.neTranslate('query').':</b><br/><tt>'.$query.'</tt>';
        }
        if ( $neConfig['debug']['enabled'] == true ) {
         $strErrormessage .= '<p>';
    		$strErrormessage .= neTranslate('near_line').': <b>'.$line.'</b><br />';
    		$strErrormessage .= neTranslate('in_module').': <b>'.$neModuleName.'</b><br />';
    		$strErrormessage .= neTranslate('in_file').': <b>'.basename($file).'</b><br />';
    		$strErrormessage .= '</p>';
    		$strErrormessage .= '<tt>';
    		$strErrormessage .= $result->getDebugInfo();
    		$strErrormessage .= '</tt>';
    	}
		$neTheme->drawErrorpage($result->getMessage(),$strErrormessage);       
	} else {
		return true;
	}
}

/**
 * Show a quick and dirty Errormessage.
 * @param string the error .
 * @return boolean
 */
function neDrawError($strError) {
	global $neTheme;
		$neTheme ->drawErrorpage(
		    neTranslate($strError),
		    neTranslate('text-'.$strError)
		);
}

/**
* Formats an Timestamp in a localised timestring.
* @param mixed a Timestamp or a RFC Formatted Datestring to Format
* @param string the format for the output
* date = only the date
* time = only the time
* datetime = Date and Time
* @return string the formatted date and/or time
*/
function neFormatTimestamp($timestamp, $format='date') 
{
	if (is_string($timestamp)) {
		$timestamp = strtotime($timestamp);
	}
	switch (strtolower($format)) {
		case 'time':
			$timestamp = strftime(neTranslate('timeformat'), $timestamp);
			break;
		case 'datetime':
			$timestamp = strftime(neTranslate('datetimeformat'), $timestamp);
			break;
        default:
		    $timestamp = strftime(neTranslate('dateformat'), $timestamp);
			break;
	}
	return ($timestamp);
}

/**
* Encodes the UBB String in HTML.
* Removes all html tags and exchanges only the ubb tags and with html tags.
*
* @access    public
* @param     String      The String that should be encoded
* @return    String
*/
function neEncodeUbb($strText) {
	include_once('HTML/BBCodeParser.php');
	$parser = new HTML_BBCodeParser();
    $parser->setText($strText);
    $parser->parse();
    return nl2br($parser->getParsed());
}

/**
* Checks the String from the Input and removes unallowed HTML.
* This is a good Method to Transform the HTML for Output.
* If you want to transform the Text within an inputfield use
* neTransformInput intead.
*/
function neCheckText($strText, $strMode = 'plain') {
    global $neConfig, $neSession, $neTheme;
    $strText = trim(stripslashes($strText));
    if (@eregi("<[^>]*script*\"\\?/[^>]*>", $strText)) {
      $neTheme->drawErrorpage(neTranslate('illegal_javascript'),neTranslate('text-illegal_javascript'));
    }
    switch (strtolower($strMode)) {
      case 'html':
        if ($neSession -> isAdmin()) {
            $strText = strip_tags($strText, $neConfig['allowedhtml']['admin']);
        } else {
            $strText = strip_tags($strText, $neConfig['allowedhtml']['user']);
        }
        break;
      case 'ubb':
      case 'wiki':
        $strText = strip_tags($strText);
        break;
      default:
        $strText = $strText;
        break;
    }
    return $strText;
}


function neFormatText($strText, $strMode = 'plain') {
    global $neConfig, $neSession, $neTheme;
    $strText = trim(stripslashes($strText));
    //Check for XSS Attacks
    if (@eregi("<[^>]*script*\"\\?/[^>]*>", $strText)) {
      $neTheme->drawErrorpage(neTranslate('illegal_javascript'),neTranslate('text-illegal_javascript'));
    }
    
    switch (strtolower($strMode)) {
      case 'wiki':
        require_once 'Text/Wiki.php';
        $wiki =& new Text_Wiki();
        $strText = $wiki->transform($strText,'Xhtml');
        break;
      case 'html':
          $strText = strip_tags($strText, $neConfig['allowedhtml']['admin']);
          break;
      case 'ubb':
          $parser =& new HTML_BBCodeParser(array('filters' => 'Basic,Extended,Links,Images,Lists,Email'));
          $parser->setText($strText,$strWikiLink = '');
		    $parser->parse();
		    $strText = nl2br($parser->getParsed());
          break;
      default:
          $strText = nl2br(htmlentities($strText));
          break;
    }
    return $strText;
}

/**
* Checks for Words and Cesor them
*/
function neCheckWords($strMessage) {
	global $neConfig;
	return $strMessage;
}


/**
* Gets the Username from cached Array
* @param integer The userId.
* @returns string The users name.
*/

function neGetUserName($intUserId) {
	global $neConfig, $neDb;
	static $arrUsers;
	//Get a Array with all Users from the Database and Cache it!
	if (!is_array($arrUsers)) {
		$result = $neDb -> query('SELECT user_id, user_name FROM '.$neConfig['db']['userprefix'].'_users');
		neGetDbError($result, __LINE__, __FILE__);
		while (list($id,$name) = $result->fetchRow()) {
			$arrUsers[$id] = $name;
		}
	}
	if (array_key_exists($intUserId, $arrUsers)) {
		return $arrUsers[$intUserId];
	} else {
		return $neConfig['default']['username'];
	}
}

/**
* Resizes an image with the gdlib, oder gdlib2 PHP Extension.
* This requires the gdlib extension installed on the Webserver.
* Only resizes images that are bigger than the destination size.
*
* @access private
* @param string complete Path of the file you want to resize
* @param string complete Path and Filename of the Output File.
* @param integer maximal width of the new image.
* @param integer maimal height of the new image. 
*/
function _neGdResize($inputFile, $outputFile, $maxWidth, $maxHeight) 
{
    // Bilddaten ermitteln
    $size=getimagesize($inputFile);
    if ($size == false) {
	    return false;
    }
    $inputWidth=$size[0];
    $inputHeight=$size[1];
    $inputType=$size[2];
    unset($size);

    if ($inputWidth > $inputHeight) {
        $width=$maxWidth;
        $height=intval($inputHeight*$maxWidth/$inputWidth);
    } else {
        $height=$maxHeight;
        $width=intval($inputWidth*$maxHeight/$inputHeight);
    }
    trigger_error("GDLib: resizing $inputFile($inputWidth,$inputHeight) -> $outputFile($width,$height)",E_USER_ERROR);
    switch ($inputType) {
        case 1:
        	$oldImage=ImageCreateFromGIF($inputFile);
            break;      
        case 2: 
            $oldImage=imagecreatefromjpeg($inputFile);
            break;
        case 3:
            $oldImage=imagecreatefrompng($inputFile);
            break;
    }
    $newImage=imageCreate($width,$height);
    imagecopyresized($newImage,$oldImage,0,0,0,0,$width,$height,$inputWidth,$inputHeight);
    switch ($inputType) {
        case 1:
        	Imagegif($newImage,$outputFile);
            break;      
        case 2: 
            imagejpeg($newImage,$outputFile);
            break;
        case 3:
            imagepng($newImage,$outputFile);
            break;
    }
}

function _neGd2Resize($inputFile, $outputFile, $maxWidth, $maxHeight) 
{
	global $neConfig;
    // Bilddaten ermitteln
    $size=getimagesize($inputFile);
    if ($size == false) {
	    return false;
    }
    $inputWidth=$size[0];
    $inputHeight=$size[1];
    $inputType=$size[2];
    unset($size);

    if ($inputWidth > $inputHeight) {
        $width=$maxWidth;
        $height=intval($inputHeight*$maxWidth/$inputWidth);
    } else {
        $height=$maxHeight;
        $width=intval($inputWidth*$maxHeight/$inputHeight);
    }
    switch ($inputType) {
        case 1:
        	$oldImage=ImageCreateFromGIF($inputFile);
        	$newImage=imagecreate($width,$height);
    		imagecopyresized($newImage,$oldImage,0,0,0,0,$width,$height,$inputWidth,$inputHeight);
    		imageinterlace($newImage);
    		Imagepng($newImage,$outputFile);	
            break;      
        case 2:
            $oldImage=imagecreatefromjpeg($inputFile);
        	$newImage=imagecreatetruecolor($width,$height);
    		imagecopyresampled($newImage,$oldImage,0,0,0,0,$width,$height,$inputWidth,$inputHeight);
    		imageinterlace($newImage);
            imagejpeg($newImage,$outputFile,$neConfig['image']['quality']);
            break;
        case 3:
            $oldImage=imagecreatefrompng($inputFile);
        	$newImage=imagecreatetruecolor($width,$height);
    		imagecopyresampled($newImage,$oldImage,0,0,0,0,$width,$height,$inputWidth,$inputHeight);
    		imageinterlace($newImage); 
            imagepng($newImage,$outputFile);
            break;
    }
}

/**
* resizes an Image.
*/
function neResizeImage($inputfile, $outputfile, $sizex, $sizey) {
	global $neConfig;
	if ( !touch($outputfile)) {
		trigger_error("could not create $outputfile",E_USER_ERROR);
	}
	$image = getimagesize($inputfile);
	if ($image == false) {
		trigger_error("$inputfile is not an image",E_USER_ERROR);
		return false;
	} elseif ( ($image[0] <= $sizex) AND ($image[1] <= $sizey) ) {
		copy($inputfile,$outputfile);
	} else {
	    switch ($neConfig['image']['resize_method']) {
		case 'imagemagick' :
			exec($neConfig['image']['imagemagick_path'].' -size '.$sizex.'x'.$sizey.' '.$inputfile.' -resize '.$sizex.'x'.$sizey.' +profile "x" '.$outputfile);
			break;
		case 'gdlib':
		    _neGdResize($inputfile, $outputfile, $sizex, $sizey);
			break;
		case 'gdlib2':
		    _neGd2Resize($inputfile, $outputfile, $sizex, $sizey);
			break;
		default:
    		trigger_error('wrong resize method in config.php',E_USER_ERROR);    
		   copy($inputfile,$outputfile);
	    }		
	}
	if ( file_exists($outputfile) ) {
	    return true;
	} else {
		return false;
		trigger_error("$inputfile wasnt resized to $outputfile",E_USER_ERROR);
	}
}
?>
