<?php
/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NukeEvent; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/**
* An RSS Parser Class.
*
* A Simple Class to Download an Parse RSS Newsfeeds
* @Author $Author: xeniac $
* @License GPL
* @Package nukeevent.rssparser
*/
class RssParser {
    /**
    * The URL of the RSS File that Should be parsed
    */
    var $rssUrl;

    /**
    * The name of the Local Dump of this RSS Newsfeed
    */

    var $rssFile;
    /**
    * a simple boolean that stores if the Parser is inside an <item> tag or not.
    */
    var $insideTag = "";

    /**
    * stores the name of the tag that the parse works on
    */
    var $currentTag;

    /**  the Numeber of the Current Item */
    var $itemNr = 0;

    /** The name of the Channel */
    var $channel;

    /** the number of news items */
    var $items;

    /**
    * The Constructor of the Class, this sets only the Default URL and Filename.
    */
    function RssParser() {
    }

    /**
    * Fetch the RSS File from the Webserver.
    * @access private
    */
    function _fetchRssUrl()
    {
        if (ini_get('allow_url_fopen')){
            if (!$UrlHandle = fopen($this->rssUrl,'r')) {
                trigger_error("could not read $this->rssUrl",E_USER_ERROR);
                return false;
            }
            if (!$FileHandle = fopen($this->rssFile,'w')) {
                trigger_error("could not write $this->rssFile",E_USER_ERROR);
                return false;
            } 
            while(!feof($UrlHandle)) {
                fputs($FileHandle,trim(fgets($UrlHandle,1024)));
            }
            fclose($UrlHandle);
            fclose($FileHandle);    
        }
        return true;
    }//function _fetchRssUrl


    /**
    * Handler for opend XML Tags.
    * This function is needet for the XML Parser. It is the XML Parser Handler
    * for opening Tags.
    * @private
    * @param handle the parser handle.
    * @param string the name of the Tag Currently opend.
    * @param array an associative Array containg all parameters of the Tag.
    */
    function _startElement($parser, $tagName, $tagAttributes)
    {
        if ($this->insideTag == 'item') {
            switch (strtolower($tagName)) {
              case 'title':
                $this->currentTag = 'title';
                $this->items[$this->itemNr]['title'] = "";              
                break;
              case 'link':
                $this->currentTag = 'link';
                $this->items[$this->itemNr]['link'] = "";              
                break;
              case 'description':
                $this->currentTag = 'description';
                $this->items[$this->itemNr]['description'] = "";              
                break;
             default:
             	$this->currentTag = $tagName;
             	$this->items[$this->itemNr][$this->currentTag] = "";
            }
        } //if ($this->insideItem == true)
        elseif ($this->insideTag == 'channel') {
            switch (strtolower($tagName)) {
              case 'title':
                $this->currentTag = 'title';
                $this->channel['title'] = "";              
                break;
              case 'link':
                $this->currentTag = 'link';
                $this->channel['link'] = "";
                break;
              case 'description':
                $this->currentTag = 'description';
                $this->channel['description'] = "";
                break;
            }
        }//elseif ($this->insideChannel == true)
        switch (strtolower($tagName)) {
        case 'item':
            $this->insideTag= 'item';
            break;
        case 'channel':
            $this->insideTag = 'channel';
            break;
        }//switch (strtolower($tagName))
    }//function _startElement


    /**
    * XML handle for the PCDATA between the Tags.
    *
    * This function is needet for the XML Parser.
    * It handles the Character Data that stands between the Tags.
    * The Parser don't know the Tag who contains this Data, so we
    * must use a global var named 'currentTag'.
    * @private
    * @param handle the handle of the XML Parser.
    * @param string the PCDATA found from the Parser.
    * @global currentTag
    * @global channel
    * @global items
    */
    function _characterData($parser, $data)
    {
   		if ($this->insideTag == 'item' ) {
     		switch (strtolower($this->currentTag)) {
          	case 'title':
            	$this->items[$this->itemNr]['title'] .= $data;
            	break;
          	case 'link':
            	$this->items[$this->itemNr]['link'] .= $data;
            	break;
          	case 'description':
            	$this->items[$this->itemNr]['description'] .= $data;
            	break;
          	default:
            	break;
        	}//switch (strtolower($tagName))
    	} elseif ($this->insideTag == 'channel') {
     		switch (strtolower($this->currentTag)) {
        	case 'title':
            	$this->channel['title'] .= $data;
            	break;
          	case 'link':
            	$this->channel['link'] .= $data;
            	break;
          	case 'description':
            	$this->channel['description'] .= $data;
            	break;
     		}
    	}
    }//function _characterData


    /**
    * Function needet for the XML Parser.
    * @private
    */
    function _endElement($parser, $tagName)
    {
        //Handle all Tags within the item Tags, this are the Security Alerts.
        if ($this->insideTag == 'item') {
            switch (strtolower($tagName)) {
              case 'title':
                $this->currentTag = '';
                $this->items[$this->itemNr]['title'] = trim($this->items[$this->itemNr]['title']);
                break;
              case 'link':
                $this->currentTag = '';
                $this->items[$this->itemNr]['link'] = trim($this->items[$this->itemNr]['link']);
                break;
              case 'description':
                $this->currentTag = '';
                $this->items[$this->itemNr]['description'] = trim($this->items[$this->itemNr]['description']);
                break;
              case 'item':
                $this->itemNr++;
                $this->insideItem= false;
                break;
            }
        } //elseif ($this->insideItem == true)
        //handle all Tags within the channel object.
        elseif ($this->insideTag == 'channel') {
			$this->currentTag = "";
            switch (strtolower($tagName)) {
              case 'title':
                $this->channel['title'] = trim($this->channel['title']);
                break;
              case 'link':
                $this->channel['link'] = trim($this->channel['link']);
                break;
              case 'description':
                $this->channel['description'] = trim($this->channel['description']);
                break;
              case 'channel':
                $this->insideTag = false;
                break;
            }
        }//if ($this->insideChannel == true)
    }//function _endElement

    /**
    * Get the RSS Newsfeed and parse it.
    * @return boolean true if parseproces was sucsessfully, else false.
    */
    function parseData() {
        /* Check if the Cachefile exists and if it is modified within the last
           12 hours, else fetch the RSS File and cache it. */
        if ( !file_exists($this->rssFile) OR (time() - filemtime($this->rssFile)) > 43200 ) {
            $err = $this->_fetchRssUrl();
        }
        
        //Read the Local Dump of the RSS Feed.
        if (file_exists($this->rssFile)) {
        	$fp = fopen($this->rssFile,"r");
            if ($fp == false) {        	     
                 return false;
            }     
            $this->rssParser = xml_parser_create();
            xml_set_object($this->rssParser,$this);
            xml_set_element_handler($this->rssParser, "_startElement", "_endElement");
            xml_set_character_data_handler($this->rssParser, "_characterData");
            while ($rssData = fread($fp, 4096)) {
                $err = xml_parse($this->rssParser, $rssData, feof($fp));
                if( $err == false ) {
                    trigger_error(xml_error_string(xml_get_error_code($this->rssParser))
                    ." at line ". xml_get_current_line_number($this->rssParser),E_USER_WARNING);
                }
        }
        fclose($fp);
        xml_parser_free($this->rssParser);
        return true;
        } else {
        	return false;
        }
    }
    
    
    /**
    * Set the URL of the RSS-Newsfeed.
    * @param string The URL of the RSS-Feed
    * @return boolean True if RSS-Feed can be opend, False if an error appears.
    */
    function setRssUrl($rssUrl) {
        $this->rssUrl = $rssUrl;
        return true;
    }

    /**
    * Returns the URL of the RSS-Newsfeed.
    * @return string the URL for the RSS Feed.
    */
    function getRssUrl() {
        return $this->rssUrl;
    }
    
    /**
    * Set the URL of the RSS-Newsfeed.
    * @param string The URL of the RSS-Feed
    * @return boolean True if RSS-Feed can be opend, False if an error appears.
    */
    function setRssFile($fileName) {
        $this->rssFile = $fileName;
        return true;
    }

    /**
    * Returns the URL of the RSS-Newsfeed.
    * @return string the URL for the RSS Feed.
    */
    function getRssFile() {
        return $this->rssFile;
    }


    /**
    * Returns the RSS Content as an Array.
    * @return array an Array with the Headlines.
    */
    function getItems() {
        if ( is_array($this->items) ) {
            return $this->items;
        } else {
            trigger_error("getItems: no Newsitems to return",E_USER_WARNING);
            return false;
        }
    }

    /**
    * Returns the Channel Name
    * @return string the name of the parsed channel
    */
    function getChannelName() {
        return $this->channel['title'];
    }

    /**
    * Returns the Channel Link
    * @return string the link to the Website owning the RSS Channel
    */
    function getChannelLink() {
        return $this->channel['link'];
    }

    /**
    * Returns the Description of the Channel
    * @return string the description of the Channel
    */
    function getChannelDescription() {
        return $this->channel['description'];
    }
}
?>
