<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Index Site that starts the Module you want.
* The index.php loads the Mainfile, sets the Main Template for Output and
* loads the right Module after some security checks. 
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.5 $
*/

/**
* include the mainfile, to load all classes ans structures that are needed.
*/
require_once('includes/mainfile.inc.php');
/**
* The File that loaded the Module, needed for some links.
*/
define('MODULE_LOADER','index.php');
$neTheme->setTemplate('main.tpl');

/*Get the module to load. first look for the parameter "mod"
* in the Post querys, then in the get querys, else look if
* the launcher was the index.php and load the default module.
* If none of these was true load the module named like the
* file the user has called.
*/
if( isset($_POST['mod']) ) {
    $neModuleName = $_POST['mod'];
} elseif( isset($_GET['mod']) ) {
    $neModuleName = $_GET['mod'];
} elseif ( basename($_SERVER['PHP_SELF']) == 'index.php') {
    $neModuleName = $neConfig['default']['module'];
} else {
    $neModuleName = basename($_SERVER['PHP_SELF'],'.php');
}

if( isset($_POST['op']) ) {
    $neOp = $_POST['op'];
} elseif( isset($_GET['op']) ) {
    $neOp = $_GET['op'];
} else {
    $neOp = '';
}

if ( preg_match("/(\.|\/)/",$neModuleName) ){
    $neTheme->drawErrorpage(
    neTranslate('title-access_denied'),
    neTranslate('message-access_denied')
    );
    die();
}

//Display an Error if the File does not exist
if ( !file_exists('modules/'.$neModuleName.'/index.php') ) {
    $neTheme->drawErrorpage(
    neTranslate('title-module_not_exist'),
    neTranslate('message-module_not_exist')
    );
    die();
}

$strQuery  = 'SELECT active, visible ';
$strQuery .= 'FROM '.$neConfig['db']['prefix'].'_modules ';
$strQuery .= 'WHERE name="'.$neModuleName.'"';
$module = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
neGetDbError($module,__LINE__,__FILE__,$strQuery);
if ( $module['active'] == true ) {
    /** If Module is 'Admin only' and User is a Admin */
    if ( $neSession->isAllowed($module['visible']) ) {
        include('modules/'.$neModuleName.'/index.php');
    } else {
        $neTheme->drawErrorpage(
            neTranslate('title-access_denied'),
            neTranslate('message-access_denied')
        );
        die();
    }
    /** if Module is Inactive, but User is a Superuser, include it */
} elseif ( $neSession->isAdmin() == true ) {
    include('modules/'.$neModuleName.'/index.php');
    //else show a Message that this module is deactivated
} else {
    $neTheme->drawErrorpage(
    neTranslate('title-module_is_inactive'),
    neTranslate('message-module_is_inactive')
    );
}
?>