/*
    This file is part of NukeEvent.

    NukeEvent is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    any later version.

    NukeEvent is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with NukeEvent; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Commonly used Javascript functions
*
* @Author $Author: xeniac $
* @License GPL
* @version $Revision: 1.2 $
* @Package nukeevent
*/

/**
 * Displays an confirmation box beforme submit a "DROP/DELETE/ALTER" query.
 * This function is called while clicking links
 *
 * @param   object   the link
 * @param   object   the sql query to submit
 *
 * @return  boolean  whether to run the query or not
 */
function confirmBox(link, message) 
{
    var is_confirmed = confirm(message,'title');
    if (is_confirmed) {
        link.href += '&is_confirmed=1';
    }
    return is_confirmed;
} 


function popHelp(url)
{
    helpWindow = window.open(url,'help','width=480,height=240,resizable=yes,scrollbars=yes');
    helpWindow.focus()
}
