<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Setup File for the Blocks Module.
* Adds or removes the Database entries for the Blocksadmin.
*
* @package nukeevent.modules.blocks
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
* The Setuproutine for the Blocks Adminmodule:
*
* @package nukeevent.modules.blocks
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

function install()
{
    global $neDb, $neConfig;
    addModule('blocks','Blocks');
    addAdminmenu('blocks','admin_blocks','Admin Blocks');
    addAdminmenu('blocks','add','Add Block');

    $strQuery  = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_blocks (';
    $strQuery .= 'topic_id int(3) NOT NULL,';
    $strQuery .= 'topic_name varchar(20) NOT NULL default \'\',';
    $strQuery .= 'topic_title varchar(40) default NULL,';
    $strQuery .= 'topic_description mediumtext,';
    $strQuery .= 'PRIMARY KEY (topic_id),';
    $strQuery .= 'UNIQUE KEY name (topic_name))';
    $result = $neDb->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);
}


switch ($neOp){
    case 'install_module':
        install();
        $neTheme->drawSite();
        break;
}
?>
