<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The Block administration Module.
* This Module allows to add,edit and delete Blocks.  
* Blocks are small pieces of HTML or tiny PHP Scripts to add some usefull
* Stuff to your Site.  
*
* @package nukeevent
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

neGetlang($neModuleName);

/**
* include the file with the whole functions in it.
* @see mainfile.php
*/
require_once('modules/blocks/blocks_functions.php');

if (isset($_POST['id'])) {
    $intBlockId = (int) $_POST['id'];
} elseif (isset($_GET['id'])) {
    $intBlockId = (int) $_GET['id'];
}

if (isset($_POST['mode'])) {
    $bolMode = (int) $_POST['mode'];
} elseif (isset($_GET['mode'])) {
    $bolBlockId = (int) $_GET['mode'];
}

if ( $neSession->IsAdmin($neModuleName) ){
    switch ($neOp) {
       case 'activate':
         activateBlock($intBlockId);
         break;
       case 'deactivate':
         deactivateBlock($intBlockId);
         break;
       case 'change_blocks':
         changeBlockSettings($_POST['visible'],$_POST['weight']);
       	neRedirect('admin.php?mod='.$neModuleName);           
         break;
       case 'add':
         addBlock();
         break;
        case 'delete_block' :
        	if ($_POST['confirm'] == 1) {
            	deleteBlock($intBlockId);
            	neRedirect('admin.php?mod='.$neModuleName);           
        	} else {
                drawDeleteQuestion($intBlockId);
        	}    
            die();
            break;
         
       case 'submit_add':       
         submitAddBlock($_POST['block'],$bolMode,$intBlockId);
       	neRedirect('admin.php?mod='.$neModuleName);           
         break;
       case 'edit_block':
         editBlock($intBlockId);
         break;
       case 'submit_edit':
         submitEditBlock($_POST['block'],$bolMode,$intBlockId);
       	neRedirect('admin.php?mod='.$neModuleName);           
       default:
         adminBlocks();
         break;   }
} else {
    $neTheme->drawErrorpage(
        neTranslate('This module is for admins only'),
        neTranslate('This is only an administration module. You do not have permission to access this module')
    );
}
?>