<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* The NukeEvent Chat Module.
*
* @package nukeevent.modules.chat
* @author $Author: xeniac $
* @version $Revision: 1.1 $
*/

/**
* Draws the Chat Loginpage
*/
function drawLoginForm() 
{
	global $neTheme,$neSession,$neModuleName,$neConfig;
	require_once('modules/content/content_functions.php');
   $tpl = $neTheme->getTemplate($neModuleName,'chatform.tpl');
   $hostList = '';
   foreach($neConfig['chat']['hostname'] as $strHostname) {
       $hostList .= '<option value="'.$strHostname.'">'.$strHostname."</option>\n\r";
   }
   $strChannelList = '';
   foreach($neConfig['chat']['channel'] as $strChannel => $strChannelName) {
       $channelList .= '<option value="'.$strChannel.'">'.$strChannelName."</option>\n\r";
   }
    $tpl->setVariable(array(
        'LABEL_CHAT' => neTranslate('chat'),
        'LABEL_NICKNAME' => neTranslate('nickname'),

        'TEXT' => getContent('module_chat'),
        'NICKNAME' => $neSession->getname(),
        'FORM_ACTION' => MODULE_LOADER.'?mod='.$neModuleName,
        'MODULE' => $neModuleName,
        'OP' => 'chat',
        'HOSTNAME' => $hostList,
        'CHANNEL' => $channelList,
    ));
    $tpl->show();
	
	$neTheme->drawSite(neTranslate('contact_form'));
}

/**
* Draws the Chat Window
*/
function drawChatWindow() 
{
	global $neTheme,$neSession,$neModuleName,$neConfig;
   $tpl = $neTheme->getTemplate($neModuleName,'chat.tpl');
    $tpl->setVariable(array(
        'LABEL_CHAT' => neTranslate('chat'),
        'NICKNAME' => neCheckText($_GET['nick']),
        'HOSTNAME' => neCheckText($_GET['host']),
        'CHANNEL' => neCheckText($_GET['channel']),
        'QUIT_MESSAGE' => neTranslate('quit_message'),
        'LANGUAGE' => $neSession->getLang()
    ));
    $tpl->show();
	
	flush();
	die();
}
?>
