<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Setup for the Content Manager
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.4 $
*/

/**
*/
function install()
{
    global $neDbWrite, $neConfig;
  
    $strQuery  = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_content (';
    $strQuery .= 'page_name varchar(20) NOT NULL, ';
    $strQuery .= 'author    bigint(20)  NOT NULL, ';
    $strQuery .= 'active    int(1)      NOT NULL default \'0\', ';
    $strQuery .= 'title     varchar(40), ';
    $strQuery .= 'content_GROUP     varchar(40), ';
    $strQuery .= 'content   text, ';
    $strQuery .= 'changed   timestamp(14) NOT NULL, ';
    $strQuery .= 'PRIMARY KEY (page_name)) ';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);

    $strQuery  = 'CREATE TABLE IF NOT EXISTS '.$neConfig['db']['prefix'].'_content_archive (';
    $strQuery .= 'page_name varchar(20) NOT NULL, ';
    $strQuery .= 'author    bigint(20)  NOT NULL, ';
    $strQuery .= 'content_group    varchar(40)   NULL, ';
    $strQuery .= 'title     varchar(40)          default \'0\', ';
    $strQuery .= 'content   text, ';
    $strQuery .= 'changed   timestamp(14) NOT NULL, ';
    $strQuery .= 'PRIMARY KEY (page_name,changed)) ';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);

    addModule('content','Content Manager');
    addAdminMenu('content','admin_content','admin content');
    addAdminMenu('content','admin_images','admin images');
    addAdminMenu('content','add','add page');
    addAdminMenu('content','import','import content');
}

/**
* uninstalls the module
*/
function uninstall()
{
    global $neDbWrite, $neConfig;
    $strQuery  = 'DROP TABLE '.$neConfig['db']['prefix'].'_content';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);

    $strQuery  = 'DROP TABLE '.$neConfig['db']['prefix'].'_content_archive';
    $result = $neDbWrite->query($strQuery);
    negetDbError($result,__LINE__,__FILE__,$strQuery);

    removeAdminMenu('content');
    removeModule('content','Content Manager');
}

switch ($neOp){
    case 'install_module':
        install();
        $neTheme->drawSite();
        break;
    case 'uninstall_module':
        uninstall();
        $neTheme->drawSite();
        break;
}

?>
