<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* a module to administrate html pages in NukeEvent.
*
* @package nukeevent.modules.content
* @author $Author: xeniac $
* @version $Revision: 1.5 $
*/

/**
 * the Directory wehre the images will be uploaded
 */
define('IMAGE_DIR', DATA_PATH.'content/');
define('THUMB_DIR', IMAGE_DIR.'thumbnails/');

neGetLang('content');
require_once("modules/$neModuleName/content_functions.php");

if (isset($_POST['name'])) {
    $strName = neCheckText($_POST['name'],'plain');
} elseif (isset($_GET['name'])) {
    $strName = neCheckText($_GET['name'],'plain');
} else {
   $strName = 'index';
}

if (isset($_POST['title'])) {
    $strTitle = neCheckText($_POST['title'],'plain');
} else {
  $strTitle = null;
}

if ( isset($_GET['file']) ) {
    $strFilename = neCheckText($_GET['file'],'plain');
}
if (isset($_POST['content'])) {
    $strContent = neCheckText($_POST['content'],'html');
} else {
    $strContent = null;
}

if (isset($_POST['group'])) {
   echo $strGroup = neCheckText($_POST['group'],'plain');
} else {
    $strGroup = null;
}

if (isset($_GET['is_confirmed']) AND $_GET['is_confirmed'] == 1) {
    $bolConfirmed = true;
} else {
    $bolConfirmed = false;
}

if (MODULE_LOADER == 'admin.php' and empty($neOp)){
    $neOp='admin_content';
}

//check for adminisrative tasks
if ( $neSession->IsAdmin($neModuleName)) {
	
    switch ($neOp) {
      case 'activate':
      require_once('modules/content/admin_functions.php');
        activatePage($strName);
        die();
        break;

      case 'deactivate':
      require_once('modules/content/admin_functions.php');
        deactivatePage($strName);
        die();
        break;
	
      case 'delete':
      require_once('modules/content/admin_functions.php');
        deletePage($strName,$bolConfirmed);
        die();
        break;

      case 'submit':
      require_once('modules/content/admin_functions.php');
        submitPage($strName,$strTitle,$strContent,$strGroup);
        neRedirect(MODULE_LOADER.'?mod=content&op=show&name='.urlencode($strName));
        die();
        break;

      case 'add':
      require_once('modules/content/admin_functions.php');
        addPage();
        die();
        break;

      case 'edit':
      require_once('modules/content/admin_functions.php');
        editPage($strName);
        die();
        break;

      case 'export':
      require_once('modules/content/admin_functions.php');
        exportPage($strName);
        die();
        break;
 
      case 'import':
      require('import_functions.php');
		drawImportForm();
        die();
        break;

      case 'submit_import':
      require('admin_functions.php');
      require('import_functions.php');
        importFiles($HTTP_POST_FILES);
        die();
        break;

     case 'delete_image':
     require('image_functions.php');
        deleteImage($strFilename);
        die();
        break;;
     case 'export_image':
        require('image_functions.php');
	exportImage($strFilename);
	die();
	break;

    case 'admin_images':
    require('image_functions.php');
    adminImages();
    die();
    break;;
 
   	case 'admin_content':
    require_once('modules/content/admin_functions.php');
    adminContent();
    die();
    break;
    }
}

switch ($neOp) {
  default:
    displayContent($strName);
    break;
}
?>
