<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* administrative functions for the events module.
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/

/**
* draws an admin Interface for the Events.
*/
function adminEvents()
{
    global $neConfig, $neDb, $neTheme, $neSession, $neModuleName;
    $tpl = $neTheme->getTemplate('events','event_admin.tpl');

    /* Build the database Query for the waiting News*/
    $strQuery  = 'SELECT event_id, event_start, topic_title,user_name,';
    $strQuery .= 'event_created,event_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['prefix']."_users ";
    $strQuery .= 'WHERE topic_id = event_topic ';
    $strQuery .= "AND user_id = event_author ";
    $strQuery .= "AND event_waiting = '1' ";
    $strQuery .='ORDER BY event_start DESC';

    /* Fetch the waiting news ------------------------------------------------*/
    $eventsWaiting = $neDb->query($strQuery);
    neGetDbError($eventsWaiting,__LINE__,__FILE__,$strQuery);
    $tpl->setCurrentBlock('waiting_events');
    $tpl->setVariable(array(
        'LABEL_WAITING_EVENTS' => neTranslate('events_waiting'),
        'TEXT_WAITING_EVENTS' => neTranslate('text-events_waiting'),
        'LABEL_LAST_EVENTS' => neTranslate('last_events'),
        'TEXT_LAST_EVENTS' => neTranslate('text-last_events'),
        'LABEL_START' => neTranslate('start'),
        'LABEL_TITLE' => neTranslate('title'),
        'LABEL_TOPIC' => neTranslate('topic'),
        'LABEL_CREATED' => neTranslate('created'),
        'LABEL_AUTHOR' => neTranslate('author'),
        'LABEL_FUNCTIONS' => neTranslate('functions'),
        'LABEL_NEW_EVENT' => neTranslate('new_event'),
        'LINK_NEW_EVENT' => 'admin.php?mod=events&amp;op=new_event'
    ));
    if ( $eventsWaiting->numRows() > 0 ) {
	    $tpl->setCurrentBlock('waiting_event_item');
        while ($event = $eventsWaiting->fetchRow(DB_FETCHMODE_ASSOC)) {
            $event['edit']  = '<a href="admin.php?mod=events&amp;op=edit_event&amp;id=';
            $event['edit'] .= $event['event_id'].'">';
            $event['edit'] .= $neTheme->getImage('edit',neTranslate('edit'));
            $event['edit'] .= '</a>';
            $event['edit_links']  = '<a href="admin.php?mod=events&amp;op=edit_links&amp;id=';
            $event['edit_links'] .= $event['event_id'].'">';
            $event['edit_links'] .= $neTheme->getImage('link',neTranslate('edit_links'));
            $event['edit_links'] .= '</a>';
            $event['delete'] = getDeleteLink($event['event_id']);
            $tpl->setVariable(array(
            'EVENT_START' =>  neFormatTimestamp(strtotime($event['event_start']),'date'),
            'EVENT_TITLE' =>  $event['event_title'],
            'TOPIC_TITLE' =>  $event['topic_title'],
            'EVENT_CREATED' => neFormatTimestamp($event['event_created'],'date'),     
            'EVENT_AUTHOR' => $event['user_name'],
            'EVENT_LINK' => MODULE_LOADER.'?mod=events&amp;op=show_event&amp;id='.$event['event_id'],
            'EDIT_LINK' => $event['edit'],
            'EDIT_LINKS_LINK' => $event['edit_links'],
            'DELETE_LINK' => $event['delete'],
            ));
	        $tpl->parseCurrentBlock();
        }
    } else {
        $tpl->setVariable(array(
	    'LABEL_WAITING_EVENT' => neTranslate('events_waiting'),
	    'TEXT_EVENT_WAITING' => neTranslate('text-events_waiting'),
	    'TEXT_NO_EVENTS_WAITING' => neTranslate('text-no_events_waiting')
	));
    }
    $eventsWaiting->free();

    /* Show the latest Events ------------------------------------------------- */
    $strQuery  = 'SELECT event_id, topic_title,user_name,';
    $strQuery .= 'event_start, event_created,event_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events, ';
    $strQuery .= $neConfig['db']['prefix']."_topics, ";
    $strQuery .= $neConfig['db']['prefix']."_users ";
    $strQuery .= 'WHERE topic_id = event_topic ';
    $strQuery .= "AND user_id = event_author ";
    $strQuery .= "AND event_waiting = '0' ";
    $strQuery .='ORDER BY event_created DESC LIMIT 15';
    $eventsLatest = $neDb->query($strQuery);
    neGetDbError($eventsLatest,__LINE__,__FILE__,$strQuery);
    if ( $eventsLatest->numRows() > 0 ) {
	    $tpl->setCurrentBlock('last_event_item');
        while ($event = $eventsLatest->fetchRow(DB_FETCHMODE_ASSOC)) {
            $event['edit']  = '<a href="admin.php?mod=events&amp;op=edit_event&amp;id=';
            $event['edit'] .= $event['event_id'].'">';
            $event['edit'] .= $neTheme->getImage('edit',neTranslate('edit'));
            $event['edit'] .= '</a>';
            $event['edit_links']  = '<a href="admin.php?mod=events&amp;op=edit_links&amp;id=';
            $event['edit_links'] .= $event['event_id'].'">';
            $event['edit_links'] .= $neTheme->getImage('link',neTranslate('edit_links'));
            $event['edit_links'] .= '</a>';
            $event['delete'] = getDeleteLink($event['event_id'],$event['event_title']);
            $tpl->setVariable(array(
            'EVENT_START' =>  neFormatTimestamp(strtotime($event['event_start']),'date'),
            'EVENT_TITLE' =>  $event['event_title'],
            'TOPIC_TITLE' =>  $event['topic_title'],
            'EVENT_CREATED' => neFormatTimestamp($event['event_created'],'date'),     
            'EVENT_AUTHOR' => $event['user_name'],
            'EVENT_LINK' => MODULE_LOADER.'?mod=events&amp;op=show_event&amp;id='.$event['event_id'],
            'EDIT_LINK' => $event['edit'],
            'EDIT_LINKS_LINK' => $event['edit_links'],
            'DELETE_LINK' => $event['delete'],
            ));
	        $tpl->parseCurrentBlock();
        }
    } else {
        $tpl->setVariable(array(
	    'LABEL_WAITING_EVENT' => neTranslate('events_waiting'),
	    'TEXT_EVENT_WAITING' => neTranslate('text-events_waiting'),
	    'TEXT_NO_EVENTS_WAITING' => neTranslate('text-no_events_waiting')
	));
    }
    $eventsLatest->free();

    //Draw the Site.
    $tpl->show();
    $neTheme->drawSite(neTranslate('Admin Events',1));
    die();
}

/**
*Draws a select box to choose if this article should be an top article or not.
*/
function getTopEventSelect($isTopStory) {
    if ($isTopStory == 1) {
       $strOp  = '<option value="1" selected="selected">'.neTranslate('is_top_event').'</option>';
       $strOp .= '<option value="0">'.neTranslate('is_not_top_event').'</option>';
    } else {
       $strOp  = '<option value="1">'.neTranslate('is_top_event').'</option>';
       $strOp .= '<option value="0" selected="selected">'.neTranslate('is_not_top_event').'</option>';
    }
    return $strOp;
}


/**
* draws a selct box with all topics
*/
function getTopicSelect($intDefault) {
    global $neConfig,$neSession, $neDb;
    $strQuery  = 'SELECT topic_id, topic_title ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_topics ';
    $strQuery .= 'ORDER BY topic_title';
    $toplist = $neDb->query($strQuery);
    neGetDbError($toplist,__LINE__,__FILE__,$strQuery);
    $strReturn = '';
    while(list($intId, $strTitle) = $toplist->fetchRow() ) {
        if ( $intDefault == $intId ) {
            $strSelected = 'selected="selected"';
        } else {
            $strSelected = '';
        }
        $strReturn .= '<option value="'.$intId.'" '.$strSelected.'>';
        $strReturn .= $strTitle;
        $strReturn .= '</option>'."\n";
    }
    return $strReturn;
}

function uploadSmallImage($intId,$file) {
    global $neConfig, $neDb;
	 if (empty($file) or empty($intId) ) {
		  trigger_error("uploadSmallImage: empty Values",E_USER_NOTICE);
	     return false;
	 }	
	 $filename = $intId.'_small';
    switch($file['type']) {
        case 'image/jpeg':
		  $filename .= ".jpg";
		  break;	
		  case 'image/gif':
		  $filename .= ".gif";
        break;	
        case 'image/png':
        $filename .= ".png";
        break;	
        default:
		  trigger_error("uploadSmallImage: $file[name] is an unknown Format($file[type])",E_USER_NOTICE);
        return false;
    }
	 @unlink(DATA_PATH.'events/'.$intId.'_small.jpg');
	 @unlink(DATA_PATH.'events/'.$intId.'_small.png');
	 @unlink(DATA_PATH.'events/'.$intId.'_small.gif');
    neResizeImage(
        $file['tmp_name'],
        DATA_PATH.'events/'.$filename,
        $neConfig['events']['smallimage_width'],
        $neConfig['events']['smallimage_height']
    );
    return true;
}

function uploadBigImage($intId,$file) {
    global $neConfig, $neDb;
	 if (empty($file) or empty($intId) ) {
		  trigger_error("uploadBigImage: empty Values",E_USER_NOTICE);
	     return false;
	 }	
	 $filename = $intId.'_big';
    switch($file['type']) {
        case 'image/jpeg':
		  $filename .= ".jpg";
		  break;	
		  case 'image/gif':
		  $filename .= ".gif";
        break;	
        case 'image/png':
        $filename .= ".png";
        break;	
        default:
		  trigger_error("uploadBigImage: $file[name] is an unknown Format($file[type])",E_USER_NOTICE);
        return false;
    }
	 @unlink(DATA_PATH.'events/'.$intId.'_big.jpg');
	 @unlink(DATA_PATH.'events/'.$intId.'_big.png');
	 @unlink(DATA_PATH.'events/'.$intId.'_big.gif');
    neResizeImage(
        $file['tmp_name'],
        DATA_PATH.'events/'.$filename,
        $neConfig['events']['bigimage_width'],
        $neConfig['events']['bigimage_height']
    );
    return true;
}

function showAddEventForm(){
    global $neConfig,$neDb, $neTheme,$neModuleName,$neSession;
    $tpl = $neTheme->getTemplate('events','event_form.tpl');
    $tpl->setVariable(array(
    'LABEL_EVENT_TITLE' => neTranslate('title'),
    'LABEL_EVENT_START' => neTranslate('start'),
    'LABEL_EVENT_END'   => neTranslate('end'),
    'LABEL_EVENT_AUTHOR'   => neTranslate('author'),
    'LABEL_EVENT_TOPIC'   => neTranslate('topic'),
    'LABEL_TOP_EVENT'   => neTranslate('top_event'),
    'LABEL_EVENT_SUMMARY'   => neTranslate('summary'),
    'LABEL_EVENT_LOCATION'   => neTranslate('location'),
    'LABEL_EVENT_DETAIL'   => neTranslate('detail'),
    'FORM_LABEL' => neTranslate('Add Event',true),
    'MODULE' => $neModuleName,
    'OP' => 'submit_new_event',
    'EVENT_ID' => 0,
    'EVENT_AUTHOR' => $neSession->getId(),
    'USER_NAME' => $neSession->getName(),
    'TOP_EVENT' => getTopEventSelect(0),
    'EVENT_TOPIC' => getTopicSelect(1),
    'EVENT_DETAIL' => $neTheme->getHtmlBox('event_detail',''),
    'START_DAY' => date('d'),
    'START_MONTH' => date('m'),
    'START_YEAR' => date('Y'),
    'START_HOUR' => date('h'),
    'START_MINUTE' => date('i'),
    'END_DAY' => date('d'),
    'END_MONTH' => date('m'),
    'END_YEAR' => date('Y'),
    'END_HOUR' => date('h'),
    'END_MINUTE' => date('i'),
    ));
    $tpl->show();
    $neTheme->drawSite(neTranslate('edit_article') );
}

function sendNotifyMail($intId) {
    global $neModuleName, $neTheme ,$neConfig, $neDb, $neSession;
    $strQuery  = 'SELECT event.*, topic_name,topic_title,topic_id, user_name ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events as event, ';
    $strQuery .= $neConfig['db']['prefix'].'_users, ';
    $strQuery .= $neConfig['db']['prefix'].'_topics ';
    $strQuery .= "WHERE event_id='$intId' ";
    $strQuery .= 'AND topic_id=event_topic ';
    $strQuery .= 'AND user_id=event_author ';
    $event = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($event,__LINE__,__FILE__,$strQuery);
    $tpl = $neTheme->getTemplate('events','event_details.tpl');

    /* set the article data */
    $eventStart = strtotime($event['event_start']);
    $eventEnd = strtotime($event['event_end']);    
    $tpl->setVariable(array(
    'LABEL_EVENT_START' => neTranslate('event_start'),
    'LABEL_EVENT_END' => neTranslate('event_end'),
    'LABEL_EVENT_LOCATION' => neTranslate('event_location'),
    'EVENT_ID'  => (int) $event['event_id'],
    'EVENT_AUTHOR'      => neFormatText($event['user_name'],'plain'),
    'EVENT_CREATED'     => neFormatTimestamp($event['event_created'],'date'),
    'EVENT_TITLE'       => neFormatText($event['event_title'],'plain'),
    'EVENT_START_TIME'  => neFormatTimestamp($eventStart,'time'),
    'EVENT_START_DATE'  => neFormatTimestamp($eventStart,'date'),
    'EVENT_END_TIME'    => neFormatTimestamp($eventEnd,'time'),
    'EVENT_END_DATE'    => neFormatTimestamp($eventEnd,'date'),
    'EVENT_LOCATION'    => neFormatText($event['event_location'],'plain'),
    'EVENT_ABSTRACT'    => neFormatText($event['event_summary'],'plain'),
    'EVENT_DETAIL'        => neFormatText($event['event_detail'],'html'),
    'TOPIC_ID'    => (int) $event['topic_id'],
    'TOPIC_NAME'  => neFormatText($event['topic_name'],'plain'),
    'TOPIC_TITLE' => neFormatText($event['topic_title'],'plain'),
    'TOPIC_IMAGE'  => $neConfig['site']['url'].'/'.$neTheme->getImageSrc($event['topic_name'],DATA_PATH.'topics/'),
    'SMALL_IMAGE' => $neConfig['site']['url'].'/'.getSmallImage($event['event_id'],$event['topic_name']),
    'BIG_IMAGE'   => $neConfig['site']['url'].'/'.getBigImage($event['event_id'],$event['topic_name']),
    'DELETE_LINK' => '<a href="'.$neConfig['site']['url'].'/'.MODULE_LOADER.'?mod=events&amp;op=delete_event&amp;id='.$event['event_id'].'">'.neTranslate('delete').'</a>',
	'EDIT_LINK' => '<a href="'.$neConfig['site']['url'].'/'.MODULE_LOADER.'?mod=events&amp;op=edit_event&amp;id='.$event['event_id'].'">'.neTranslate('edit').'</a> ',
	'EDIT_LINKS_LINK' => '<a href="'.$neConfig['site']['url'].'/'.MODULE_LOADER.'?mod=events&amp;op=edit_links&amp;id='.$event['event_id'].'">'.neTranslate('edit_links').'</a> '
     ));
    $strMessage = $tpl->get();

    $strHeaders  = "To: ".$neConfig['notify']['email']."\r\n";
    $strHeaders .= "From: ".$neConfig['notify']['from']."\r\n";
    $strHeaders .= "MIME-Version: 1.0\r\n";
    $strHeaders .= "Content-type: text/html; charset=iso-8859-1\r\n";

    mail(
        $neConfig['notify']['email'],
        neTranslate('new_event').': '.neCheckText($event['event_title']), 
        $strMessage, 
        $strHeaders
    );
}

/**
 * Adds the Event to the Database.
 * Gets a Free ID for the Event and Adds it to the Database.
 * If a Admin added the Event the Event will be activated.
 * After that sentNotifyMail() will be called.
 * @returns boolean true
 */
function addEvent($arrData) {
    global $neConfig,$neDb,$neDbWrite,$neTheme,$neSession;
    $strQuery  = "SELECT event_id FROM ".$neConfig['db']['prefix'].'_events';
    $strQuery .= ' ORDER BY event_id DESC LIMIT 1';
    $eventId = $neDb->getOne($strQuery);
    neGetDbError($eventId,__LINE__,__FILE__,$strQuery);
    $eventId++;
    $eventStart = mktime($arrData['start_hour'],$arrData['start_minute'],0,$arrData['start_month'],$arrData['start_day'],$arrData['start_year']);
    $eventEnd = mktime($arrData['end_hour'],$arrData['end_minute'],0,$arrData['end_month'],$arrData['end_day'],$arrData['end_year']);

    $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_events ';
    $strQuery .= '(event_id,event_author,event_title,event_topic,top_event,';
    $strQuery .= 'event_start,event_end,event_summary,event_location,';
    $strQuery .= 'event_detail,event_waiting,event_created) ';
    $strQuery .= 'VALUES(';
    $strQuery .= $neDbWrite->quote(intval($eventId)).',';
    $strQuery .= $neDbWrite->quote(intval($arrData['event_author'])).',';
    $strQuery .= $neDbWrite->quote(neCheckText($arrData['event_title'],'plain')).',';
    $strQuery .= $neDbWrite->quote(intval($arrData['event_topic'])).',';
    $strQuery .= $neDbWrite->quote(intval($arrData['top_event'])).',';
    $strQuery .= $neDbWrite->quote(date('Y-m-d h:i',$eventStart)).',';
    $strQuery .= $neDbWrite->quote(date('Y-m-d h:i',$eventEnd)).',';
    $strQuery .= $neDbWrite->quote(neCheckText($arrData['event_summary'],'plain')).',';
    $strQuery .= $neDbWrite->quote(neCheckText($arrData['event_location'],'plain')).',';
    $strQuery .= $neDbWrite->quote(neCheckText($arrData['event_detail'],'html')).',';
    if($neSession->isAdmin('events')) {
         $strQuery .= "'0',";
    } else {
         $strQuery .= "'1',";         
    }
    $strQuery .= 'NOW()';
    $strQuery .= ')';
    $result= $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    sendNotifyMail($eventId);
    neRedirect(MODULE_LOADER.'?mod=events&op=edit_event&id='.$eventId);
}

function showEditEventForm($eventId){
    global $neConfig,$neDb, $neTheme,$neModuleName,$neSession;
    $strQuery  = "SELECT event.*,topic_name ";
    $strQuery .= "FROM ".$neConfig['db']['prefix'].'_events as event, ';
    $strQuery .= $neConfig['db']['prefix'].'_topics ';
    $strQuery .= "WHERE event_id=".$neDb->quote($eventId);
    $strQuery .= ' AND topic_id=event_topic';
    $event = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($event,__LINE__,__FILE__,$strQuery);
    $eventStart = strtotime($event['event_start']);
    $eventEnd = strtotime($event['event_end']);
    $tpl = $neTheme->getTemplate('events','event_form.tpl');
    $tpl->setVariable(array(
    'FORM_LABEL' => neTranslate('edit_event'),
    'LABEL_EVENT_TITLE' => neTranslate('title'),
    'LABEL_EVENT_START' => neTranslate('start'),
    'LABEL_EVENT_END'   => neTranslate('end'),
    'LABEL_EVENT_AUTHOR'   => neTranslate('author'),
    'LABEL_EVENT_TOPIC'   => neTranslate('topic'),
    'LABEL_TOP_EVENT'   => neTranslate('top_event'),
    'LABEL_EVENT_SUMMARY'   => neTranslate('summary'),
    'LABEL_EVENT_LOCATION'   => neTranslate('location'),
    'LABEL_EVENT_DETAIL'   => neTranslate('detail'),
    'LABEL_SMALL_IMAGE'   => neTranslate('small_image'),
    'LABEL_BIG_IMAGE'   => neTranslate('big_image'),

    'MODULE' => 'events',
    'OP' => 'submit_edit_event',
    'EVENT_ID' => intval($event['event_id']),
    'EVENT_TITLE' => neCheckText($event['event_title']),
    'EVENT_AUTHOR' => intval($event['event_author']),
    'USER_NAME' => $neSession->getName(),
    'TOP_EVENT' => getTopEventSelect($event['top_event']),
    'EVENT_TOPIC' => getTopicSelect($event['event_topic']),
    'EVENT_LOCATION' => neCheckText($event['event_location']),
    'EVENT_SUMMARY' => neCheckText($event['event_summary']),
    'EVENT_DETAIL' => $neTheme->getHtmlBox('event_detail',$event['event_detail']),
    'START_DAY' => date('d',$eventStart),
    'START_MONTH' => date('m',$eventStart),
    'START_YEAR' => date('Y',$eventStart),
    'START_HOUR' => date('h',$eventStart),
    'START_MINUTE' => date('i',$eventStart),
    'END_DAY' => date('d',$eventEnd),
    'END_MONTH' => date('m',$eventEnd),
    'END_YEAR' => date('Y',$eventEnd),
    'END_HOUR' => date('h',$eventEnd),
    'END_MINUTE' => date('i',$eventEnd),
    'SMALL_IMAGE'=> getSmallImage($event['event_id'],$event['topic_name']),
    'BIG_IMAGE' => getBigImage($event['event_id'],$event['topic_name'])
    ));
    if($neSession->isAdmin('events')){
        $tpl->setVariable(array(
        'LABEL_EVENT_WAITING' => neTranslate('waiting'),
        'LABEL_ACTIVE' => neTranslate('event_active'),
        'LABEL_INACTIVE' => neTranslate('event_inactive')
        ));
        if ($event['event_waiting'] == 1) {
            $tpl->setVariable('EVENT_WAITING_CHECKED','checked="checked"');
        } else {
            $tpl->setVariable('EVENT_ACTIVE_CHECKED','checked="checked"');
        }    
    }
    $tpl->show();
    $neTheme->drawSite(neTranslate('edit_article') );
}

/**
* Updates the _events table with new informations.
* @param array $arrData a contextbased array with the submited Formdata
*/
function editEvent($arrData) {
    global $neConfig,$neDb,$neDbWrite,$neTheme;
    $eventStart = mktime($arrData['start_hour'],$arrData['start_minute'],0,$arrData['start_month'],$arrData['start_day'],$arrData['start_year']);
    $eventEnd = mktime($arrData['end_hour'],$arrData['end_minute'],0,$arrData['end_month'],$arrData['end_day'],$arrData['end_year']);

    $strQuery  = 'UPDATE '.$neConfig['db']['prefix'].'_events ';
    $strQuery .= 'SET ';
    $strQuery .= 'event_author='.$neDbWrite->quote(intval($arrData['event_author'])).',';
    $strQuery .= 'event_title='.$neDbWrite->quote(neCheckText($arrData['event_title'],'plain')).',';
    $strQuery .= 'event_topic='.$neDbWrite->quote(intval($arrData['event_topic'])).',';
    $strQuery .= 'top_event='.$neDbWrite->quote(intval($arrData['top_event'])).',';
    $strQuery .= 'event_start='.$neDbWrite->quote(date('Y-m-d h:i',$eventStart)).',';
    $strQuery .= 'event_end='.$neDbWrite->quote(date('Y-m-d h:i',$eventEnd)).',';
    $strQuery .= 'event_summary='.$neDbWrite->quote(neCheckText($arrData['event_summary'],'plain')).',';
    $strQuery .= 'event_location='.$neDbWrite->quote(neCheckText($arrData['event_location'],'plain')).',';
    $strQuery .= 'event_detail='.$neDbWrite->quote(neCheckText($arrData['event_detail']),'html').',';
    $strQuery .= 'event_waiting='.$neDbWrite->quote(intval($arrData['event_waiting'])).' ';
    $strQuery .= 'WHERE event_id='.$neDbWrite->quote(intval($arrData['event_id']));
    $result= $neDbWrite->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    if (isset($_FILES['small_image']['name'])) {
        uploadSmallImage($arrData['event_id'],$_FILES['small_image']);
    }
    if (isset($_FILES['big_image']['name'])) {
        uploadBigImage($arrData['event_id'],$_FILES['big_image']);
    }
    neRedirect(MODULE_LOADER.'?mod=events&op=show_event&id='.$arrData['event_id']);
}
/**
* Deletes the selected Event from the Database.
* this will purge all related Data for the specified Event.
* @param integer $intEventId the id of the event that shoud be deleted.
* @param boolean $bolConfirmed only start to delete if set to true.
*/
function deleteEvent($intEventId,$bolConfirmed) {
	global $neSession,$neTheme,$neDb,$neDbWrite,$neConfig,$neModuleName;
    if($bolConfirmed == true && $intEventId > 0 && $neSession->isAdmin('events')){
        //Delete the small image
        $strImage = getSmallImage($intEventId);
  	    if ($strImage and unlink($strImage)){
            trigger_error("deleteEvent:$strImage deleted sucsessful",E_USER_NOTICE);
        } else {
            trigger_error("deleteEvent:$strImage not deleted",E_USER_NOTICE);
        }
        //Delete the big image
        $strImage = getBigImage($intEventId);
  	    if ($strImage and unlink($strImage)){
            trigger_error("deleteEvent:$strImage deleted sucsessful",E_USER_NOTICE);
        } else {
            trigger_error("deleteEvent:$strImage not deleted",E_USER_NOTICE);
        }

        //delete the event links
        $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_events_links ';
        $strQuery .= 'WHERE event_id='.$neDbWrite->quote($intEventId);
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);

        //delete the event comments
        $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_events_comments ';
        $strQuery .= 'WHERE thread_id='.$neDbWrite->quote($intEventId);
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);

        //delete the event itself
        $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_events ';
        $strQuery .= 'WHERE event_id='.$neDbWrite->quote($intEventId);
        $result = $neDbWrite->query($strQuery);
        neGetDbError($result,__LINE__,__FILE__,$strQuery);
        neRedirect(MODULE_LOADER."?mod=$neModuleName");
    } else {
        $neTheme->drawDialogbox(
            neTranslate('delete'),
            '<p type="advice">'.neTranslate('text-delete_event').'</p>'.
            '<form>'.
            '<input type="hidden" name="mod" value="'.$neModuleName.'"/>'.
            '<input type="hidden" name="op" value="delete_event"/>'.
            '<input type="hidden" name="id" value="'.$intEventId.'"/>'.
            '<input type="hidden" name="is_confirmed" value="1"/>'.
            '<div align="right">
             <button type="button" onclick="history.back()">'.neTranslate('back').'</button>
             <button type="submit">'.neTranslate('delete').'</button>
             </div>'.
            '</form>'
        );
    $neTheme->drawSite(neTranslate('delete'));
    }
}
?>
