<?php 
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* a block with a simple calendar
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/

global $cookie, $prefix, $currentlang, $lang;

$currentlang=$lang;
$calmodulename="Calendar";
$scb_emptywidth = 10; # Width in pixels of the empty cell before event. Set to 0 to disable.
$scb_maxevents = 15; # How many events will be shown in maximum

if(file_exists("language/simplecal/simplecal-$currentlang.php")) {
	include("language/simplecal/simplecal-$currentlang.php");
}
else {
	include("language/simplecal/simplecal-english.php");
}

if(file_exists("modules/$calmodulename/language/lang-$currentlang.php")) {
	include("modules/$calmodulename/language/lang-$currentlang.php");
}
else {
	include("modules/$calmodulename/language/lang-english.php");
}


function dateAndTime2TimeStamp ($date, $time)
{
  $dates = split("-", $date);
  $times = split(":", $time);
  return mktime($times[0], $times[1], 0, $dates[1], $dates[2], $dates[0]);
}

$datenow = date("Y-m-d");
$sql = "SELECT eid,title,time,hometext,eventDate,startTime FROM ".$prefix."_events WHERE eventDate >= '$datenow' ORDER BY eventDate, startTime LIMIT 0, $scb_maxevents";

$result = mysql_query($sql);
$content = "\n\n<table border=\"0\">";
if (mysql_num_rows($result) == 0)
{
  $content .= "<tr><td class=\"boxcontent\">" . _NOINCOMINGEVENTS . "</td></tr>";
}
$previousdate = "";
while ($event = mysql_fetch_object($result))
{
  if ($previousdate <> $event->eventDate)
  {
    if ($scb_emptywidth)
      $_cs=3;	
    else 
      $_cs=2;
    $content .= sprintf("\n<tr><td colspan=\"%d\" class=\"boxcontent\"><b>", $_cs);
    switch (date("w", dateAndTime2TimeStamp($event->eventDate, $event->startTime)))
    {
	case 0:
	$content .= _CALLONGFIRSTDAY . " ";
	break;
	case 1:
	$content .= _CALLONGSECONDDAY . " ";
	break;
	case 2:
	$content .= _CALLONGTHIRDDAY . " ";
	break;
	case 3:
	$content .= _CALLONGFOURTHDAY . " ";
	break;
	case 4:
	$content .= _CALLONGFIFTHDAY . " ";
	break;
	case 5:
	$content .= _CALLONGSIXTHDAY . " ";
	break;
	case 6:
	$content .= _CALLONGSEVENTHDAY . " ";
	break;
    }	
    $content .= sprintf("%s</b></td></tr>", date(_SCB_DATEFORMAT, dateAndTime2TimeStamp($event->eventDate, $event->startTime)));
    
    $previousdate = $event->eventDate;
  }
  $content .= "\n  <tr>";
  if ($scb_emptywidth)
    $content .= "<td width=\"$scb_emptywidth\" class=\"boxcontent\">&nbsp;</td>";
  $content .= "<td class=\"boxcontent\" valign=\"top\">";	 
  $content .= date(_SCB_TIMEFORMAT, dateAndTime2TimeStamp($event->eventDate, $event->startTime));
  if (strlen($event->hometext)>50)
    $hometext = substr($event->hometext,0,47) . "...";
  else
    $hometext = $event->hometext;
  $content .= "</td><td class=\"boxcontent\" valign=\"top\"><a href=\"modules.php?op=modload&name=$calmodulename&file=index&type=view&eid=$event->eid\" onMouseOver=\"self.status='$hometext'; return true\" onMouseOut=\"self.status=''; return true\">";
  $content .= $event->title;
  $content .= "</a></td></tr>";
}

$content .= "\n</table>\n\n";

echo $content;

?>
