<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* Miscelanious functions needet for almost all parts of the events module.
*
* @package nukeevent.modules.events
* @license http://www.gnu.org/license.html GPL
* @author $Author: xeniac $
* @version $Revision: 1.2 $
*/


/**
* Searches the small image for the event.
* This functions searches a uploaded image  for the Event in DATA_PATH/events/
* If no image was found it returns the topic-image.
* @return string the filename of the image
* @param integer the id of the event.
* @param string the name of the topic
*/
function getSmallImage($intArticleId,$strTopicName=false) {
    global $neTheme;
    $strImage=$neTheme->getImageSrc($intArticleId.'_small',DATA_PATH.'events/');
    if ($strImage) { 
        return $strImage;
    } elseif ($strTopicName) {
        return $neTheme->getImageSrc($strTopicName,DATA_PATH.'topics/');
    } else {
    	return null;
    }
}

/**
* Searches the big image for the event.
* This functions searches a uploaded image  for the Event in DATA_PATH/events/
* @return mixed the filename of the image or false if nothing was found.
* @param integer the id of the event.
* @param string the name of the topic
*/
function getBigImage($intEventId,$strTopicName=null) {
    global $neTheme;
    $strImage = $neTheme->getImageSrc($intEventId.'_big',DATA_PATH.'events/');
    if ($strImage) { 
        return $strImage;
    } else {
        return null;
    }
}

/**
* Generates a delete Link for an event, with a javascript popup.
* @param integer the id of the Event that should be erased.
* @return string the complete Link with a delete Icon.
*/
function getDeleteLink($intEventId,$strEventTitle) {
	global $neTheme;
    if ($intEventId == 0) {
    	return false;
    }
    $strLink = MODULE_LOADER.'?mod=events&amp;op=delete_event&amp;id='.$intEventId;
    $strJScript  = "return confirmBox(this,'";
    $strJScript .= "$strEventTitle\\n".neTranslate('text-delete_event');
    $strJScript .= "')";
    $strReturn  = "<a href=\"$strLink\" onclick=\"$strJScript\">";
    $strReturn .= $neTheme->getImage('delete',neTranslate('delete'));
    $strReturn .= '</a>';
    return $strReturn;
}

function getNumEventsWaiting() {
	global $neConfig,$neDb;
	$strQuery  = 'SELECT count(event_id) ';
	$strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events ';
	$strQuery .= 'WHERE event_waiting=1';
	$result = $neDb->getOne($strQuery);
	neGetDbError($result,__LINE__,__FILE__,$strQuery);
	return $result;
	
}
?>