<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* functions to add,edit and delete Event related links.
*
* @package nukeevent.modules.events
* @author $Author: xeniac $
* @version $Revision: 1.3 $
*/


/**
* Adds an Link to the Database
*/
function addLink($intEventId, $strLinkName, $strLinkUrl) {
    global $neConfig, $neDb,$neDbWrite;
	 $strQuery  = 'SELECT link_id ';
	 $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events_links ';
	 $strQuery .= 'ORDER BY link_id DESC LIMIT 1';
	 $intLinkId = $neDb->getOne($strQuery);
    neGetDbError($intLinkId, __LINE__, __FILE__,$strQuery);
	 $intLinkId++;
	 
    $strQuery  = 'INSERT INTO '.$neConfig['db']['prefix'].'_events_links ';
    $strQuery .= '(link_id,event_id,link_title,link_url) ';
    $strQuery .= 'VALUES(';
    $strQuery .= $neDbWrite->quote($intLinkId).',';
    $strQuery .= $neDbWrite->quote($intEventId).',';
    $strQuery .= $neDbWrite->quote($strLinkName).',';
    $strQuery .= $neDbWrite->quote($strLinkUrl).'';
    $strQuery .= ')';
    $result = $neDbWrite->query($strQuery);
    neGetDbError($result, __LINE__, __FILE__,$strQuery);
    neRedirect(MODULE_LOADER.'?mod=events&op=edit_links&id='.$intEventId);
}

/**
* removes a Link from the Database
*/
function deleteLink($intId,$intTopicId) {
    global $neConfig, $neDb;
    $strQuery  = 'DELETE FROM '.$neConfig['db']['prefix'].'_events_links ';
    $strQuery .= 'WHERE link_id='.$neDb->quote($intId).' LIMIT 1';
    $result = $neDb->query($strQuery);
    neGetDbError($result, __FILE__, __LINE__,$strQuery);
    neRedirect(MODULE_LOADER.'?mod=events&op=edit_links&id='.$intTopicId);
}


/**
*Show the edit Topiclinks Form.
*/
function editLinks($intEventId)
{
    global $neConfig, $neDb, $neTheme,$neSession,$neTheme;
    $strQuery  = 'SELECT  event_title,event_author ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events ';
    $strQuery .= 'WHERE event_id='.$intEventId;
    $event = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($event,__LINE__,__FILE__,$strQuery);
    if(!$neSession->isAdmin('events') or ($event['event_author'] != $neSession->getId())) {
        $neTheme->drawErrorSite('not_allowed','text-not_allowed');
    }
    $neTheme->drawTitle($event['event_title']);
?>
    <form action="<?php echo MODULE_LOADER;?>" method="post" >
    <input name="mod" type="hidden" value="events" />
    <input name="op"  type="hidden" value="add_link" />
    <input name="event_id"  type="hidden" value="<?php echo $intEventId;?>" />
    <p class="advice"><?=neTranslate('text-admin_links');?></p>
    <table class="tableview" align="center">
    <tr class="tableview">
     <th class="tableview">
      <?php echo neTranslate('link_name');?>
     </th>
     <th class="tableview">
      <?php echo neTranslate('link_url');?>
     </th>
     <th class="tableview">
      <?php echo neTranslate('link_functions');?>
     </th>
    </tr>
<?php
    $strQuery  = 'SELECT link_id, link_title, link_url ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_events_links ';
    $strQuery .= 'WHERE event_id='.$neDb->quote($intEventId);
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__,$strQuery);
    while (list($intId, $strName, $strUrl) = $result->fetchRow() ) {
?>
    <tr class="tableview">
     <td class="tableview">
      <?php echo $strName;?>
     </td>
     <td class="tableview">
      <a href="<?php echo $strUrl;?>"><?php echo $strUrl;?></a>
     </td>
     <td class="tableview" align="right">
      <a href="<?php echo MODULE_LOADER; ?>?mod=events&amp;op=delete_link&amp;id=<?php echo $intId?>&amp;article=<?php echo $intId?>"
          onclick="return confirmBox(this,'<?php echo neTranslate('message-really_delete_link')?>')" 
      >
      <img src="images/delete.png" border="0" alt="<?php echo neTranslate('delete')?>"></a>
     </td>
    </tr>
    <?php
    }
    ?>
    <tr class="tableview">
     <td class="tableview">
      <input class="text" style="text" name="link_name" size="30" maxlength="64">
     </td>
     <td class="tableview">
      <input type="text" class="text" name="link_url" size="30" maxlength="255">
     </td>
     <td class="tableview" align="right">
      <input type="submit" class="submit" value="<?php echo neTranslate('add_link');?>" />
     </td>
    </tr>
    <tr class="tableview">
     <td class="formbuttons" colspan="3">
     <button type="button" 
      onclick="self.location.href='<?php echo MODULE_LOADER?>?mod=events&amp;op=show_event&amp;id=<?php echo $intEventId;?>'"><?php echo neTranslate('show_event');?></button></td>
    </tr>
    </table>
    </form>
    <?php
    $neTheme->drawSite(neTranslate('edit_links'));
}

?>
