<?php
/*
This file is part of NukeEvent.

NukeEvent is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
any later version.

NukeEvent is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with NukeEvent; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
/**
* This files includes all functions to show the user related content.
*
* @package nukeevent.modules.faq
* @author $Author: xeniac $
* @version $Revision: 1.1 $
*/

/**
*Shows the Mainpage with all FAQ Categories
*/
function drawMainpage(){
    require_once('modules/content/content_functions.php');
    global $neModuleName, $neConfig, $neDb, $neSession,$neTheme;
    $strQuery  = 'SELECT cat_id, cat_title,cat_description ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_faq_categories ';
    $strQuery .= 'WHERE cat_permission >= '.$neSession->getPermission();
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__);

    $neTheme->drawTitle(neTranslate('faq'));
    $template = $neTheme->getTemplate($neModuleName,'main.tpl');
    $template->setVariable(array(
        'FAQ_MESSAGE' => getContent('module_faq'),
        'ADD_LINK' => '<a href="'.MODULE_LOADER.'?mod=faq&amp;op=add_category">'.$neTheme->getImage('new','new_category').'</a>'
    ));
    $template->setCurrentBlock('category');
    while ( $faq = $result->fetchRow(DB_FETCHMODE_ASSOC) ) {
        $template->setVariable(array(
        'TITLE' => $faq['cat_title'],
        'LINK'  => 'index.php?mod='.$neModuleName.'&amp;op=show&amp;cat='.$faq['cat_id'],
        'DESCRIPTION' => neFormatText($faq['cat_description'],'plain'),
        ));
        if ($neSession->isAdmin('faq')){
            $template->setVariable('EDIT_LINK','<a href="'.MODULE_LOADER.'?mod=faq&amp;op=edit_category&amp;cat='.$faq['cat_id'].'">'.$neTheme->getImage('edit','edit_category').'</a>');
        }    
        $template->parse('category');
    }
    $template->show();
    $neTheme->drawSite(neTranslate('faq'));
}

/**
* Shows the questions and answers of a FAQ Category.
* @param integer The ID of the Category to show.
*/
function drawFaqCategory($intCatId){
    global $neModuleName, $neConfig, $neDb, $neSession,$neTheme;
    $strQuery  = 'SELECT cat_title,cat_description,cat_permission ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_faq_categories ';
    $strQuery .= "WHERE cat_id = '$intCatId'";
    $cat = $neDb->getRow($strQuery,DB_FETCHMODE_ASSOC);
    neGetDbError($cat,__LINE__,__FILE__);
    if (!$neSession->isAllowed($cat['cat_permission'])) {
        $neTheme->drawErrorPage(neTranslate('no_permission'),neTranslate('text-no_permission'));
    }    
    $tpl = $neTheme->getTemplate($neModuleName,'category.tpl');
    $tpl->setVariable(array(
        'CAT_TITLE' => neFormatText($cat['cat_title']),
        'CAT_DESCRIPTION' => neFormatText($cat['cat_description']),
        'EDIT_LINK' => '<a href="'.MODULE_LOADER.'?mod=faq&amp;op=edit_category&amp;cat="'.$intCatId.'>'.$neTheme->getImage('new','new_category').'</a>'
    ));
    $strQuery  = 'SELECT * ';
    $strQuery .= 'FROM '.$neConfig['db']['prefix'].'_faq_questions ';
    $strQuery .= "WHERE question_category = '$intCatId'";
    $result = $neDb->query($strQuery);
    neGetDbError($result,__LINE__,__FILE__);
    while ($question = $result->fetchRow(DB_FETCHMODE_ASSOC)) {
        $tpl->setCurrentBlock('question');
        $tpl->setVariable(array(
        'QUESTION_LINK' => '#'.$question['question_id'],
        'QUESTION_TITLE' => $question['question_title'],
        'QUESTION_ANSWER' => $question['question_answer'],        
        ));
        $tpl->parseCurrentBlock();
        
        $tpl->setCurrentBlock('answer');
        $tpl->setVariable(array(
        'ANSWER_ID' => $question['question_id'],
        'ANSWER_QUESTION' => neFormatText($question['question_title']),
        'ANSWER_TEXT' => neFormatText($question['question_answer']),
        ));
        if ($neSession->isAdmin('faq')) {
            $tpl->setVariable('EDIT_LINK','<a href="'.MODULE_LOADER.'?mod=faq&amp;op=edit_question&amp;id='.$question['question_id'].'">'.$neTheme->getImage('edit','edit_question').'</a>');
        }
        $tpl->parseCurrentBlock();
    }
    if ($neSession->isAdmin('faq')) {
        $tpl->setVariable('ADD_LINK','<a href="'.MODULE_LOADER.'?mod=faq&amp;op=add_question&amp;cat='.$intCatId.'">'.$neTheme->getImage('new','add_question').'</a>');
    }
    $tpl->show();
    $neTheme->drawSite(neTranslate('faq'));
}
?>
